<?php
// DB connection 
require_once '../config/database.php';

//low stock query 
$low_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock <= min_stock AND stock > 0 AND is_active = 1");
$low_stock_stmt->execute();
$low_stock_count = $low_stock_stmt->fetchColumn();

// outstock query 
$out_of_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock = 0 AND is_active = 1");
$out_of_stock_stmt->execute();
$out_of_stock_count = $out_of_stock_stmt->fetchColumn();


$content = file_get_contents('stock-file.txt');
// stock-file.xtx (0,0)
$array = explode(',', $content);

if($array[0] != $low_stock_count){
     // Generate message to lert Stock Low Short Message to Telegram
     echo "Telegram Low stock message <br>";


     file_put_contents('stock-file.xtx', "$low_stock_count, $out_of_stock_count");

}

if($array[1] != $out_of_stock_count){
     // Generate message to lert Out of Stock Short Message to Telegram
     echo "Telegram Out stock message <br>";
     file_put_contents('stock-file.xtx', "$low_stock_count, $out_of_stock_count");

}


