<?php
date_default_timezone_set('Asia/Phnom_Penh');
session_start();

// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include authentication functions and database
require_once 'includes/auth.php';
require_once 'config/database.php';
require_once 'log_functions.php';

// set url default tab
if (!isset($_GET['tab'])) {
    header('Location: stock.php?tab=stockManagement');
    exit();
}
// Check if user is logged in and has appropriate role
if (!isLoggedIn()) {
    header('Location: index.php');
    exit();
}

checkRole(['stock', 'admin', 'owner']);

// Get products from database
// $products_stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1 ORDER BY p_code ASC");
// $products_stmt->execute();
// $products = $products_stmt->fetchAll();

/*
// Handle product actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_product'])) {
        $name = $_POST['name'];
        $description = $_POST['description'];
        $price = $_POST['price'];
        $stock = $_POST['stock'];
        $min_stock = $_POST['min_stock'];
        $category = $_POST['category'];

        // Handle image upload
        $image = 'default-product.jpg';
        if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
            $upload_dir = 'assets/images/';
            $image = uniqid() . '_' . $_FILES['image']['name'];
            move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $image);
        }

        $stmt = $pdo->prepare("INSERT INTO products (name, description, price, stock, min_stock, category, image) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$name, $description, $price, $stock, $min_stock, $category, $image]);

        // Log stock addition
        $product_id = $pdo->lastInsertId();
        $log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, 'in', ?, ?, 'New Product', ?)");
        $log_stmt->execute([$product_id, $stock, $stock, $_SESSION['user_id']]);

        header('Location: stock.php');
        exit;
    } elseif (isset($_POST['update_product'])) {
        $product_id = $_POST['product_id'];
        $name = $_POST['name'];
        $description = $_POST['description'];
        $price = $_POST['price'];
        $stock = $_POST['stock'];
        $min_stock = $_POST['min_stock'];
        $category = $_POST['category'];

        // Get current stock for logging
        $current_stmt = $pdo->prepare("SELECT stock FROM products WHERE id = ?");
        $current_stmt->execute([$product_id]);
        $current_stock = $current_stmt->fetchColumn();

        $stmt = $pdo->prepare("UPDATE products SET name = ?, description = ?, price = ?, stock = ?, min_stock = ?, category = ? WHERE id = ?");
        $stmt->execute([$name, $description, $price, $stock, $min_stock, $category, $product_id]);

        // Log stock change if different
        if ($stock != $current_stock) {
            $change = $stock - $current_stock;
            $log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, 'adjust', ?, ?, 'Stock Adjustment', ?)");
            $log_stmt->execute([$product_id, $change, $stock, $_SESSION['user_id']]);
        }

        header('Location: stock.php');
        exit;
    } elseif (isset($_POST['delete_product'])) {
        $product_id = $_POST['product_id'];

        $stmt = $pdo->prepare("UPDATE products SET is_active = 0 WHERE id = ?");
        $stmt->execute([$product_id]);

        header('Location: stock.php');
        exit;
    } elseif (isset($_POST['save_end_day_stock'])) {
        $product_id = $_POST['product_id'];
        $actual_count = $_POST['actual_count'];
        $date = $_POST['date'];

        // Get product info
        $product_stmt = $pdo->prepare("SELECT stock, min_stock FROM products WHERE id = ?");
        $product_stmt->execute([$product_id]);
        $product = $product_stmt->fetch();

        $beginning_stock = $product['stock'] + $actual_count; // This would need proper calculation
        $sales_qty = 0; // This would need to be calculated from sales data
        $expected_stock = $beginning_stock - $sales_qty;
        $difference = $actual_count - $expected_stock;

        $stmt = $pdo->prepare("INSERT INTO end_day_stock (product_id, date, beginning_stock, sales_qty, expected_stock, actual_count, difference, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$product_id, $date, $beginning_stock, $sales_qty, $expected_stock, $actual_count, $difference, $_SESSION['user_id']]);

        // Update product stock with actual count
        $update_stmt = $pdo->prepare("UPDATE products SET stock = ? WHERE id = ?");
        $update_stmt->execute([$actual_count, $product_id]);

        header('Location: stock.php');
        exit;
    }
}
*/


// Get stock alerts
// $low_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock <= min_stock AND stock > 0 AND is_active = 1");
// $low_stock_stmt->execute();
// $low_stock_count = $low_stock_stmt->fetchColumn();

// $out_of_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock = 0 AND is_active = 1");
// $out_of_stock_stmt->execute();
// $out_of_stock_count = $out_of_stock_stmt->fetchColumn();

// Products with stock info and // Stock alerts
require_once("includes/script-php/product-with-stock.php");
// outstock script 
require_once("includes/script-php/outstock-script.php");


// Get stock history
$history_stmt = $pdo->prepare("
    SELECT sl.*, p.name as product_name, p.p_code, u.username 
    FROM stock_logs sl 
    JOIN products p ON sl.product_id = p.id 
    JOIN users u ON sl.created_by = u.id 
    ORDER BY sl.created_at DESC
");
$history_stmt->execute();
$stock_history = $history_stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="<?= $default_language == 'en' ? 'en' : 'km' ?>">

<head>
    <?php include_once('includes/meta.php') ?>
    <!-- <title>Stock Control - <? #= $system['shop_name'] ?? 'Souvenir Shop' 
                                ?></title> -->
    <style>
        .stock-alert {
            padding: 0.5rem;
            border-radius: 5px;
            margin-bottom: 0.5rem;
        }



        .stock-actions {
            display: flex;
            gap: 0.5rem;
        }

        .stock-input {
            width: 80px;
            padding: 0.25rem;
            text-align: center;
        }
    </style>
</head>

<body>
    <!-- header  -->
    <?php include_once('includes/header.php') ?>
    <div class="container">
        <div class="dashboard">
            <div class="dashboard-header">
                <h2><?= __("Stock Control Dashboard") ?></h2>
                <p><?= __("Welcome") ?>, <?php echo $_SESSION['username']; ?>!</p>
            </div>

            <!-- Stock Alerts -->
            <div class="stats-grid">
                <div class="stat-card">
                    <h3><?= __("Total Products") ?> (<?= __("Qty") ?>)</h3>
                    <!-- <div class="number"><?#php echo count($products); ?></div> -->
                    <div class="number"><?php echo $product_counts['total_stock'] ?? 0; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Low Stock Items") ?></h3>
                    <div class="number" style="color: #f39c12;"><?php echo $low_stock_count; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Out of Stock") ?></h3>
                    <div class="number" style="color: #e74c3c;"><?php echo $out_of_stock_count; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Today Updates") ?></h3>
                    <div class="number"><?php echo count($stock_history); ?></div>
                </div>
            </div>

            <!-- Tabs -->
            <div class="tabs">
                <div class="tab <?= isset($_GET['tab']) && $_GET['tab'] === 'stockManagement' ? 'active' : '' ?>" onclick="openTab(event, 'stockManagement')"><?= __("Manage Stock") ?></div>
                <!-- <div class="tab" onclick="openTab(event, 'addProduct')">Add New Product</div> -->
                <div class="tab" onclick="openTab(event, 'stockHistory')"><?= __("Stock History") ?></div>
                <div class="tab" onclick="openTab(event, 'endDayStock')"><?= __("End Day Stock") ?></div>
            </div>

            <!-- Manage Stock Tab -->
            <?php
            // <!-- Stock Management Tab -->
            include_once("includes/stock-management.php");

            ?>
            <!-- Add Product Tab -->


            <!-- Stock History Tab -->
            <div id="stockHistory" class="tab-content">
                <h3><?= __("Stock History") ?></h3>
                <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                    <button type="button" onclick="printTable('stockhistory_table', 'Stock History')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                    <button type="button" onclick="exportTableToCSV('stockhistory_table', 'Stock History')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                </div>
                <div class="respone-table">
                    <div class="bg-table p-3">
                        <table class="table table-bordered table-striped table-hover" id="stockhistory_table">
                            <thead>
                                <tr>
                                    <th><?= __("Code") ?></th>
                                    <th><?= __("Product") ?></th>
                                    <th><?= __("Change Type") ?></th>
                                    <th><?= __("Change Amount") ?></th>
                                    <th><?= __("New Stock") ?></th>
                                    <th><?= __("Reason") ?></th>
                                    <th><?= __("User") ?></th>
                                    <th><?= __("Date") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($stock_history as $log): ?>
                                    <tr>
                                        <td><?php echo $log['p_code'] ?? 'N/A'; ?></td>
                                        <td><?php echo htmlspecialchars($log['product_name']); ?></td>
                                        <td>
                                            <?php
                                            $change_type = $log['change_type'];
                                            $change_icon = '';
                                            if ($change_type == 'in') {
                                                $change_icon = '<i class="fas fa-arrow-up" style="color: #27ae60;"></i>';
                                            } elseif ($change_type == 'out' || $change_type == 'sale') {
                                                $change_icon = '<i class="fas fa-arrow-down" style="color: #e74c3c;"></i>';
                                            } else {
                                                $change_icon = '<i class="fas fa-adjust" style="color: #3498db;"></i>';
                                            }
                                            echo $change_icon . ' ' . ucfirst($change_type);
                                            ?>
                                        </td>
                                        <td><?php echo $log['change_amount'] > 0 ? '+' . $log['change_amount'] : $log['change_amount']; ?></td>
                                        <td><?php echo $log['new_stock']; ?></td>
                                        <td><?php echo htmlspecialchars($log['reason']); ?></td>
                                        <td><?php echo htmlspecialchars($log['username']); ?></td>
                                        <td><?php echo date('d M Y h:i A', strtotime($log['created_at'])); ?></td>

                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- End Day Stock Tab -->
            <div id="endDayStock" class="tab-content">
                <form method="POST" id="endDayStockForm" enctype="multipart/form-data">
                    <div class="d-flex justify-content-between mb-3">
                        <div>
                            <h3><?= __("End Day Stock Count") ?></h3>
                            <p><?= __("Record the ending stock for each product at the end of the day.") ?></p>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-primary" id="submitConfirmButton" onclick="return confirm('Are you sure you want to save End Day Stock?')">
                                <!-- <button type="submit" class="btn btn-primary" id="submitConfirmButton"> -->
                                <i class="fa fa-upload" aria-hidden="true"></i> <?= __("Save End Day Stock") ?>
                            </button>
                        </div>
                    </div>
                    <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" onclick="printTable('enddaystock_table', 'End Day Stock Count')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                         <button type="button" onclick="exportToCSV()" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                    </div>
                    <!-- <button type="button" onclick="exportToCSV()" class="btn btn-success mb-2">
                        <i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?>
                    </button> -->
                    <!-- <button type="button" onclick="printStockEndDay(enddaystock_table)" class="btn btn-warning mb-2"><i class="fa fa-print" aria-hidden="true"></i> Print</button> -->


                    <input type="hidden" name="save_end_day_stock" value="1">
                    <input type="hidden" name="date" value="<?php echo date('Y-m-d'); ?>">
                    <div class="respone-table">
                        <div class="bg-table p-3">
                            <table class="table table-bordered table-striped table-hover" id="enddaystock_table">
                                <thead>
                                    <tr>
                                        <th><?= __("IMG") ?></th>
                                        <th><?= __("Code") ?></th>
                                        <th><?= __("Product") ?></th>
                                        <th><?= __("Category") ?></th>
                                        <th><?= __("Beginning Stock") ?></th>
                                        <!-- <th>Sales Today</th> -->
                                        <!-- <th>Expected Stock</th> -->
                                        <th><?= __("Actual Count") ?></th>
                                        <!-- <th>Difference</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($products as $product): ?>
                                        <?php
                                        // Calculate sales for today (this is simplified)
                                        $sales_stmt = $pdo->prepare("
                                            SELECT SUM(si.quantity) as total_sold 
                                            FROM sale_items si 
                                            JOIN sales s ON si.sale_id = s.id 
                                            WHERE si.product_id = ? AND DATE(s.created_at) = CURDATE()
                                        ");
                                        $sales_stmt->execute([$product['id']]);
                                        $sales_today = $sales_stmt->fetchColumn() ?: 0;

                                        $beginning_stock = $product['stock'] + $sales_today; // Simplified calculation
                                        $expected_stock = $beginning_stock - $sales_today;
                                        ?>
                                        <tr>
                                            <td>
                                                <img src="assets/images/<?= $product['image'] ?>" alt="Product" width="40">
                                            </td>
                                            <td><?php echo $product['p_code'] ?? 'N/A'; ?></td>
                                            <td><?php echo htmlspecialchars($product['name']); ?></td>
                                            <td><?php echo htmlspecialchars($product['category']); ?></td>
                                            <!-- <td><? #php echo $beginning_stock; 
                                                        ?></td> -->
                                            <!-- <td><? #php echo $sales_today; 
                                                        ?></td> -->
                                            <td><?php echo $beginning_stock; ?></td>
                                            <td>
                                                <input type="hidden" class="d-none" name="product_id[]" value="<?php echo $product['id']; ?>">
                                                <input type="number" name="actual_count[]" value="<?php echo $expected_stock; ?>" class="form-control stock-input" min="0" required>
                                            </td>
                                            <!-- <td id="diff-<? #php echo $product['id']; 
                                                                ?>">0</td> -->
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php include_once('includes/script.php'); ?>

    <script>
        $(document).ready(function() {
            $("#recent_sale_table").dataTable({
                "order": [],
            });
            $("#productsTable").dataTable({
                "order": [],
            });
            $("#salebybill_table").dataTable({
                "order": [],
            });
            $("#salebyproduct").dataTable({
                "order": [],
            });
            $("#salecomparestock_table").dataTable({
                "order": [],
            });
            $("#stockhistory_table").dataTable({
                "order": [],
            });
            // $("#enddaystock_table").dataTable({
            //     "order": [],
            //     lengthMenu: [],
            // });
        });
        $(".datepicker").datepicker({
            format: 'dd M yyyy',
        });
    </script>
    <script>
        // Tab functionality
        function openTab(evt, tabName) {
            const tabcontent = document.getElementsByClassName("tab-content");
            for (let i = 0; i < tabcontent.length; i++) {
                tabcontent[i].classList.remove("active");
                // set url without reloading page
                history.replaceState(null, null, window.location.pathname + '?tab=' + tabName);
            }

            const tablinks = document.getElementsByClassName("tab");
            for (let i = 0; i < tablinks.length; i++) {
                tablinks[i].classList.remove("active");
                // history.replaceState(null, null, window.location.pathname + '?tab=' + tabName);

            }

            document.getElementById(tabName).classList.add("active");
            evt.currentTarget.classList.add("active");
        }

        // Product management functions
        // function editProduct(productId) {
        //     // In a real application, you would fetch product data via AJAX
        //     // For now, we'll use a simplified approach
        //     fetch('get_product.php?id=' + productId)
        //         .then(response => response.json())
        //         .then(product => {
        //             document.getElementById('edit_product_id').value = product.id;
        //             document.getElementById('edit_name').value = product.name;
        //             document.getElementById('edit_description').value = product.description;
        //             document.getElementById('edit_category').value = product.category;
        //             document.getElementById('edit_price').value = product.price;
        //             document.getElementById('edit_stock').value = product.stock;
        //             document.getElementById('edit_min_stock').value = product.min_stock;

        //             if (product.image) {
        //                 document.getElementById('current_image').innerHTML =
        //                     '<strong>Current Image:</strong><br><img src="assets/images/' + product.image + '" style="max-width: 100px; margin-top: 0.5rem;">';
        //             }

        //             document.getElementById('editProductModal').style.display = 'block';
        //         })
        //         .catch(error => {
        //             alert('Error loading product data');
        //         });
        // }


        function deleteProduct(productId) {
            if (confirm('Are you sure you want to delete this product? This action cannot be undone.')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = 'stock.php';

                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'delete_product';
                input.value = '1';
                form.appendChild(input);

                const productInput = document.createElement('input');
                productInput.type = 'hidden';
                productInput.name = 'product_id';
                productInput.value = productId;
                form.appendChild(productInput);

                document.body.appendChild(form);
                form.submit();
            }
        }

        // Search functionality
        document.getElementById('productSearch').addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const rows = document.querySelectorAll('#manageStock tbody tr');

            rows.forEach(row => {
                const productName = row.cells[1].textContent.toLowerCase();
                if (productName.includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });

        // Calculate differences for end day stock
        // document.querySelectorAll('input[name="actual_count[]"]').forEach(input => {
        //     input.addEventListener('change', function() {
        //         console.log("Change");

        //         const row = this.closest('tr');
        //         const expected = parseInt(row.cells[3].textContent);
        //         const actual = parseInt(this.value);
        //         const difference = actual - expected;

        //         const diffCell = row.cells[5];
        //         diffCell.textContent = difference;
        //         diffCell.style.color = difference === 0 ? 'green' : (difference > 0 ? 'blue' : 'red');
        //     });
        // });

        // Calculate differences for end day stock
        // document.querySelectorAll('input[name="actual_count[]"]').forEach(input => {
        //     input.addEventListener('change', function() {
        //         const row = this.closest('tr');
        //         const expected = parseInt(row.cells[3].textContent);
        //         const actual = parseInt(this.value);
        //         const difference = actual - expected;

        //         const diffCell = row.cells[5];
        //         diffCell.textContent = difference;
        //         diffCell.style.color = difference === 0 ? 'green' : (difference > 0 ? 'blue' : 'red');
        //     });
        // });

        // Modal functionality
        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }

        function showChangePassword() {
            showModal('changePasswordModal');
        }

        function showChangePhoto() {
            showModal('changePhotoModal');
        }

        // Close modals when clicking X
        document.querySelectorAll('.close').forEach(closeBtn => {
            closeBtn.addEventListener('click', function() {
                this.closest('.modal').style.display = 'none';
            });
        });

        // Close modals when clicking outside
        window.addEventListener('click', function(event) {
            document.querySelectorAll('.modal').forEach(modal => {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            });
        });

        // Image preview for profile photo
        document.getElementById('profilePhoto')?.addEventListener('change', function(e) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('photoPreview').src = e.target.result;
            }
            reader.readAsDataURL(this.files[0]);
        });

        function calculateDifference(inputElement) {
            const row = inputElement.closest('tr');
            const expected = parseInt(row.cells[3].textContent);
            const actual = parseInt(inputElement.value);
            const difference = actual - expected;

            const diffCell = row.cells[7];
            diffCell.textContent = difference;
            diffCell.style.color = difference === 0 ? 'green' : (difference > 0 ? 'blue' : 'red');
        }

        // Function to initialize calculations for all inputs on page load
        function initializeStockCalculations() {
            document.querySelectorAll('input[name="actual_count[]"]').forEach(input => {
                // Calculate initial difference
                calculateDifference(input);

                // Add change event listener
                input.addEventListener('change', function() {
                    calculateDifference(this);
                });
            });
        }

        // Call on page load
        document.addEventListener('DOMContentLoaded', initializeStockCalculations);
    </script>

    <script>
        var table = $("#enddaystock_table").DataTable({
            "order": [],
        });
        var table = $("#enddaystock_table").DataTable({
            "order": [],
            // Add this to prevent DataTable from modifying the DOM structure
            "destroy": true,
            "retrieve": true
        });
    </script>

    <!-- <script>
        function exportToCSV() {

            table.search('').draw(); // Show all rows
            table.page.len(-1).draw(); // Show all rows (no pagination)
            setTimeout(function() {
                table.page.len(10).draw(); // Reset to default pagination
            }, 100);

            const table = document.getElementById('enddaystock_table');
            const rows = table.querySelectorAll('tr');
            let csvContent = "data:text/csv;charset=utf-8,";

            // Extract headers (skip IMG if you don't want it)
            const headers = [];
            const headerCells = rows[0].querySelectorAll('th');
            headerCells.forEach((cell, index) => {
                if (index !== 0) { // Skip IMG column if needed
                    headers.push(cell.textContent.trim());
                }
            });
            csvContent += headers.join(',') + '\n';

            // Extract data rows
            for (let i = 1; i < rows.length; i++) {
                const row = rows[i];
                const cells = row.querySelectorAll('td');
                const rowData = [];

                cells.forEach((cell, index) => {
                    if (index === 0) return; // Skip image column

                    if (index === 6) { // Actual Count column (has input)
                        const input = cell.querySelector('input[type="number"]');
                        rowData.push(input ? input.value : cell.textContent.trim());
                    } else if (index === 7) { // Difference column
                        const diff = cell.textContent.trim();
                        rowData.push(diff);
                    } else if (index === 3 || index === 4 || index === 5) { // Stock columns
                        rowData.push(cell.textContent.trim().replace(/,/g, ''));
                    } else {
                        rowData.push(`"${cell.textContent.trim().replace(/"/g, '""')}"`);
                    }
                });

                csvContent += rowData.join(',') + '\n';
            }
            // Create download link
            const encodedUri = encodeURI(csvContent);
            const link = document.createElement('a');
            link.setAttribute('href', encodedUri);
            link.setAttribute('download', `end_day_stock_${new Date().toISOString().slice(0,10)}.csv`);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script> -->

    <script>
        function exportToCSV() {
            // First, get the DataTable instance
            const table = $('#enddaystock_table').DataTable();

            // Save current state
            const originalSearch = table.search();
            const originalPageLen = table.page.len();
            const originalDraw = table.page.info();

            // Show all rows
            table.search('').draw();
            table.page.len(-1).draw();

            // Export after DataTable has redrawn
            setTimeout(function() {
                const tableElement = document.getElementById('enddaystock_table');
                const rows = tableElement.querySelectorAll('tr');
                let csvContent = "data:text/csv;charset=utf-8,\ufeff"; // BOM for Excel compatibility

                // Extract headers (skip IMG column)
                const headers = [];
                const headerCells = rows[0].querySelectorAll('th');
                headerCells.forEach((cell, index) => {
                    if (index !== 0) { // Skip IMG column
                        headers.push(`"${cell.textContent.trim().replace(/"/g, '""')}"`);
                    }
                });
                csvContent += headers.join(',') + '\n';

                // Extract data rows
                for (let i = 1; i < rows.length; i++) {
                    const row = rows[i];
                    const cells = row.querySelectorAll('td');
                    const rowData = [];

                    cells.forEach((cell, index) => {
                        if (index === 0) return; // Skip image column

                        let cellValue = '';

                        if (index === 6) { // Actual Count column (has input)
                            const input = cell.querySelector('input[type="number"]');
                            cellValue = input ? input.value : cell.textContent.trim();
                        } else if (index === 3 || index === 4 || index === 5) { // Stock columns (numbers)
                            // Remove commas and convert to number
                            cellValue = cell.textContent.trim().replace(/,/g, '');
                            // Only quote if it contains special characters
                            if (cellValue.match(/[",\n]/)) {
                                cellValue = `"${cellValue.replace(/"/g, '""')}"`;
                            }
                        } else {
                            // For text columns, always quote
                            cellValue = `"${cell.textContent.trim().replace(/"/g, '""')}"`;
                        }

                        rowData.push(cellValue);
                    });

                    // Only add row if it has data (not a DataTables internal row)
                    if (rowData.length > 0) {
                        csvContent += rowData.join(',') + '\n';
                    }
                }

                // Reset to original state
                table.search(originalSearch);
                table.page.len(originalPageLen);
                table.page(originalDraw.page).draw(false);

                // Create download link
                const encodedUri = encodeURI(csvContent);
                const link = document.createElement('a');
                link.setAttribute('href', encodedUri);
                link.setAttribute('download', `end_day_stock_${new Date().toISOString().slice(0,10)}.csv`);
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

            }, 500); // Increased timeout to ensure DataTable has redrawn
        }
    </script>

    <script>
        $('#endDayStockForm').on('submit', function(e) {
            table.search('').draw(); // Show all rows
            table.page.len(-1).draw(); // Show all rows (no pagination)
            setTimeout(function() {
                table.page.len(10).draw(); // Reset to default pagination
            }, 100);
        });
    </script>

</body>

</html>