<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Remove SSE headers - this is not SSE
header('Content-Type: text/html; charset=UTF-8');

// Include database connection
require_once 'config/database.php';

if (isset($_POST['type'])) {
     $type = $_POST['type'];

     // Prepare query based on type
     if ($type === 'all') {
          $stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1 ORDER BY created_at DESC, p_code ASC, stock ASC");
     } elseif ($type === 'low') {
          $stmt = $pdo->prepare("SELECT * FROM products WHERE stock <= min_stock AND stock > 0 AND is_active = 1 ORDER BY created_at DESC, p_code ASC, stock ASC");
     } elseif ($type === 'out') {
          $stmt = $pdo->prepare("SELECT * FROM products WHERE stock = 0 AND is_active = 1 ORDER BY created_at DESC, p_code ASC");
     } else {
          echo '<tr><td colspan="9" class="text-center text-danger">Invalid type parameter.</td></tr>';
          exit;
     }

     try {
          $stmt->execute();
          $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

          if (empty($products)) {
               echo '<tr><td colspan="9" class="text-center text-muted">No products found.</td></tr>';
          } else {
               foreach ($products as $product) {
                    // Determine status
                    $stock = $product['stock'];
                    $min_stock = $product['min_stock'];

                    if ($stock == 0) {
                         $status_class = 'out-of-stock';
                         $status_text = __("Out of Stock");
                    } elseif ($stock <= $min_stock) {
                         $status_class = 'low-stock';
                         $status_text = __("Low Stock");
                    } else {
                         $status_class = 'in-stock';
                         $status_text = __("In Stock");
                    }

                    // Output table row ONLY (no thead)
?>
                    <tr data-stock="<?php echo $stock; ?>" data-min-stock="<?php echo $min_stock; ?>">
                         <td><img src="assets/images/<?= htmlspecialchars($product['image'] ?? 'default-product.jpg') ?>" width="40" alt="Product"></td>
                         <td><?= htmlspecialchars($product['p_code'] ?? 'N/A'); ?></td>
                         <td><?php echo htmlspecialchars($product['name']); ?></td>
                         <td><?php echo htmlspecialchars($product['category'] ?: 'Uncategorized'); ?></td>
                         <td class="<?php echo $status_class; ?>"><?php echo $stock; ?></td>
                         <td><?php echo $min_stock; ?></td>
                         <td>$<?php echo number_format($product['price'], 2); ?></td>
                         <td>
                              <p class="m-0 p-0"><span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span></p>
                              <small class="text-muted"><?= date("d M Y h:i:s A", strtotime($product['created_at'])) ?></small>
                         </td>

                         <td>
                              <button type="button" class="me-1 btn btn-sm btn-success" title="Edit" onclick="editProductButton(<?php echo $product['id']; ?>)">
                                   <i class="fa fa-edit" aria-hidden="true"></i>
                              </button>
                              <button type="button" class="btn btn-sm btn-danger" title="Delete" onclick="deleteProduct(<?php echo $product['id']; ?>)">
                                   <i class="fa fa-trash" aria-hidden="true"></i>
                              </button>
                         </td>
                    </tr>
<?php
               }
          }
     } catch (PDOException $e) {
          echo '<tr><td colspan="9" class="text-center text-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</td></tr>';
     }
} else {
     echo '<tr><td colspan="9" class="text-center text-danger">Invalid request.</td></tr>';
}
// exit;
?>