<?php
date_default_timezone_set('Asia/Phnom_Penh');
$current_file = basename($_SERVER['PHP_SELF']);
// echo $current_file;
if (!isset($_GET['tab'])) {
    $active_tab = 'businessOverview';
    header("Location: owner.php?tab=$active_tab");
} else {
    $active_tab = $_GET['tab'];
}
// if($current_file == 'owner.php'){
//     $active_tab = $_GET['tab'] ?? 'businessOverview';
//     header("Location: owner.php?tab=$active_tab");
// }
// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include authentication functions and database
require_once 'includes/auth.php';
require_once 'config/database.php';
require_once 'log_functions.php';

// Check if user is logged in and has appropriate role
if (!isLoggedIn()) {
    header('Location: index.php');
    exit();
}

checkRole(['owner', 'admin']);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_promotion'])) {
        $name = $_POST['name'];
        $discount_type = $_POST['discount_type'];
        $discount_value = $_POST['discount_value'];
        $applicable_to = $_POST['applicable_to'];
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $min_purchase_amount = $_POST['min_purchase_amount'] ?: 0;
        $description = $_POST['description'];

        $stmt = $pdo->prepare("INSERT INTO promotions (name, discount_type, discount_value, applicable_to, start_date, end_date, min_purchase_amount, description) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$name, $discount_type, $discount_value, $applicable_to, $start_date, $end_date, $min_purchase_amount, $description]);

        header('Location: owner.php');
        exit;
    } elseif (isset($_POST['update_promotion'])) {
        $promotion_id = $_POST['promotion_id'];
        $name = $_POST['name'];
        $discount_type = $_POST['discount_type'];
        $discount_value = $_POST['discount_value'];
        $applicable_to = $_POST['applicable_to'];
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $min_purchase_amount = $_POST['min_purchase_amount'] ?: 0;
        $description = $_POST['description'];

        $stmt = $pdo->prepare("UPDATE promotions SET name = ?, discount_type = ?, discount_value = ?, applicable_to = ?, start_date = ?, end_date = ?, min_purchase_amount = ?, description = ? WHERE id = ?");
        $stmt->execute([$name, $discount_type, $discount_value, $applicable_to, $start_date, $end_date, $min_purchase_amount, $description, $promotion_id]);

        header('Location: owner.php');
        exit;
    } elseif (isset($_POST['delete_promotion'])) {
        $promotion_id = $_POST['promotion_id'];
        $stmt = $pdo->prepare("UPDATE promotions SET is_active = 0 WHERE id = ?");
        $stmt->execute([$promotion_id]);
        header('Location: owner.php');
        exit;
    }
    /*
    elseif (isset($_POST['update_shop_info_bill'])) {
    
        $shop_name = $_POST['shop_name'];
        $address = $_POST['address'];
        $phone = $_POST['phone'];
        $tax_id = $_POST['tax_id'];

        $receipt_header = $_POST['receipt_header'];
        $receipt_footer = $_POST['receipt_footer'];
        $print_logo = isset($_POST['print_logo']) ? 1 : 0;
        $print_tax_id = isset($_POST['print_tax_id']) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE shop_info SET shop_name = ?, address = ?, phone = ?, tax_rate = ?, receipt_header = ?, receipt_footer = ? WHERE id = 1");
        $stmt->execute([$shop_name, $address, $phone, $tax_id, $receipt_header, $receipt_footer]);

        header('Location: owner.php');
        exit;
    } 
    elseif (isset($_POST['update_receipt_settings'])) {
        $receipt_header = $_POST['receipt_header'];
        $receipt_footer = $_POST['receipt_footer'];
        $print_logo = isset($_POST['print_logo']) ? 1 : 0;
        $print_tax_id = isset($_POST['print_tax_id']) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE shop_info SET receipt_header = ?, receipt_footer = ? WHERE id = 1");
        $stmt->execute([$receipt_header, $receipt_footer]);

        header('Location: owner.php');
        exit;
    }
        */
}


// Handle report generation
require_once("includes/script-php/generate-report.php");


// Fetch data for different sections

// Recent sales script or Pos Monitoring
require_once("includes/script-php/recent-sale.php");


// Products with stock info and // Stock alerts
require_once("includes/script-php/product-with-stock.php");




// outstock script 
require_once("includes/script-php/outstock-script.php");


// Shop info
require_once("includes/script-php/shop-info-script.php");



// Sales reports data
require_once("includes/script-php/sale-report-script.php");


// user script 
require_once("includes/script-php/user-script.php");


// Active promotions
$promotions_stmt = $pdo->prepare("SELECT * FROM promotions WHERE is_active = 1 AND end_date >= CURDATE() ORDER BY start_date DESC");
$promotions_stmt->execute();
$promotions = $promotions_stmt->fetchAll();

// Shop info
$shop_info_stmt = $pdo->prepare("SELECT * FROM shop_info WHERE id = 1");
$shop_info_stmt->execute();
$shop_info = $shop_info_stmt->fetch();

// Business overview data
$today_sales_stmt = $pdo->prepare("SELECT SUM(total_amount) as total FROM sales WHERE DATE(created_at) = CURDATE()");
$today_sales_stmt->execute();
$today_sales = $today_sales_stmt->fetchColumn();

$monthly_sales_stmt = $pdo->prepare("SELECT SUM(total_amount) as total FROM sales WHERE MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())");
$monthly_sales_stmt->execute();
$monthly_sales = $monthly_sales_stmt->fetchColumn();

$active_promotions_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM promotions WHERE is_active = 1 AND end_date >= CURDATE()");
$active_promotions_stmt->execute();
$active_promotions_count = $active_promotions_stmt->fetchColumn();

// Top selling products
$top_products_stmt = $pdo->prepare("
    SELECT p.name, SUM(si.quantity) as total_sold, SUM(si.total_price) as revenue
    FROM sale_items si
    JOIN products p ON si.product_id = p.id
    JOIN sales s ON si.sale_id = s.id
    WHERE DATE(s.created_at) = CURDATE()
    GROUP BY p.id, p.name
    ORDER BY total_sold DESC
    LIMIT 5
");
$top_products_stmt->execute();
$top_products = $top_products_stmt->fetchAll();

// Staff performance
$staff_performance_stmt = $pdo->prepare("
    SELECT u.username, u.full_name, COUNT(s.id) as total_bills, SUM(s.total_amount) as total_sales
    FROM sales s
    JOIN users u ON s.cashier_id = u.id
    WHERE DATE(s.created_at) = CURDATE()
    GROUP BY u.id, u.username, u.full_name
    ORDER BY total_sales DESC
");
$staff_performance_stmt->execute();
$staff_performance = $staff_performance_stmt->fetchAll();

// Recent activities (simplified)
$recent_activities_stmt = $pdo->prepare("
    (SELECT 'sale' as type, bill_number as identifier, total_amount as amount, created_at, cashier_id 
     FROM sales 
     ORDER BY created_at DESC 
     LIMIT 5)
    UNION ALL
    (SELECT 'stock' as type, reason as identifier, change_amount as amount, created_at, created_by as cashier_id
     FROM stock_logs 
     ORDER BY created_at DESC 
     LIMIT 5)
    ORDER BY created_at DESC 
    LIMIT 10
");
$recent_activities_stmt->execute();
$recent_activities = $recent_activities_stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="<?= $default_language == 'en' ? 'en' : 'km' ?>">

<head>
    <?php include_once('includes/meta.php'); ?>

    <!-- <title><? # $system['shop_name'] ?? 'Souvenir Shop' 
                ?></title> -->
    <style>
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .dashboard-card {
            background: white;
            padding: 1.5rem;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #3498db;
        }

        .promotion-card {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border-left: 4px solid #e74c3c;
        }

        .promotion-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.5rem;
        }

        .promotion-actions {
            display: flex;
            gap: 0.5rem;
        }

        .activity-item {
            padding: 0.5rem;
            border-bottom: 1px solid #ecf0f1;
        }
    </style>
</head>

<body>
    <!-- header  -->
    <?php include_once('includes/header.php') ?>
    <div class="container">
        <div class="dashboard">
            <div class="dashboard-header">
                <h2><?= __("Owner Dashboard") ?></h2>
                <p><?= __("Welcome") ?>, <?php echo $_SESSION['username']; ?>! <?php echo ucfirst($system['shop_name']); ?></p>
            </div>

            <!-- Quick Stats -->
            <div class="stats-grid">
                <div class="stat-card">
                    <h3><?= __("Total Revenue") ?> (<?= __("Today") ?>)</h3>
                    <div class="number">$<?php echo number_format($today_sales ?: 0, 2); ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Items Sales") ?> (<?= __("Today") ?>)</h3>
                    <div class="number"><?php echo $item_today_sales ?: 0; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Monthly Revenue") ?></h3>
                    <div class="number">$<?php echo number_format($monthly_sales ?: 0, 2); ?></div>
                </div>
                <!-- <div class="stat-card">
                    <h3><?= __("Active Promotions") ?></h3>
                    <div class="number"><?php echo $active_promotions_count; ?></div>
                </div> -->
                <div class="stat-card">
                    <h3><?= __("Today's Activities") ?></h3>
                    <div class="number"><?php echo count($recent_activities); ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Total Products") ?> (<?= __("Qty") ?>)</h3>
                    <!-- <div class="number"><? #php echo count($products); 
                                                ?></div> -->
                    <div class="number"><?php echo $product_counts['total_stock'] ?? 0; ?></div>

                </div>
            </div>

            <!-- Tabs Navigation -->
            <div class="row bg-light p-1 rounded-3 mb-4 tabs">
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab active" onclick="openTab(event, 'businessOverview')"><?= __("Business Overview") ?></div>
                </div>
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'posMonitoring')"><?= __("POS Monitoring") ?></div>
                </div>
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'stockManagement')"><?= __("Stock Management") ?></div>
                </div>
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'reports')"><?= __("Reports") ?></div>
                </div>
                <!-- <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'promotions')"><?= __("Promotions") ?></div>
                </div> -->
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'customerManagement')"><?= __('Customer') ?></div>
                </div>
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'userManagement')"><?= __("User Management") ?></div>
                </div>
                <div class="col-6 col-md-4 col-lg-2 text-center">
                    <div class="tab" onclick="openTab(event, 'shopSettings')"><?= __("Shop Setting") ?></div>
                </div>
            </div>

            <!-- Business Overview Tab -->
            <div id="businessOverview" class="tab-content active">
                <h3><?= __("Business Overview") ?></h3>
                <div class="dashboard-grid">
                    <div class="dashboard-card">
                        <h3><?= __("Sales Performance") ?></h3>
                        <div style="height: 200px; background: #f8f9fa; display: flex; align-items: center; justify-content: center;">
                            <!-- [Sales Chart Placeholder] -->
                            <br><?= __("Today") ?>: $<?php echo number_format($today_sales ?: 0, 2); ?>
                        </div>
                    </div>
                    <div class="dashboard-card">
                        <h3><?= __("Top Selling Products Today") ?></h3>
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th><?= __("Product") ?></th>
                                    <th><?= __("Units Sold") ?></th>
                                    <th><?= __("Revenue") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($top_products as $product): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($product['name']); ?></td>
                                        <td><?php echo $product['total_sold']; ?></td>
                                        <td>$<?php echo number_format($product['revenue'], 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="dashboard-grid">
                    <div class="dashboard-card">
                        <h3><?= __("Recent Activities") ?></h3>
                        <div style="max-height: 300px; overflow-y: auto;">
                            <?php foreach ($recent_activities as $activity): ?>
                                <div class="activity-item">
                                    <?php if ($activity['type'] === 'sale'): ?>
                                        <strong><?= __("New sale completed") ?></strong>
                                        <div><?php echo htmlspecialchars($activity['identifier']); ?> - $<?php echo number_format($activity['amount'], 2); ?></div>
                                        <small><?php echo date('H:i', strtotime($activity['created_at'])); ?></small>
                                    <?php else: ?>
                                        <strong>Stock updated</strong>
                                        <div><?php echo htmlspecialchars($activity['identifier']); ?> - Change: <?php echo $activity['amount']; ?></div>
                                        <small><?php echo date('H:i', strtotime($activity['created_at'])); ?></small>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="dashboard-card">
                        <h3><?= __("Staff Performance Today") ?></h3>
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th><?= __("Staff") ?></th>
                                    <th><?= __("Total Sales") ?></th>
                                    <th><?= __("Total Bills") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($staff_performance as $staff): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($staff['full_name'] ?: $staff['username']); ?></td>
                                        <td>$<?php echo number_format($staff['total_sales'], 2); ?></td>
                                        <td><?php echo $staff['total_bills']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php
            // <!-- POS Monitoring Tab -->
            include_once("includes/post-monitor.php");

            // <!-- Stock Management Tab -->
            include_once("includes/stock-management.php");

            // <!-- Reports Tab -->
            include_once("includes/report-tab.php");

            // user list tab
            include_once("includes/user-list.php");

            // customer list tab
            include_once("includes/customer-list.php");
            ?>

            <!-- <div id="posMonitoring" class="tab-content">
                <h3>POS Monitoring</h3>
                <p>This section shows real-time POS activity. Redirecting to admin POS monitoring...</p>
                <a href="admin.php#posMonitoring" class="btn">View POS Monitoring</a>
                       
            </div> -->

            <!-- Stock Management Tab -->
            <!-- <div id="stockManagement" class="tab-content">
                <h3>Stock Management</h3>
                <p>Comprehensive stock management interface. Redirecting to admin stock management...</p>
                <a href="admin.php#stockManagement" class="btn">View Stock Management</a>
            </div> -->

            <!-- Reports Tab -->
            <!-- <div id="reports" class="tab-content">
                <h3>Reports</h3>
                <p>Detailed business reports and analytics. Redirecting to admin reports...</p>
                <a href="admin.php#reports" class="btn">View Reports</a>
            </div> -->

            <!-- Promotions Tab -->
            <div id="promotions" class="tab-content">
                <h3><?= __("Promotions & Discounts") ?></h3>

                <div style="margin-bottom: 1rem;">
                    <button class="btn btn-primary" onclick="showAddPromotionModal()">
                        <i class="fas fa-plus"></i> <?= __("Add New Promotion") ?>
                    </button>
                </div>

                <?php foreach ($promotions as $promotion): ?>
                    <div class="promotion-card">
                        <div class="promotion-header">
                            <div>
                                <h4><?php echo htmlspecialchars($promotion['name']); ?></h4>
                                <div><?= __("Valid until") ?>: <?php echo date('M j, Y', strtotime($promotion['end_date'])); ?></div>
                            </div>
                            <div class="promotion-actions">
                                <button class="btn btn-success btn-sm" onclick="editPromotion(<?php echo $promotion['id']; ?>)"><i class="fa fa-edit" aria-hidden="true"></i></button>
                                <button class="btn btn-danger btn-sm" onclick="deletePromotion(<?php echo $promotion['id']; ?>)"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            </div>
                        </div>
                        <div>
                            <strong><?= __("Type") ?>:</strong>
                            <?php
                            $type_text = '';
                            if ($promotion['discount_type'] === 'percentage') {
                                $type_text = 'Percentage Discount';
                            } elseif ($promotion['discount_type'] === 'fixed') {
                                $type_text = 'Fixed Amount Discount';
                            } else {
                                $type_text = 'Bundle Offer';
                            }
                            echo $type_text;
                            ?> |
                            <strong><?= __("Value") ?>:</strong>
                            <?php
                            if ($promotion['discount_type'] === 'percentage') {
                                echo $promotion['discount_value'] . '%';
                            } elseif ($promotion['discount_type'] === 'fixed') {
                                echo '$' . $promotion['discount_value'];
                            } else {
                                echo $promotion['discount_value'] . ' free item(s)';
                            }
                            ?> |
                            <strong><?= __("Applicable to") ?>:</strong> <?php echo ucfirst($promotion['applicable_to']); ?> |
                            <strong><?= __("Status") ?>:</strong> <span style="color: green;"><?= __("Active") ?></span>
                        </div>
                        <?php if ($promotion['description']): ?>
                            <div style="margin-top: 0.5rem;">
                                <strong><?= __("Description") ?>:</strong> <?php echo htmlspecialchars($promotion['description']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Shop Settings Tab -->
            <div id="shopSettings" class="tab-content">
                <h3><?= __("Shop Settings & Information") ?></h3>
                <?php include_once('includes/shop-setting.php') ?>
            </div>
        </div>

        <!-- Add Promotion Modal -->
        <div id="addPromotionModal" class="modal">
            <div class="modal-content">
                <span class="close">&times;</span>
                <h2><?= __("Add New Promotion") ?></h2>
                <form method="POST">
                    <input type="hidden" name="add_promotion" value="1">
                    <div class="form-group">
                        <label><?= __("Promotion Name") ?></label>
                        <input type="text" class="form-control" name="name" required placeholder="e.g., Summer Sale 20% Off">
                    </div>
                    <div class="form-group">
                        <label><?= __("Promotion Type") ?></label>
                        <select name="discount_type" required class="form-select">
                            <option value=""><?= __("Select Type") ?></option>
                            <option value="percentage"><?= __("Percentage Discount") ?></option>
                            <option value="fixed"><?= __("Fixed Amount Discount") ?></option>
                            <option value="bundle"><?= __("Bundle Offer") ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?= __("Discount Value") ?></label>
                        <input type="text" name="discount_value" class="form-control" required placeholder="e.g., 20 for 20% or 50 for $50 off">
                    </div>
                    <div class="form-group">
                        <label><?= __("Applicable To") ?></label>
                        <select name="applicable_to" required class="form-select">
                            <option value="all"><?= __("All Products") ?></option>
                            <option value="specific"><?= __("Specific Products") ?></option>
                            <option value="category"><?= __("Product Category") ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?= __("Start Date") ?></label>
                        <input type="date" name="start_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="form-group">
                        <label><?= __("End Date") ?></label>
                        <input type="date" name="end_date" class="form-control" required value="<?php echo date('Y-m-d', strtotime('+1 month')); ?>">
                    </div>
                    <div class="form-group">
                        <label><?= __("Minimum Purchase Amount (Optional)") ?></label>
                        <input type="number" name="min_purchase_amount" class="form-control" placeholder="0" step="0.01">
                    </div>
                    <div class="form-group">
                        <label><?= __("Promotion Description") ?></label>
                        <textarea name="description" rows="3" class="form-control" placeholder="Describe the promotion..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary"><?= __("Save Promotion") ?></button>
                </form>
            </div>
        </div>

        <!-- Edit Promotion Modal -->
        <div id="editPromotionModal" class="modal">
            <div class="modal-content">
                <span class="close">&times;</span>
                <h2><?= __("Edit Promotion") ?></h2>
                <form method="POST" id="editPromotionForm">
                    <input type="hidden" name="update_promotion" value="1">
                    <input type="hidden" name="promotion_id" id="edit_promotion_id">
                    <div class="form-group">
                        <label><?= __("Promotion Name") ?></label>
                        <input type="text" name="name" id="edit_promotion_name" required>
                    </div>
                    <div class="form-group">
                        <label><?= __("Promotion Type") ?></label>
                        <select name="discount_type" required class="form-select">
                            <option value=""><?= __("Select Type") ?></option>
                            <option value="percentage"><?= __("Percentage Discount") ?></option>
                            <option value="fixed"><?= __("Fixed Amount Discount") ?></option>
                            <option value="bundle"><?= __("Bundle Offer") ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?= __("Discount Value") ?></label>
                        <input type="text" name="discount_value" class="form-control" required placeholder="e.g., 20 for 20% or 50 for $50 off">
                    </div>
                    <div class="form-group">
                        <label><?= __("Applicable To") ?></label>
                        <select name="applicable_to" required class="form-select">
                            <option value="all"><?= __("All Products") ?></option>
                            <option value="specific"><?= __("Specific Products") ?></option>
                            <option value="category"><?= __("Product Category") ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label><?= __("Start Date") ?></label>
                        <input type="date" name="start_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="form-group">
                        <label><?= __("End Date") ?></label>
                        <input type="date" name="end_date" class="form-control" required value="<?php echo date('Y-m-d', strtotime('+1 month')); ?>">
                    </div>
                    <div class="form-group">
                        <label><?= __("Minimum Purchase Amount (Optional)") ?></label>
                        <input type="number" name="min_purchase_amount" class="form-control" placeholder="0" step="0.01">
                    </div>
                    <div class="form-group">
                        <label><?= __("Promotion Description") ?></label>
                        <textarea name="description" rows="3" class="form-control" placeholder="Describe the promotion..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-success"><?= __("Update Promotion") ?></button>
                </form>
            </div>
        </div>
    </div>
    <?php include_once('includes/script.php'); ?>
    <script>
        $(document).ready(function() {
            $("#recent_sale_table").dataTable({
                "order": [],
            });
            $("#productsTable").dataTable({
                "order": [],
            });
            $("#salebybill_table").dataTable({
                "order": [],
            });
            $("#salebyproduct").dataTable({
                "order": [],
            });
            $("#salecomparestock_table").dataTable({
                "order": [],
            });
            $("#enddaystock_table").dataTable({
                "order": [],
            });
        });

        $(".datepicker").datepicker({
            format: 'dd M yyyy',
        });

        function showAddPromotionModal() {
            document.getElementById("addPromotionModal").style.display = 'block';
        }
    </script>



</body>

</html>