<?php
require_once 'log_functions.php';
// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// If already logged in, redirect to appropriate page
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'includes/auth.php';

    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (loginUser($username, $password)) {
        // Log successful login
        $logger->logLogin($username, 'success');
        header('Location: dashboard.php');
        exit();
    } else {
        // Log failed login
        $logger->logLogin($username, 'failed', 'Invalid credentials');
        $error = __("Invalid username or password");
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include_once('includes/meta.php') ?>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#007bff">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="<?= $system['shop_name'] ?? 'Souvenir Shop' ?>">
    <link rel="manifest" href="manifest.json">
    <link rel="apple-touch-icon" href="pwa-icons/icon-192x192.png">


    <title>Login - <?= $system['shop_name'] ?? 'Souvenir Shop' ?></title>
    <style>
        /* Add to existing styles or create new */
        .pwa-install-btn {
            transition: all 0.3s ease;
        }

        .pwa-install-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 123, 255, 0.4);
        }

        /* Hide install button on iOS */
        @supports (-webkit-touch-callout: none) {
            .pwa-install-btn.ios {
                display: none !important;
            }
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-box">
            <h2 class="text-center">
                <img src="assets/images/<?= $system['logo'] ?? 'logo.png' ?>" class="d-block m-auto mb-3" alt="Logo" width="150">
                <!-- <i class="fas fa-gift"></i> -->
                <?php
                echo $system['shop_name'] ?? "Souvenir Shop";
                ?>
            </h2>

            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <form method="POST" autocomplete="off">
                <div class="form-group">
                    <label for="username"><?= __("Username") ?></label>
                    <input type="text" class="form-control" id="username" autofocus name="username" required value="<?php if(isset($error) && isset($_POST['username'])) echo $_POST['username']; ?>"
                        placeholder="<?= __("Enter your username") ?>">
                </div>
                <div class="form-group">
                    <label for="password"><?= __("Password") ?></label>
                    <input type="password" class="form-control" id="password" name="password" required
                        placeholder="<?= __("Enter your password") ?>">
                </div>
                <button type="submit" class="btn btn-primary w-100 mt-2"><i class="fa fa-sign-in" aria-hidden="true"></i> <?= __("Login") ?></button>
            </form>
            <!-- <p class="fw-bold mt-3 mb-0">Demo accounts:</p>
            <ol class="list-group list-group-numbered">
                <li class="list-group-item">cashier1 / 123</li>
                <li class="list-group-item">stock / 123</li>
                <li class="list-group-item">owner / 123</li>

            </ol> -->
        </div>
    </div>
    

    <!-- Include PWA Install Script -->
    <script src="app.js" defer></script>
</body>

</html>