<?php
// session_start(); // Start session if not already started


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['resetPassword'])) {
     $operator_password = trim($_POST['your_password']);
     $user_id = (int)$_POST['user_id'];
     $default_password = '666666';

     // echo $user_id;
     // exit;

     // Check if operator is logged in
     if (!isset($_SESSION['user_id'])) {
          echo "<script>
            alert('Operator not logged in');
            window.history.back();
        </script>";
          exit;
     }

     $operator_id = $_SESSION['user_id'];

     try {

          // 1. Verify operator's password
          $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
          $stmt->execute([$operator_id]);
          $operator = $stmt->fetch(PDO::FETCH_ASSOC);

          if (!$operator) {
               echo "<script>
                alert('Operator not found');
                window.history.back();
            </script>";
               exit;
          }

          // Verify operator's password
          if (!password_verify($operator_password, $operator['password'])) {
               echo "<script>
                alert('Incorrect operator password');
                window.history.back();
            </script>";
               exit;
          }

          // 2. Reset user's password to default (666666)
          $hashed_default_password = password_hash($default_password, PASSWORD_DEFAULT);

          $update_stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
          $result = $update_stmt->execute([$hashed_default_password, $user_id]);

          if ($result) {
               echo "<script>
                    alert('Password reset successfully to default (666666). User must change on next login.');
                    window.history.back();
                </script>";
               exit;
          } else {
               echo "<script>
                alert('Database error');
                window.history.back();
            </script>";
               exit;
          }
     } catch (PDOException $e) {
          echo "<script>
               alert('Error: " . addslashes($e->getMessage()) . "');
               window.history.back();
          </script>";
          exit;
     }
}
?>
<div id="userManagement" class="tab-content <?php echo $current_tab === 'userManagement' ? 'active' : ''; ?>">
     <h3><?= __("User Management") ?></h3>
     <div class="my-3">
          <button class="btn btn-primary" onclick="showAddUserModal()">
               <i class="fas fa-user-plus"></i> <?= __("Add User") ?>
          </button>
     </div>

     <div class="user-management">
          <?php foreach ($users as $user):
               // If logged-in user is not admin, skip admin users
               if ($_SESSION['user_role'] !== 'admin' && $user['role'] === 'admin') {
                    continue; // Skip this admin user
               }
          ?>
               <div class="user-card">
                    <div>
                         <strong><?php echo htmlspecialchars($user['full_name'] ?: $user['username']); ?> <span class="text-primary fw-normal"><?= $_SESSION['user_id'] == $user['id'] ? "(" . __("You") . ")" : "" ?></span></strong>
                         <div><?= __("Username") ?>: <?php echo htmlspecialchars($user['username']); ?> | <?= __("Role") ?>: <?php echo ucfirst($user['role']); ?></div>
                         <div class="text-muted"><?= __("Last Login") ?>: <?php echo $user['last_login'] ?? __("Never"); ?></div>
                    </div>
                    <div class="user-actions">
                         <button class="btn btn-success btn-sm" title="Edit" onclick="editUser(<?php echo $user['id']; ?>)"><i class="fa fa-edit" aria-hidden="true"></i></button>

                         <?php if ($_SESSION['user_id'] != $user['id']): ?>

                              <button class="btn btn-secondary btn-sm" title="Reset password" onclick="resetPassUser(<?= $user['id']; ?>, '<?= htmlspecialchars($user['full_name'], ENT_QUOTES) ?>')">
                                   <i class="fa fa-unlock-alt" aria-hidden="true"></i>
                              </button> <button class="btn btn-danger btn-sm" title="Delete" onclick="deleteUser(<?php echo $user['id']; ?>)"><i class="fa fa-trash" aria-hidden="true"></i></button>
                         <?php endif; ?>
                    </div>
               </div>
          <?php endforeach; ?>
     </div>
</div>

<!-- Add User Modal -->
<div id="addUserModal" class="modal">
     <div class="modal-content">
          <span class="close">&times;</span>
          <h2><?= __("Add New User") ?></h2>
          <form method="POST">
               <input type="hidden" name="add_user" value="1">
               <div class="form-group">
                    <label><?= __("Full Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="<?= __("Full Name") ?>" name="full_name" required>
               </div>
               <div class="form-group">
                    <label><?= __("Username") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="<?= __("Username") ?>" name="username" required>
               </div>
               <div class="form-group">
                    <label><?= __("Password") ?> <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" placeholder="<?= __("Password") ?>" name="password" required>
               </div>
               <div class="form-group">
                    <label><?= __("Role") ?> <span class="text-danger">*</span></label>
                    <select name="role" required class="form-select">
                         <option disabled selected><?= __("Select Role") ?></option>
                         <option value="cashier"><?= __("Cashier") ?></option>
                         <option value="stock"><?= __("Stock Control") ?></option>
                         <option value="owner"><?= __("Owner") ?></option>
                         <?php
                         if ($_SESSION['user_role'] === 'admin') {
                         ?>
                              <option value="admin"><?= __("Administrator") ?></option>
                         <?php
                         }
                         ?>
                    </select>
               </div>
               <button type="submit" class="btn btn-success"><?= __("Add User") ?></button>
          </form>
     </div>
</div>

<!-- Edit User Modal -->
<div id="editUserModal" class="modal">
     <div class="modal-content">
          <span class="close">&times;</span>
          <h2><?= __("Edit User") ?></h2>
          <form method="POST" id="editUserForm">
               <input type="hidden" name="update_user" value="1">
               <input type="hidden" name="user_id" id="edit_user_id">
               <div class="form-group">
                    <label><?= __("Full Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" name="full_name" placeholder="<?= __("Full Name") ?>" class="form-control" id="edit_full_name" required>
               </div>
               <div class="form-group">
                    <label><?= __("Username") ?> <span class="text-danger">*</span></label>
                    <input type="text" name="username" placeholder="<?= __("Username") ?>" class="form-control" id="edit_username" required>
               </div>
               <div class="form-group">
                    <label><?= __("Role") ?> <span class="text-danger">*</span></label>
                    <select name="role" id="edit_role" class="form-select" required>
                         <option value="cashier"><?= __("Cashier") ?></option>
                         <option value="stock"><?= __("Stock Control") ?></option>
                         <option value="owner"><?= __("Owner") ?></option>
                         <?php
                         if ($_SESSION['user_role'] === 'admin') {
                         ?>
                              <option value="admin"><?= __("Administrator") ?></option>
                         <?php
                         }
                         ?>
                    </select>
               </div>
               <button type="submit" class="btn btn-success"><?= __("Update User") ?></button>
          </form>
     </div>
</div>

<!-- Edit User Modal -->
<div id="resetPasswrodModal" class="modal">
     <div class="modal-dialog-centered">
          <div class="modal-content">
               <span class="close">&times;</span>
               <h4><?= __("Reset password for") ?> <span id="usernameValue" class="fw-bold text-primary"></span> </h4>
               <form method="POST" autocomplete="off" id="formReset">
                    <div class="form-group">
                         <label for="your_password"><?= __("Your Password") ?></label>
                         <input type="hidden" name="user_id" id="user_id">
                         <input type="password" name="your_password" placeholder="<?= __("Your Password") ?>" class="form-control" id="your_pass" required autofocuss>
                         <div class="alert alert-info mt-3" role="alert">
                              <h4 class="alert-heading"><?= __("Reset Password") ?>!</h4>
                              <p>
                                   <?= __("To reset passwrod, Please enter your password to reset password for other users.") ?> <br>
                                   <?= __("Password reset will be") ?> <span class="fw-bold">"666666".</span>
                              </p>
                              <!-- <hr> -->
                              <!-- <p class="mb-0">Whenever you need to, be sure to use margin utilities to keep things nice and tidy.</p> -->
                         </div>
                    </div>
                    <button type="submit" name="resetPassword" class="btn btn-secondary"><?= __("Reset Password") ?></button>
               </form>
          </div>
     </div>
</div>

<script>
     function resetPassUser(id, fullname) {
          document.getElementById("formReset").reset();
          // Show the modal
          document.getElementById("resetPasswrodModal").style.display = "block";

          // Set the username value (fixed the innerHTML assignment)
          document.getElementById("usernameValue").innerHTML = fullname;

          // Store the user ID in a hidden field or data attribute for form submission
          document.getElementById("user_id").value = id;

     }
</script>