<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     if (isset($_POST['update_shop_info_bill'])) {
          // ដំបូងយើងទាញយកព័ត៌មានចាស់ពី Database
          $old_data_stmt = $pdo->prepare("SELECT logo, qrcode FROM shop_info WHERE id = 1");
          $old_data_stmt->execute();
          $old_data = $old_data_stmt->fetch(PDO::FETCH_ASSOC);

          $old_logo = $old_data['logo'] ?? null;
          $new_logo_name = $old_logo; // ដំបូងសន្មត់ថាប្រើរូបភាពចាស់

          $old_qrcode = $old_data['qrcode'] ?? null;
          $new_qrcode_name = $old_qrcode;

          // ពិនិត្យមើលថាតើមានឯកសាររូបភាពថ្មីត្រូវបានផ្ទុកឡើងដែរឬទេ
          $logo_updated = false;
          $qrcode_updated = false;

          // Process logo upload if provided
          if (isset($_FILES['logo']) && $_FILES['logo']['error'] == 0 && $_FILES['logo']['size'] > 0) {
               $logo = $_FILES['logo'];
               $target_dir = "assets/images/";

               // បង្កើតថតប្រសិនបើវាមិនមាន
               if (!file_exists($target_dir)) {
                    mkdir($target_dir, 0777, true);
               }

               // ទទួលយកឈ្មោះឯកសារដើម
               $original_filename = basename($logo["name"]);
               $imageFileType = strtolower(pathinfo($original_filename, PATHINFO_EXTENSION));

               // បង្កើតឈ្មោះឯកសារថ្មីដោយប្រើ timestamp ដើម្បីចៀសវាងការប្រើឈ្មោះដូចគ្នា
               $new_logo_name = 'logo_' . time() . '_' . rand(100, 999) . '.' . $imageFileType;
               $target_file = $target_dir . $new_logo_name;

               // ពិនិត្យថាតើឯកសារគឺជារូបភាពពិតប្រាកដ
               $check = getimagesize($logo["tmp_name"]);
               if ($check !== false) {
                    // ពិនិត្យទំហំឯកសារ (មិនលើសពី 2MB)
                    if ($logo["size"] <= 2000000) {
                         // អនុញ្ញាតតែទម្រង់ឯកសាររូបភាពជាក់លាក់
                         $allowed_types = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                         if (in_array($imageFileType, $allowed_types)) {
                              // ផ្ទុកឯកសារឡើង
                              if (move_uploaded_file($logo["tmp_name"], $target_file)) {
                                   // ប្រសិនបើរូបភាពចាស់មាន និងមិនមែនជារូបភាពលំនាំដើម
                                   if ($old_logo && $old_logo != 'default_logo.png' && file_exists($target_dir . $old_logo)) {
                                        // លុបរូបភាពចាស់ចេញ
                                        unlink($target_dir . $old_logo);
                                   }
                                   $logo_updated = true;
                              } else {
                                   // ប្រសិនបើមានបញ្ហាក្នុងការផ្ទុកឯកសារ
                                   $new_logo_name = $old_logo;
                                   echo "<script>alert('មានបញ្ហាក្នុងការផ្ទុកឯកសាររូបភាព (Logo)'); window.history.back();</script>";
                                   exit;
                              }
                         } else {
                              $new_logo_name = $old_logo;
                              echo "<script>alert('ទម្រង់ឯកសារមិនត្រូវបានគាំទ្រទេ។ សូមប្រើ JPG, JPEG, PNG, GIF ឬ WebP'); window.history.back();</script>";
                              exit;
                         }
                    } else {
                         $new_logo_name = $old_logo;
                         echo "<script>alert('ឯកសារមានទំហំធំពេក។ ទំហំអតិបរមា៖ 2MB'); window.history.back();</script>";
                         exit;
                    }
               } else {
                    $new_logo_name = $old_logo;
                    echo "<script>alert('ឯកសារនេះមិនមែនជារូបភាពទេ។'); window.history.back();</script>";
                    exit;
               }
          }

          // Process QR code upload if provided
          if (isset($_FILES['qrcode']) && $_FILES['qrcode']['error'] == 0 && $_FILES['qrcode']['size'] > 0) {
               $qrcode = $_FILES['qrcode'];
               $target_dir = "assets/images/";

               // បង្កើតថតប្រសិនបើវាមិនមាន
               if (!file_exists($target_dir)) {
                    mkdir($target_dir, 0777, true);
               }

               // ទទួលយកឈ្មោះឯកសារដើម
               $original_filename_qrcode = basename($qrcode["name"]);
               $imageFileType_qrcode = strtolower(pathinfo($original_filename_qrcode, PATHINFO_EXTENSION));

               // បង្កើតឈ្មោះឯកសារថ្មីដោយប្រើ timestamp ដើម្បីចៀសវាងការប្រើឈ្មោះដូចគ្នា
               $new_qrcode_name = 'qrcode_' . time() . '_' . rand(100, 999) . '.' . $imageFileType_qrcode;
               $target_file_qrcode = $target_dir . $new_qrcode_name;

               // ពិនិត្យថាតើឯកសារគឺជារូបភាពពិតប្រាកដ
               $check_qrcode = getimagesize($qrcode["tmp_name"]);
               if ($check_qrcode !== false) {
                    // ពិនិត្យទំហំឯកសារ (មិនលើសពី 2MB)
                    if ($qrcode["size"] <= 2000000) {
                         // អនុញ្ញាតតែទម្រង់ឯកសាររូបភាពជាក់លាក់
                         $allowed_types = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                         if (in_array($imageFileType_qrcode, $allowed_types)) {
                              // ផ្ទុកឯកសារឡើង
                              if (move_uploaded_file($qrcode["tmp_name"], $target_file_qrcode)) {
                                   // ប្រសិនបើរូបភាពចាស់មាន និងមិនមែនជារូបភាពលំនាំដើម
                                   if ($old_qrcode && $old_qrcode != 'qrcode.jpg' && file_exists($target_dir . $old_qrcode)) {
                                        unlink($target_dir . $old_qrcode);
                                   }
                                   $qrcode_updated = true;
                              } else {
                                   // ប្រសិនបើមានបញ្ហាក្នុងការផ្ទុកឯកសារ
                                   $new_qrcode_name = $old_qrcode;
                                   echo "<script>alert('មានបញ្ហាក្នុងការផ្ទុកឯកសាររូបភាព (QR Code)'); window.history.back();</script>";
                                   exit;
                              }
                         } else {
                              $new_qrcode_name = $old_qrcode;
                              echo "<script>alert('ទម្រង់ឯកសារ QR Code មិនត្រូវបានគាំទ្រទេ។ សូមប្រើ JPG, JPEG, PNG, GIF ឬ WebP'); window.history.back();</script>";
                              exit;
                         }
                    } else {
                         $new_qrcode_name = $old_qrcode;
                         echo "<script>alert('ឯកសារ QR Code មានទំហំធំពេក។ ទំហំអតិបរមា៖ 2MB'); window.history.back();</script>";
                         exit;
                    }
               } else {
                    $new_qrcode_name = $old_qrcode;
                    echo "<script>alert('ឯកសារ QR Code នេះមិនមែនជារូបភាពទេ។'); window.history.back();</script>";
                    exit;
               }
          }

          // Get other form data
          $shop_name = $_POST['shop_name'];
          $address = $_POST['address'];
          $phone = $_POST['phone'];
          $tax_id = $_POST['tax_id'];
          $receipt_header = $_POST['receipt_header'];
          $print_logo = isset($_POST['print_logo']) ? 1 : 0;
          $print_tax_id = isset($_POST['print_tax_id']) ? 1 : 0;
          $print_qrcode = isset($_POST['print_qrcode']) ? 1 : 0;

          // Update database
          $stmt = $pdo->prepare("UPDATE shop_info SET logo = ?, shop_name = ?, address = ?, phone = ?, tax_rate = ?, receipt_header = ?, print_logo = ?, print_tax_id = ?, qrcode = ?, print_qrcode = ? WHERE id = 1");
          $stmt->execute([$new_logo_name, $shop_name, $address, $phone, $tax_id, $receipt_header, $print_logo, $print_tax_id, $new_qrcode_name, $print_qrcode]);

          echo "<script>
               alert('Shop info has updated successfully.');
               window.history.back();
               window.reload();
               </script>";
          exit;
     }
}
?>
<div class="dashboard-grid">
     <div class="dashboard-card">
          <h3><?= __("Shop Information for Bills") ?></h3>
          <form method="POST" enctype="multipart/form-data">
               <input type="hidden" name="update_shop_info_bill" value="1">
               <div class="row">
                    <div class="col-md-6">
                         <div class="form-group">
                              <label><?= __("Shop Logo") ?></label>
                              <input type="file" onchange="changeImage('logo_img')" class="form-control" name="logo" accept="image/*">
                              <img class="mt-3" id="logo_img" src="assets/images/<?= $shop_info['logo'] ?? 'logo.png' ?>" width="100" alt="Logo">
                         </div>
                    </div>
                    <div class="col-md-6">
                         <div class="form-group">
                              <label for="qrcode"><?= __("QR Code Image") ?></label>
                              <input type="file" onchange="changeImage('qrcode_img')" class="form-control" id="qrcode" name="qrcode" accept="image/*">
                              <img class="mt-3" id="qrcode_img" src="assets/images/<?= $shop_info['qrcode'] ?? 'qrcode.jpg' ?>" width="100" alt="QRCode">
                         </div>
                    </div>

               </div>

               <div class="form-group">
                    <label><?= __("Shop Name") ?></label>
                    <input type="text" class="form-control" name="shop_name" value="<?php echo htmlspecialchars($shop_info['shop_name'] ?? 'Souvenir Shop'); ?>" required>
               </div>

               <div class="form-group">
                    <label><?= __("Phone Number") ?></label>
                    <input type="text" class="form-control" name="phone" value="<?php echo htmlspecialchars($shop_info['phone'] ?? '02-123-4567'); ?>" required>
               </div>
               <div class="form-group">
                    <label><?= __("Tax ID") ?></label>
                    <input type="text" class="form-control" name="tax_id" value="<?php echo htmlspecialchars($shop_info['tax_id'] ?? ''); ?>">
               </div>
               <div class="form-group">
                    <label><?= __("Shop Address") ?></label>
                    <textarea name="address" class="form-control" rows="3" required><?php echo htmlspecialchars($shop_info['address'] ?? 'Phnom Penh'); ?></textarea>
               </div>

               <!-- new add  -->
               <div class="form-group">
                    <label><?= __("Receipt Footer Message") ?></label>
                    <textarea name="receipt_header" class="form-control" rows="2"><?php echo htmlspecialchars($shop_info['receipt_header'] ?? 'Thank you for shopping with us!'); ?></textarea>
               </div>
               <!-- <div class="form-group">
                    <label>Receipt Footer Message</label>
                    <textarea name="receipt_footer" class="form-control" rows="2"><? #php echo htmlspecialchars($shop_info['receipt_footer'] ?? 'Please visit again!'); 
                                                                                     ?></textarea>
               </div> -->
               <div class="form-group">
                    <label>
                         <input type="checkbox" class="form-check-input" name="print_logo" <?php echo isset($shop_info['print_logo']) && $shop_info['print_logo'] ? 'checked' : ''; ?>>
                         <?= __("Print Company Logo on Bills") ?>
                    </label>
               </div>
               <div class="form-group">
                    <label>
                         <input type="checkbox" class="form-check-input" name="print_qrcode" <?php echo isset($shop_info['print_qrcode']) && $shop_info['print_qrcode'] ? 'checked' : ''; ?>>
                         <?= __("Print QR Code on Bills") ?>
                    </label>
               </div>
               <div class="form-group">
                    <label>
                         <input type="checkbox" class="form-check-input" name="print_tax_id" <?php echo isset($shop_info['print_tax_id']) && $shop_info['print_tax_id'] ? 'checked' : ''; ?>>
                         <?= __("Print Tax ID on Bills") ?>
                    </label>
               </div>
               <!-- new add  -->

               <button type="submit" class="btn btn-primary"><?= __("Save Shop Information") ?></button>
          </form>
     </div>

     <!-- <div class="dashboard-card">
                        <h3>Bill/Receipt Settings</h3>
                        <form method="POST">
                            <input type="hidden" name="update_receipt_settings" value="1">
                            <div class="form-group">
                                <label>Receipt Header Message</label>
                                <textarea name="receipt_header" rows="2"><? #php echo htmlspecialchars($shop_info['receipt_header'] ?? 'Thank you for shopping with us!'); 
                                                                           ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Receipt Footer Message</label>
                                <textarea name="receipt_footer" rows="2"><? #php echo htmlspecialchars($shop_info['receipt_footer'] ?? 'Please visit again!'); 
                                                                           ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="print_logo" <? #php echo isset($shop_info['print_logo']) && $shop_info['print_logo'] ? 'checked' : ''; 
                                                                                ?>>
                                    Print Company Logo on Bills
                                </label>
                            </div>
                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="print_tax_id" <? #php echo isset($shop_info['print_tax_id']) && $shop_info['print_tax_id'] ? 'checked' : ''; 
                                                                                ?>>
                                    Print Tax ID on Bills
                                </label>
                            </div>
                            <button type="submit" class="btn">Save Receipt Settings</button>
                        </form>
                    </div> -->

     <!-- <div class="dashboard-card" style="margin-top: 1.5rem;">
          <h3>Business Hours</h3>
          <form id="businessHoursForm">
               <label for="">Monday - Friday</label>
               <div class="row">
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="09:00">
                    </div>
                    <div class="col-md-2">
                         to
                    </div>
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="20:00">
                    </div>
               </div>
               <label for="">Saturday</label>
               <div class="row">
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="10:00">
                    </div>
                    <div class="col-md-2">
                         to
                    </div>
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="22:00">
                    </div>
               </div>

               <label for="">Sunday</label>
               <div class="row">
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="10:00">
                    </div>
                    <div class="col-md-2">
                         to
                    </div>
                    <div class="col-md-5">
                         <input type="time" class="form-control" value="18:00">
                    </div>
               </div>
               <button type="submit" class="btn btn-primary" style="margin-top: 1rem;">Save Business Hours</button>
          </form>
     </div> -->
</div>

<script>
     function changeImage(imgPreview) {
          // ការតភ្ជាប់ event listener ទៅ input file
          const file = event.target.files[0];
          const preview = document.getElementById(imgPreview);

          if (file) {
               // ពិនិត្យប្រភេទឯកសារ
               if (!file.type.startsWith('image/')) {
                    alert('សូមជ្រើសរើសឯកសាររូបភាព');
                    this.value = ''; // សម្អាត input
                    return;
               }
               // បង្ហាញរូបភាពជាមុន
               const reader = new FileReader();
               reader.onload = function(e) {
                    preview.src = e.target.result;
               };
               reader.readAsDataURL(file);
          } else {
               // ប្រសិនបើគ្មានឯកសារ ត្រឡប់ទៅរូបភាពលំនាំដើម
               preview.src = 'assets/images/default_profile.png';
          }
     };
</script>