<!-- <div id="reports" class="tab-content <? #php echo $current_tab === 'reports' ? 'active' : ''; 
                                             ?>"> -->
<div id="reports" class="tab-content">
     <h3><?= __("Reports & Analytics") ?></h3>

     <div class="filter-section">
          <form method="GET" id="reportForm" onsubmit="return setReportTab()">
               <input type="hidden" name="generate_report" value="1">
               <!-- Add hidden fields for user data -->
               <input type="hidden" id="currentUsername" value="<?php echo $_SESSION['username']; ?>">
               <input type="hidden" id="currentUserRole" value="<?php echo $_SESSION['user_role']; ?>">
               <div class="filter-row">
                    <div class="form-group">
                         <label><i class="fas fa-calendar-alt"></i> <?= __("From Date") ?></label>
                         <input type="text" id="report_start_date" placeholder="<?= __("DD MMM YYYY") ?>" name="from_date" class="form-control datepicker" value="<?php echo $_GET['from_date'] ?? date('01 M Y'); ?>" required>
                    </div>
                    <div class="form-group">
                         <label><i class="fas fa-calendar-check"></i> <?= __("To Date") ?></label>
                         <input type="text" id="report_end_date" placeholder="<?= __("DD MMM YYYY") ?>" name="to_date" class="form-control datepicker" value="<?php echo $_GET['to_date'] ?? date('d M Y'); ?>" required>
                    </div>

                    <div class="form-group">
                         <label><i class="fas fa-chart-bar"></i> <?= __("Report Type") ?></label>
                         <select name="report_type" id="reportTypeSelect" class="form-select">
                              <option value="sales" <?php echo ($_GET['report_type'] ?? 'sales') === 'sales' ? 'selected' : ''; ?>><?= __("Sales Report") ?></option>
                              <option value="stock" <?php echo ($_GET['report_type'] ?? 'sales') === 'stock' ? 'selected' : ''; ?>><?= __("Stock Report") ?></option>
                         </select>
                    </div>
               </div>
               <div class="button-group">
                    <button type="submit" class="btn btn-dark">
                         <i class="fa fa-search" aria-hidden="true"></i> <?= __("Generate Report") ?>
                    </button>
                    <?php if (isset($_GET['generate_report'])): ?>
                         <!-- <button type="button" class="btn btn-warning" onclick="printReport('<?php echo $_SESSION['username']; ?>', '<?php echo $_SESSION['user_role']; ?>')">
                              <i class="fas fa-print"></i> <?= __("Print Report") ?>
                         </button>
                         <button type="button" class="btn btn-success" onclick="exportReport()">
                              <i class="fas fa-file-csv"></i> <?= __("Export to CSV") ?>
                         </button> -->
                    <?php endif; ?>
               </div>
          </form>
     </div>

     <?php if (isset($_GET['generate_report'])): ?>
          <!-- Sales Report Tabs - Only one set of tabs -->
          <div class="tabs">
               <div class="tab active" onclick="openReportTab(event, 'salesByBill')">
                    <i class="fas fa-receipt"></i> <?= __("Sales by Bill") ?>
               </div>
               <div class="tab" onclick="openReportTab(event, 'salesByProduct')">
                    <i class="fas fa-cube"></i> <?= __("Sales by Product") ?>
               </div>
               <div class="tab" onclick="openReportTab(event, 'totalSales')">
                    <i class="fas fa-calendar"></i> <?= __("Total Sales Calendar View") ?>
               </div>
               <div class="tab" onclick="openReportTab(event, 'saleCompareStock')">
                    <i class="fas fa-balance-scale"></i> <?= __("Sale Compare Stock") ?>
               </div>
               <div class="tab" onclick="openReportTab(event, 'endDayStock')">
                    <i class="fa fa-stack-exchange" aria-hidden="true"></i></i> <?= __("End Day Stock") ?>
               </div>
          </div>

          <!-- Sales by Bill -->
          <div id="salesByBill" class="tab-content active">
               <h4><i class="fas fa-receipt"></i> <?= __("Sales by Bill") ?> (<?php echo date('d/M/Y', strtotime($_GET['from_date'])) . ' - ' . date('d/M/Y', strtotime($_GET['to_date'])); ?>)</h4>
               <?php if (!empty($report_data['sales_by_bill'])): ?>
                    <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" onclick="printTable('salebybill_table', 'Sales by Bill')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                         <button type="button" onclick="exportTableToCSV('salebybill_table', 'Sales by Bill')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                    </div>
                    <div class="respone-table">
                         <div class="bg-table p-3">
                              <table class="table table-striped table-hover" id="salebybill_table">
                                   <thead>
                                        <tr>
                                             <th><?= __("Bill Number") ?></th>
                                             <th><?= __("Customer") ?> / <?= __("Phone") ?></th>
                                             <th><?= __("Date") ?> / <?= __("Time") ?></th>
                                             <th><?= __("Item") ?></t>
                                             <th><?= __("Unit Price") ?></th>
                                             <th><?= __("Qty") ?></th>
                                             <th><?= __("Amount") ?></th>
                                        </tr>
                                   </thead>
                                   <tbody>
                                        <?php foreach ($report_data['sales_by_bill'] as $item): ?>
                                             <tr>
                                                  <td><?php echo htmlspecialchars($item['bill_number']); ?></td>
                                                  <td><?php echo htmlspecialchars($item['customer_name'] . " / " . $item['customer_phone']); ?></td>
                                                  <td><?php echo date('d M Y h:i A', strtotime($item['created_at'])); ?></td>
                                                  <td><?php echo htmlspecialchars($item['name']); ?></td>
                                                  <td>$<?php echo number_format($item['unit_price'], 2); ?></td>
                                                  <td><?php echo $item['quantity']; ?></td>
                                                  <td>$<?php echo number_format($item['total_price'], 2); ?></td>
                                             </tr>
                                        <?php endforeach; ?>
                                   </tbody>
                              </table>
                         </div>
                    </div>
               <?php else: ?>
                    <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                         <i class="fas fa-receipt fa-4x"></i>
                         <h4><?= __("No Sales Data Found") ?></h4>
                         <p><?= __("No sales data available for the selected period.") ?></p>
                    </div>
               <?php endif; ?>
          </div>

          <!-- Sales by Product -->
          <div id="salesByProduct" class="tab-content">
               <h4><i class="fas fa-cube"></i> <?= __("Sales by Product") ?> (<?php echo date('d/M/Y', strtotime($_GET['from_date'])) . ' - ' . date('d/M/Y', strtotime($_GET['to_date'])); ?>)</h4>
               <?php if (!empty($report_data['sales_by_product'])): ?>
                    <div class="btn-group btn-rounded-0 mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" onclick="printTable('salebyproduct', 'Sales by Product')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                         <button type="button" onclick="exportTableToCSV('salebyproduct', 'Sales by Product')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                    </div>
                    <div class="respone-table">
                         <div class="bg-table p-3">
                              <table class="table table-striped table-hover" id="salebyproduct">
                                   <thead>
                                        <tr>
                                             <th><?= __("Product") ?></th>
                                             <th><?= __("Total Qty") ?></th>
                                             <th><?= __("Total Sales") ?></th>
                                             <th><?= __("Average Price") ?></th>
                                        </tr>
                                   </thead>
                                   <tbody>
                                        <?php foreach ($report_data['sales_by_product'] as $product): ?>
                                             <tr>
                                                  <td><?php echo htmlspecialchars($product['name']); ?></td>
                                                  <td><?php echo $product['total_qty']; ?></td>
                                                  <td>$<?php echo number_format($product['total_sales'], 2); ?></td>
                                                  <td>$<?php echo number_format($product['avg_price'], 2); ?></td>
                                             </tr>
                                        <?php endforeach; ?>
                                   </tbody>
                              </table>
                         </div>
                    </div>
               <?php else: ?>
                    <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                         <i class="fas fa-cube fa-4x"></i>
                         <h4><?= __("No Product Sales Data") ?></h4>
                         <p><?= __("No product sales data available for the selected period.") ?></p>
                    </div>
               <?php endif; ?>
          </div>

          <!-- Total Sales -->
          <div id="totalSales" class="tab-content">
               <h4><i class="fas fa-calendar"></i> <?= __("Total Sales Calendar View") ?> (<?php echo date('M Y', strtotime($_GET['from_date'])); ?>)</h4>

               <?php
               if (isset($report_data['calendar_sales'])) {
               ?>
                    <div class="btn-group mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" class="btn btn-warning" onclick="printReport('<?php echo $_SESSION['username']; ?>', '<?php echo $_SESSION['user_role']; ?>')">
                              <i class="fas fa-print"></i> <?= __("Print") ?>
                         </button>
                         <button type="button" class="btn btn-success" onclick="exportReport()">
                              <i class="fas fa-file-csv"></i> <?= __("Export to CSV") ?>
                         </button>
                    </div>
                    <div class="respone-table">
                         <div class="calendar-view" id="calendarView">
                              <?php
                              // Generate calendar days
                              $start_date = new DateTime($_GET['from_date']);
                              $end_date = new DateTime($_GET['to_date']);
                              $interval = new DateInterval('P1D');
                              $end_date->modify('+1 day');
                              $period = new DatePeriod($start_date, $interval, $end_date);
                              // Create a map of sales by date

                              $sales_by_date = [];
                              foreach ($report_data['calendar_sales'] as $sale) {
                                   $sales_by_date[$sale['sale_date']] = $sale['daily_total'];
                              }

                              foreach ($period as $date) {
                                   $date_str = $date->format('Y-m-d');
                                   $has_sales = isset($sales_by_date[$date_str]);
                                   $sales_amount = $has_sales ? $sales_by_date[$date_str] : 0;
                              ?>
                                   <div class="calendar-day <?php echo $has_sales ? 'has-sales' : ''; ?>">
                                        <?php echo $date->format('d'); ?>
                                        <?php if ($has_sales): ?>
                                             <div class="sales-amount">$<?php echo number_format($sales_amount, 0); ?></div>
                                        <?php endif; ?>
                                   </div>
                              <?php
                              }
                              ?>
                         </div>
                    </div>

               <?php
               } else {
               ?>
                    <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                         <i class="fa fa-calendar fa-4x" aria-hidden="true"></i>
                         <h4><?= __("Total Sales Calendar View") ?></h4>
                         <p><?= __("No total sale calendar view data available for the selected period.") ?></p>
                    </div>
               <?php
               }
               ?>
          </div>

          <!-- Sale Compare Stock -->
          <div id="saleCompareStock" class="tab-content">
               <h4><i class="fas fa-balance-scale"></i> <?= __("Sale Compare Stock") ?> (<?php echo date('d/M/Y', strtotime($_GET['from_date'])) . ' - ' . date('d/M/Y', strtotime($_GET['to_date'])); ?>)</h4>
               <?php if (!empty($report_data['sale_compare_stock'])): ?>
                    <div class="btn-group btn-rounded-0 mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" onclick="printTable('salecomparestock_table', 'Sale Compare Stock')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                         <button type="button" onclick="exportTableToCSV('salecomparestock_table', 'Sale Compare Stock')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                    </div>

                    <div class="respone-table">
                         <div class="bg-table p-3">
                              <table class="table table-striped table-hover" id="salecomparestock_table">
                                   <thead>
                                        <tr>
                                             <th><?= __("Product") ?></th>
                                             <th><?= __("Beginning Stock") ?></th>
                                             <th><?= __("Qty Sold") ?></th>
                                             <th><?= __("Ending Stock") ?></th>
                                             <th><?= __("Stock Variance") ?></th>
                                        </tr>
                                   </thead>
                                   <tbody>
                                        <?php foreach ($report_data['sale_compare_stock'] as $item): ?>
                                             <tr>
                                                  <td><?php echo htmlspecialchars($item['name']); ?></td>
                                                  <td><?php echo $item['beginning_stock']; ?></td>
                                                  <td><?php echo $item['qty_sold']; ?></td>
                                                  <td><?php echo $item['ending_stock']; ?></td>
                                                  <td style="color: <?php echo $item['variance'] == 0 ? 'green' : 'red'; ?>; font-weight: bold;">
                                                       <?php echo $item['variance']; ?>
                                                  </td>
                                             </tr>
                                        <?php endforeach; ?>
                                   </tbody>
                              </table>
                         </div>
                    </div>
               <?php else: ?>
                    <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                         <i class="fas fa-balance-scale fa-4x"></i>
                         <h4><?= __("No Stock Comparison Data") ?></h4>
                         <p><?= __("No stock comparison data available for the selected period.") ?></p>
                    </div>
               <?php endif; ?>
          </div>

          <!-- End Day Stock Count -->
          <?php
          // Fetch all products for end day stock report
          // $end_day_stock_stmt = $pdo->prepare("SELECT e.*, p.p_code, p.name, p.category, p.image FROM end_day_stock e JOIN products p ON e.product_id = p.id WHERE e.last_count = 1 AND e.created_at = ? ORDER BY p.p_code ASC");
          // $end_day_stock_stmt = $pdo->prepare("SELECT e.*, p.p_code, p.name, p.category, p.image, p.stock FROM end_day_stock as e JOIN products as p ON e.product_id = p.id ORDER BY e.id ASC");

          $end_day_stock_stmt = $pdo->prepare("
               SELECT e.*, p.p_code, p.name, p.category, p.image 
               FROM end_day_stock e
               JOIN products p ON e.product_id = p.id
               WHERE DATE(e.created_at) = ?
               AND last_count = 1
               ORDER BY p.p_code ASC
          ");

          $end_day_stock_stmt->execute([$to_date]);
          $end_day_stocks = $end_day_stock_stmt->fetchAll();
          // Calculate sales for today (this is simplified)

          // $sales_stmt->execute([$product['id']]);
          // $sales_today = $sales_stmt->fetchColumn() ?: 0;

          // $beginning_stock = $product['stock'] + $sales_today; // Simplified calculation
          // $expected_stock = $beginning_stock - $sales_today;
          ?>
          <div id="endDayStock" class="tab-content active">
               <h4><i class="fa fa-stack-exchange" aria-hidden="true"></i> <?= __("End Day Stock") ?></h4>
               <?php if (!empty($end_day_stocks)): ?>
                    <div class="btn-group btn-rounded-0 mb-3 mt-2" role="group" aria-label="Basic example">
                         <button type="button" onclick="printTable('enddaystock_table', 'End Day Stock')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                         <button type="button" onclick="exportTableToCSV('enddaystock_table', 'End Day Stock')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                    </div>
                    <div class="respone-table">
                         <div class="bg-table p-3">
                              <table class="table table-bordered table-striped table-hover" id="enddaystock_table">
                                   <thead>
                                        <tr>
                                             <th><?= __('IMG') ?></th>
                                             <th><?= __("Code") ?></th>
                                             <th><?= __("Product") ?></th>
                                             <th><?= __("Category") ?></th>
                                             <th><?= __("Beginning Stock") ?></th>
                                             <th><?= __("Sales Today") ?></th>
                                             <th><?= __("Expected Stock") ?></th>
                                             <th><?= __("Actual Count") ?></th>
                                             <th><?= __("Difference") ?></th>
                                        </tr>
                                   </thead>
                                   <tbody>

                                        <?php foreach ($end_day_stocks as $end_day_stock): ?>
                                             <?php
                                             $sales_stmt = $pdo->prepare("
                                                  SELECT SUM(si.quantity) as total_sold 
                                                  FROM sale_items si 
                                                  JOIN sales s ON si.sale_id = s.id 
                                                  WHERE si.product_id = ? AND DATE(s.created_at) = CURDATE()
                                             ");
                                             $sales_stmt->execute([$end_day_stock['product_id']]);
                                             $sales_today = $sales_stmt->fetchColumn() ?: 0;

                                             // $beginning_stock = $end_day_stock['stock'] + $sales_today; // Simplified calculation
                                             // $expected_stock = $beginning_stock - $sales_today;

                                             // select difference calculation
                                             // $difference = $pdo->prepare("SELECT difference FROM end_day_stock WHERE product_id = ?");
                                             // $difference->execute([$end_day_stock['product_id']]);
                                             // $end_day_stock['difference'] = $difference->fetchColumn();


                                             ?>
                                             <tr>
                                                  <td>
                                                       <img src="assets/images/<?= $end_day_stock['image'] ?>" alt="Product" width="40">
                                                  </td>
                                                  <td><?php echo $end_day_stock['p_code'] ?? 'N/A'; ?></td>
                                                  <td><?php echo htmlspecialchars($end_day_stock['name']); ?></td>
                                                  <td><?php echo htmlspecialchars($end_day_stock['category']); ?></td>
                                                  <td class="text-muted fw-bold text-center"><?php echo $end_day_stock['beginning_stock']; ?><small class="text-muted ps-2 text-center fw-normal d-block"><?= __("Before end stock") ?></small></td>
                                                  <td class="fw-bold text-center"><?php echo $sales_today; ?><small class="text-muted ps-2 text-center fw-normal d-block"><?= __("Current saling") ?></small></td>
                                                  <td class="text-center"><?php echo $end_day_stock['expected_stock']; ?><small class="text-muted ps-2 text-center fw-normal d-block"><?= __("Minus stock for sale") ?></small></td>
                                                  <td class="text-primary fw-bold text-center"><?php echo $end_day_stock['actual_count']; ?><small class="text-muted ps-2 text-center fw-normal d-block"><?= __("After end stock") ?></small></td>
                                                  <!-- <td> 
                                                       <input type="hidden" class="d-none" name="product_id[]" value="<? #php echo $product['id']; 
                                                                                                                        ?>">
                                                       <input type="number" name="actual_count[]" oninput="calculateDifference(this)" value="<? #php echo $expected_stock; 
                                                                                                                                                 ?>" class="form-control stock-input" min="0">
                                                  </td> -->
                                                  <td class="<?php if ($end_day_stock['difference'] > 0) echo 'text-warning';
                                                                 elseif ($end_day_stock['difference'] < 0) echo 'text-danger';  ?>"><?php echo $end_day_stock['difference'] ?? 0 ?></td>
                                             </tr>
                                        <?php endforeach; ?>
                                   </tbody>
                              </table>
                         </div>
                    </div>
               <?php else: ?>
                    <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                         <i class="fa fa-stack-exchange fa-4x"></i>
                         <h4><?= __("No End Day Stock Data Found") ?></h4>
                         <p><?= __("No end day data available for the selected period.") ?></p>
                    </div>
               <?php endif; ?>
          </div>
     <?php else: ?>
          <div style="text-align: center; padding: 4rem; color: #7f8c8d; background: #f8f9fa; border-radius: 15px;">
               <i class="fas fa-chart-bar fa-4x" style="margin-bottom: 1rem;"></i>
               <h4><?= __("No Report Generated") ?></h4>
               <p><?= __('Select date range and report type, then click "Generate Report" to view analytics.') ?></p>
          </div>
     <?php endif; ?>
</div>