<div id="posMonitoring" class="tab-content <?php echo $current_tab === 'posMonitoring' ? 'active' : ''; ?>">
     <div class="section-header d-flex justify-content-between">
          <h3><?= __("Active POS Sessions") ?></h3>
          <button class="refresh btn btn-primary" onclick="refreshPOSData()">
               <i class="fas fa-sync-alt"></i> <?= __("Refresh") ?>
          </button>
     </div>
     <div class="active-cashiers" id="activeCashiersSection">
          <?php if (count($active_shifts) > 0): ?>
               <?php foreach ($active_shifts as $shift): ?>
                    <div class="cashier-card">
                         <div class="cashier-info">
                              <div>
                                   <strong><?php echo htmlspecialchars($shift['full_name']); ?></strong>
                                   <div><?= __("Logged in") ?>: <?php echo date('h:i A', strtotime($shift['start_time'])); ?></div>
                              </div>
                              <div class="status active"><?= __("Active") ?></div>
                         </div>
                         <div class="cashier-stats">
                              <div class="stat-item">
                                   <div><?= __("Total Sales") ?></div>
                                   <strong>$<?php echo number_format($shift['total_sales'], 2); ?></strong>
                              </div>
                              <div class="stat-item">
                                   <div><?= __("Items Sold") ?></div>
                                   <strong><?php echo $shift['total_items']; ?></strong>
                              </div>
                              <div class="stat-item">
                                   <div><?= __("Shift Duration") ?></div>
                                   <strong>
                                        <?php
                                        // Calculate elapsed time since shift started
                                        $duration = strtotime('now') - strtotime($shift['start_time']);

                                        // Convert seconds into hours and minutes
                                        $hours = floor($duration / 3600);
                                        $minutes = floor(($duration % 3600) / 60);

                                        echo $hours . 'h ' . $minutes . 'm';
                                        ?>
                                   </strong>
                              </div>
                         </div>
                         <?php if (!empty($shift['top_items'])): ?>
                              <div class="top-items">
                                   <strong><?= __("Top Items") ?>:</strong>
                                   <?php foreach ($shift['top_items'] as $item): ?>
                                        <span><?php echo htmlspecialchars($item['name']); ?> (<?php echo $item['qty_sold']; ?>)</span>
                                   <?php endforeach; ?>
                              </div>
                         <?php endif; ?>
                    </div>
               <?php endforeach; ?>
          <?php else: ?>
               <p><?= __("No active cashier sessions.") ?></p>
          <?php endif; ?>
     </div>

     <h4 style="margin-top: 2rem;"><?= __("Recent Sales") ?></h4>

     <div class="btn-group btn-rounded-0 mb-3" role="group" aria-label="Basic example">
          <button type="button" onclick="printTable('recent_sale_table', 'Recent Sales')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
          <button type="button" onclick="exportTableToCSV('recent_sale_table', 'Recent Sales')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
     </div>

     <div class="respone-table">
          <div class="bg-table p-3">
               <table class="table table-bordered table-striped table-hover" id="recent_sale_table">
                    <thead>
                         <tr>
                              <th><?= __("Bill No") ?></th>
                              <th><?= __("Cashier") ?></th>
                              <th><?= __("Time") ?></th>
                              <th><?= __("Items") ?></th>
                              <th><?= __("Total") ?></th>
                              <!-- <th>Actions</th> -->
                         </tr>
                    </thead>
                    <tbody>
                         <?php foreach ($recent_sales as $sale): ?>
                              <tr>
                                   <td>
                                        <a type="button" onclick="modalDetailBill('<?= $sale['bill_number'] ?>')" class="link text-dark" data-id="<?= $sale['bill_number'] ?>" id="bill_number_code"><?php echo htmlspecialchars($sale['bill_number']); ?></a>
                                   </td>
                                   <td><?php echo htmlspecialchars($sale['username']); ?></td>
                                   <td><?php echo date('d M Y h:i A', strtotime($sale['created_at'])); ?></td>
                                   <td><?php echo $sale['item_count']; ?> items</td>
                                   <td>$<?php echo number_format($sale['total_amount'], 2); ?></td>
                                   <!-- <td>
                         <button class="btn" onclick="editBill(<? #php echo $sale['id']; 
                                                                 ?>)">Edit</button>
                         <button class="btn" onclick="viewBill(<? #php echo $sale['id']; 
                                                                 ?>)">View</button>
                    </td> -->
                              </tr>
                         <?php endforeach; ?>
                    </tbody>
               </table>
          </div>
     </div>


     <!-- MODAL DETAIL BILL  -->
     <div id="modalDetailBill" class="modal">
          <div class="modal-content">
               <span class="close" onclick="hideModal('modalDetailBill')">&times;</span>
               <h2><?= __("Bill detail") ?></h2>

               <div class="bill-info">
                    <p class="m-0 p-0"><strong><?= __("Bill No") ?>:</strong> <span id="billDetailNumber"></span></p>
                    <p class="m-0 p-0"><strong><?= __('Date') ?>:</strong> <span id="billDetailDate"></span></p>
                    <p class="m-0 p-0"><strong><?= __("Cashier") ?>:</strong> <span id="billDetailCashier"></span></p>
                    <!-- <p class="m-0 p-0"><strong>Shift:</strong> <span id="billDetailShift"></span></p> -->
                    <p class="m-0 p-0"><strong><?= __("Payment Method") ?>:</strong> <span id="billDetailPaymentMethod"></span></p>
                    <p class="m-0 p-0"><strong><?= __('Customer') ?>:</strong> <span id="billDetailCustomer"></span></p>
                    <p class="m-0 p-0"><strong><?= __("Tel") ?>:</strong> <span id="billDetailCustomerTel"></span></p>
                    <p class="m-0 p-0"><strong><?= __("Address") ?>:</strong> <span id="billDetailCustomerAddress"></span></p>
               </div>

               <div class="bill-items">
                    <table style="width: 100%; border-collapse: collapse;">
                         <thead>
                              <tr>
                                   <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;">#</th>
                                   <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Item") ?></th>
                                   <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Price") ?></th>
                                   <th style="text-align: center; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Qty") ?></th>
                                   <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Total") ?></th>
                              </tr>
                         </thead>
                         <tbody id="billItemsBody">
                              <!-- Items will be populated here -->
                         </tbody>
                    </table>
               </div>

               <div class="bill-summary">
                    <!-- <div style="display: flex; justify-content: space-between; margin-top: 10px;">
                         <span><? #= __("Subtotal") 
                                   ?>:</span>
                         <span id="billSubtotal">$0.00</span>
                    </div>
                    <div style="display: flex; justify-content: space-between;">
                         <span>Discount:</span>
                         <span id="billDiscount">$0.00</span>
                    </div> -->
                    <div style="display: flex; justify-content: space-between; font-size: 1.2rem; font-weight: bold; margin-top: 1rem; padding-top: 1rem; border-top: 2px solid #2c3e50;">
                         <span><?= __("Total") ?>:</span>
                         <span id="billTotal">$0.00</span>
                    </div>
               </div>

               <div class="modal-footer" style="margin-top: 20px; text-align: right;">
                    <button class="btn btn-secondary" onclick="hideModal('modalDetailBill')"><?= __("Close") ?></button>
                    <!-- <button class="btn btn-primary" onclick="printBill()">
                         <i class="fa fa-print"></i> Print
                    </button> -->
               </div>
          </div>
     </div>
</div>

<script>
     function modalDetailBill(billNumber) {
          // Show modal
          document.getElementById("modalDetailBill").style.display = "block";

          // Clear previous data
          document.getElementById("billItemsBody").innerHTML =
               '<tr><td colspan="4" style="text-align: center; padding: 20px;">Loading...</td></tr>';
          document.getElementById("billDetailNumber").textContent = "Loading...";
          document.getElementById("billDetailDate").textContent = "Loading...";
          document.getElementById("billDetailCashier").textContent = "Loading...";
          document.getElementById("billDetailPaymentMethod").textContent = "Loading...";
          document.getElementById("billDetailCustomer").textContent = "Loading...";
          document.getElementById("billDetailCustomerTel").textContent = "Loading...";
          document.getElementById("billDetailCustomerAddress").textContent = "Loading...";
          // document.getElementById("billSubtotal").textContent = "$0.00";
          // document.getElementById("billDiscount").textContent = "$0.00";
          document.getElementById("billTotal").textContent = "$0.00";
          document.getElementById("billTotal").textContent = "$0.00";

          // Make AJAX request
          $.ajax({
               type: "POST",
               url: "ajax.php",
               data: {
                    bill_number: billNumber,
               },
               dataType: "json",
               success: function(response) {
                    console.log("Response received:", response); // Debug log

                    if (response.success) {
                         // Populate bill header info
                         const bill = response.data;
                         console.log("Bill data:", bill); // Debug log

                         document.getElementById("billDetailNumber").textContent = bill.bill_number || billNumber;
                         document.getElementById("billDetailDate").textContent = bill.created_at;
                         document.getElementById("billDetailCashier").textContent = bill.cashier_name || bill.cashier_username || bill.cashier_id || "N/A";
                         document.getElementById("billDetailPaymentMethod").textContent = bill.payment_method || "N/A";
                         document.getElementById("billDetailCustomer").textContent = bill.customer_name || "N/A";
                         document.getElementById("billDetailCustomerTel").textContent = bill.customer_phone || "N/A";
                         document.getElementById("billDetailCustomerAddress").textContent = bill.customer_address || "N/A";

                         // Calculate subtotal (total_amount - discount)
                         const subtotal = parseFloat(bill.total_amount) || 0;
                         const discount = parseFloat(bill.discount) || 0;
                         const finalAmount = parseFloat(bill.final_amount) || subtotal;

                         // document.getElementById("billSubtotal").textContent = "$" + subtotal.toFixed(2);
                         // document.getElementById("billDiscount").textContent = discount > 0 ? "-$" + discount.toFixed(2) : "$0.00";
                         document.getElementById("billTotal").textContent = "$" + finalAmount.toFixed(2);

                         // Populate items
                         if (bill.items && bill.items.length > 0) {
                              let itemsHtml = "";
                              console.log("Items found:", bill.items); // Debug log
                              let itemCounter = 1;

                              bill.items.forEach(function(item) {
                                   itemsHtml += `
                                        <tr>
                                             <td style="padding: 8px; border-bottom: 1px solid #ddd;">${itemCounter}</td>
                                             <td style="padding: 8px; border-bottom: 1px solid #ddd;">${item.product_name || "Item"}</td>
                                             <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${(parseFloat(item.unit_price) || 0).toFixed(2)}</td>
                                             <td style="text-align: center; padding: 8px; border-bottom: 1px solid #ddd;">${item.quantity || 1}</td>
                                             <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${(parseFloat(item.total_price) || 0).toFixed(2)}</td>
                                        </tr>
                                   `;
                                   itemCounter++; // Increment counter
                              });

                              document.getElementById("billItemsBody").innerHTML = itemsHtml;
                         } else {
                              document.getElementById("billItemsBody").innerHTML =
                                   '<tr><td colspan="4" style="text-align: center; padding: 20px;"><?= __("No items found") ?></td></tr>';
                         }
                    } else {
                         alert("Error: " + response.message);
                         hideModal("modalDetailBill");
                    }
               },
               error: function(xhr, status, error) {
                    console.error("AJAX Error:", xhr.responseText);
                    alert("Failed to load bill details. Check console for details.");
                    hideModal("modalDetailBill");
               },
          });
     }
</script>