<?php
require_once 'config/database.php';

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

function loginUser($username, $password) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND status = 'active'");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['full_name'] = $user['full_name'];
        $_SESSION['profile_picture'] = $user['profile_picture'];
        return true;
    }
    
    return false;
}

function logoutUser() {
    session_destroy();
    header('Location: index.php');
    exit();
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check user role
function checkRole($allowedRoles) {
    if (!isLoggedIn() || !in_array($_SESSION['user_role'], $allowedRoles)) {
        header('Location: index.php');
        exit();
    }
}

// Get current user's role
function getCurrentUserRole() {
    return $_SESSION['user_role'] ?? null;
}

// Check if user has specific role
function hasRole($role) {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === $role;
}

// Redirect to appropriate page based on role
function redirectToRolePage() {
    if (!isset($_SESSION['user_role'])) {
        header('Location: index.php');
        exit();
    }
    
    switch ($_SESSION['user_role']) {
        case 'cashier':
            header('Location: pos.php');
            break;
        case 'stock':
            header('Location: stock.php');
            break;
        case 'owner':
            header('Location: owner.php?tab=businessOverview');
            break;
        case 'admin':
            header('Location: admin.php');
            break;
        default:
            header('Location: dashboard.php');
    }
    exit();
}