<?php
// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// If not logged in, redirect to login
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

// Redirect to role-specific page
require_once 'includes/auth.php';
redirectToRolePage();
?>

<!-- This page will redirect immediately, but keeping it as fallback -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redirecting - Souvenir Shop</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background: #f4f4f4;
        }
        .loading {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="loading">
        <h2>Welcome, <?php echo $_SESSION['username']; ?>!</h2>
        <p>Your role: <?php echo ucfirst($_SESSION['user_role']); ?></p>
        <p>Redirecting to your dashboard...</p>
    </div>
</body>
</html>