<?php
// cleanup_logs.php
require_once 'config/database.php';
require_once 'log_functions.php';

$logger = new SystemLogger($pdo);

// Clean logs older than 90 days
$deleted = $logger->cleanOldLogs(90);

// Log the cleanup
$logger->log('cleanup', 'system', "Cleaned old system logs", 'success', null, [
    'deleted_count' => $deleted,
    'days_retained' => 90
]);

echo "Log cleanup completed. Deleted: $deleted rows.\n";