<?php
// check_stock.php
require_once 'config/database.php'; // Adjust path based on your structure

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_ids'])) {
    $productIds = json_decode($_POST['product_ids'], true);
    
    header('Content-Type: application/json');
    
    if (!empty($productIds)) {
        // Convert array to comma-separated string for SQL (safe way)
        $placeholders = implode(',', array_fill(0, count($productIds), '?'));
        
        $query = "SELECT id, p_code, name, stock, min_stock FROM products WHERE id IN ($placeholders)";
        $stmt = mysqli_prepare($conn, $query);
        
        // Bind parameters
        $types = str_repeat('i', count($productIds));
        mysqli_stmt_bind_param($stmt, $types, ...$productIds);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        $products = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $products[] = $row;
        }
        
        echo json_encode($products);
    } else {
        echo json_encode([]);
    }
} else {
    echo json_encode([]);
}
?>