// Initialize deferredPrompt for use later to show browser install prompt.
let deferredPrompt;

// Select the install button (you need to add this button in your HTML)
const installButton = document.getElementById('installButton');

window.addEventListener('beforeinstallprompt', (e) => {
  // Prevent the mini-infobar from appearing on mobile
  e.preventDefault();
  // Stash the event so it can be triggered later.
  deferredPrompt = e;
  // Show your custom install button
  if (installButton) {
    installButton.style.display = 'block';
  }
});

// When the user clicks the install button
if (installButton) {
  installButton.addEventListener('click', (e) => {
    // Hide the install button
    installButton.style.display = 'none';
    // Show the install prompt
    deferredPrompt.prompt();
    // Wait for the user to respond to the prompt
    deferredPrompt.userChoice.then((choiceResult) => {
      if (choiceResult.outcome === 'accepted') {
        console.log('User accepted the install prompt');
      } else {
        console.log('User dismissed the install prompt');
      }
      deferredPrompt = null;
    });
  });
}

// Listen for app installation event
window.addEventListener('appinstalled', () => {
  console.log('PWA was installed');
  // Hide the install button if it's still visible
  if (installButton) {
    installButton.style.display = 'none';
  }
});

// Function to check if the app is running in standalone mode
function isRunningStandalone() {
  return window.matchMedia('(display-mode: standalone)').matches || 
         window.navigator.standalone === true;
}

// On page load, hide the install button if the app is already installed
if (isRunningStandalone() && installButton) {
  installButton.style.display = 'none';
}