<?php
// ajax/filter_products.php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    // Get POST data
    $category = $_POST['category'] ?? 'ទាំងអស់';
    $page = (int)($_POST['page'] ?? 1);
    $search = trim($_POST['search'] ?? '');
    $itemsPerPage = (int)($_POST['itemsPerPage'] ?? 8);
    $offset = ($page - 1) * $itemsPerPage;
    
    // Build SQL query
    $sql = "SELECT * FROM products WHERE is_active = 1";
    $countSql = "SELECT COUNT(*) as total FROM products WHERE is_active = 1";
    
    $params = [];
    $countParams = [];
    
    // Add category filter if not 'ទាំងអស់'
    if ($category !== 'ទាំងអស់') {
        $sql .= " AND category = :category";
        $countSql .= " AND category = :category";
        $params[':category'] = $category;
        $countParams[':category'] = $category;
    }
    
    // Add search filter if search term exists
    if (!empty($search)) {
        $sql .= " AND (name LIKE :search OR p_code LIKE :search)";
        $countSql .= " AND (name LIKE :search OR p_code LIKE :search)";
        $params[':search'] = "%$search%";
        $countParams[':search'] = "%$search%";
    }
    
    // Add ordering and pagination
    $sql .= " ORDER BY name LIMIT :limit OFFSET :offset";
    
    // Count total items
    $countStmt = $pdo->prepare($countSql);
    foreach ($countParams as $key => $value) {
        $countStmt->bindValue($key, $value);
    }
    $countStmt->execute();
    $total = $countStmt->fetch()['total'];
    $totalPages = ceil($total / $itemsPerPage);
    
    // Get products
    $stmt = $pdo->prepare($sql);
    
    // Bind parameters
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }
    
    // Bind pagination parameters
    $stmt->bindValue(':limit', $itemsPerPage, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return JSON response
    echo json_encode([
        'success' => true,
        'products' => $products,
        'totalPages' => $totalPages,
        'currentPage' => $page,
        'totalItems' => $total,
        'category' => $category,
        'search' => $search
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}