<?php
session_start();
require_once 'includes/price-functions.php';
require_once 'includes/auth.php';


// check login with session['user_id']
// if (!isLoggedIn()) {
//      header("Location: index.php");
//      exit();
// }

// header("Location: index.php");
// exit(0)


// Initialize variables
$current_category = isset($_GET['category']) ? $_GET['category'] : 'all';
$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : getFirstProductId($current_category, $pdo);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     if (isset($_POST['product_id']) && isset($_POST['price'])) {
          $product_id = intval($_POST['product_id']);
          $price = floatval($_POST['price']);
          $stock = intval($_POST['stock'] ?? 0);

          if (updateProductPrice($product_id, $price, $stock, $pdo)) {
               $success_message = "✅ តម្លៃត្រូវបានរក្សាទុកដោយជោគជ័យ!";

               // Auto navigate to next product
               $next_id = getNextProductId($product_id, $current_category, $pdo);
               if ($next_id) {
                    header("Location: update-price.php?product_id=" . $next_id . "&category=" . $current_category . "&success=1");
                    exit();
               }
          } else {
               $error_message = "❌ មានបញ្ហាក្នុងការរក្សាទុកតម្លៃ!";
          }
     }
}

// Handle navigation
if (isset($_GET['action'])) {
     if ($_GET['action'] === 'next') {
          $next_id = getNextProductId($product_id, $current_category, $pdo);
          if ($next_id) {
               header("Location: update-price.php?product_id=" . $next_id . "&category=" . $current_category);
               exit();
          }
     } elseif ($_GET['action'] === 'prev') {
          $prev_id = getPreviousProductId($product_id, $current_category, $pdo);
          if ($prev_id) {
               header("Location: update-price.php?product_id=" . $prev_id . "&category=" . $current_category);
               exit();
          }
     }
}

// Get current product
$product = getProductById($product_id, $pdo);

// Get progress stats
$stats = getProgressStats($current_category, $pdo);

// Check if product exists and needs price update
if (!$product || ($product['price'] > 0 && $product['is_update'] == 1)) {
     // Redirect to first product without price
     $first_id = getFirstProductId($current_category, $pdo);
     if ($first_id) {
          header("Location: update-price.php?product_id=" . $first_id . "&category=" . $current_category);
          exit();
     }
}

$system_stmt = $pdo->prepare("SELECT * FROM shop_info");
$system_stmt->execute();
$system = $system_stmt->fetch(PDO::FETCH_ASSOC); // Changed from fetchAll() to fetch()
?>
<!DOCTYPE html>
<html lang="km">

<head>
     <meta charset="UTF-8">
     <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <title>កំណត់តម្លៃផលិតផល - <?= $system['shop_name'] ?? 'Souvenir Shop' ?></title>

     <link rel="shortcut icon" href="assets/images/<?= $system['logo'] ?? 'logo.png' ?>" type="image/x-icon">

     <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@300;400;500;600;700&display=swap" rel="stylesheet">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
     <style>
          * {
               margin: 0;
               padding: 0;
               box-sizing: border-box;
          }

          body {
               font-family: 'Kantumruy Pro', sans-serif;
               background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
               min-height: 100vh;
               padding: 20px;
          }

          .container {
               max-width: 1200px;
               margin: 0 auto;
               background: white;
               border-radius: 20px;
               box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
               overflow: hidden;
          }

          .header {
               background: linear-gradient(to right, #4A00E0, #8E2DE2);
               color: white;
               padding: 30px;
               text-align: center;
          }

          .header h1 {
               font-size: 2.5rem;
               margin-bottom: 10px;
               font-weight: 700;
          }

          .header .subtitle {
               font-size: 1.2rem;
               opacity: 0.9;
          }

          .progress-section {
               padding: 20px;
               background: #f8f9fa;
               border-bottom: 1px solid #e9ecef;
          }

          .progress-container {
               background: white;
               border-radius: 10px;
               padding: 20px;
               box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
          }

          .progress-bar {
               height: 20px;
               background: #e9ecef;
               border-radius: 10px;
               overflow: hidden;
               margin: 15px 0;
          }

          .progress-fill {
               height: 100%;
               background: linear-gradient(to right, #00b09b, #96c93d);
               width: <?php echo $stats['percentage']; ?>%;
               transition: width 0.5s ease;
          }

          .stats {
               display: flex;
               justify-content: space-between;
               margin-top: 10px;
               font-weight: 500;
          }

          .category-filter {
               padding: 20px;
               text-align: center;
               background: white;
               border-bottom: 1px solid #e9ecef;
          }

          .category-buttons {
               display: flex;
               flex-wrap: wrap;
               gap: 10px;
               justify-content: center;
               margin-top: 15px;
          }

          .category-btn {
               padding: 10px 20px;
               border: 2px solid #8E2DE2;
               background: white;
               color: #8E2DE2;
               border-radius: 50px;
               font-weight: 600;
               cursor: pointer;
               transition: all 0.3s ease;
               font-family: 'Kantumruy Pro', sans-serif;
          }

          .category-btn:hover {
               background: #8E2DE2;
               color: white;
               transform: translateY(-2px);
          }

          .category-btn.active {
               background: #8E2DE2;
               color: white;
          }

          .product-container {
               display: flex;
               flex-wrap: wrap;
               padding: 40px;
               gap: 40px;
               min-height: 500px;
          }

          .product-image-section {
               flex: 1;
               min-width: 300px;
          }

          .product-image-container {
               width: 100%;
               height: 400px;
               border-radius: 15px;
               overflow: hidden;
               box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
               background: #f8f9fa;
               display: flex;
               align-items: center;
               justify-content: center;
          }

          .product-image {
               max-width: 100%;
               max-height: 100%;
               object-fit: contain;
          }

          .product-details-section {
               flex: 1;
               min-width: 300px;
          }

          .product-code {
               background: #8E2DE2;
               color: white;
               padding: 5px 15px;
               border-radius: 20px;
               display: inline-block;
               font-weight: 600;
               margin-bottom: 15px;
          }

          .product-name {
               font-size: 2rem;
               font-weight: 700;
               margin-bottom: 15px;
               color: #333;
          }

          .product-description {
               color: #666;
               line-height: 1.6;
               margin-bottom: 25px;
               padding: 15px;
               background: #f8f9fa;
               border-radius: 10px;
               border-left: 4px solid #8E2DE2;
          }

          .product-category {
               display: inline-block;
               background: #e9ecef;
               padding: 8px 16px;
               border-radius: 20px;
               font-weight: 600;
               color: #495057;
               margin-bottom: 25px;
          }

          .price-form {
               background: #f8f9fa;
               padding: 30px;
               border-radius: 15px;
               margin-top: 30px;
          }

          .form-group {
               margin-bottom: 25px;
          }

          .form-group label {
               display: block;
               margin-bottom: 10px;
               font-weight: 600;
               color: #495057;
               font-size: 1.1rem;
          }

          .price-input {
               width: 100%;
               padding: 15px;
               border: 2px solid #dee2e6;
               border-radius: 10px;
               font-size: 1.2rem;
               font-weight: 600;
               text-align: right;
               font-family: 'Kantumruy Pro', sans-serif;
          }

          .price-input:focus {
               outline: none;
               border-color: #8E2DE2;
               box-shadow: 0 0 0 3px rgba(142, 45, 226, 0.2);
          }

          .price-currency {
               position: absolute;
               right: 15px;
               top: 50%;
               transform: translateY(-50%);
               color: #666;
               font-weight: 600;
          }

          .input-wrapper {
               position: relative;
          }

          .navigation {
               display: flex;
               justify-content: space-between;
               margin-top: 30px;
          }

          .nav-btn {
               padding: 15px 30px;
               border: none;
               border-radius: 10px;
               font-weight: 600;
               font-size: 1rem;
               cursor: pointer;
               transition: all 0.3s ease;
               font-family: 'Kantumruy Pro', sans-serif;
               display: flex;
               align-items: center;
               gap: 10px;
          }

          .nav-btn.prev {
               background: #6c757d;
               color: white;
          }

          .nav-btn.next {
               background: #28a745;
               color: white;
          }

          .nav-btn:hover {
               transform: translateY(-2px);
               box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
          }

          .nav-btn.prev:hover {
               background: #5a6268;
          }

          .nav-btn.next:hover {
               background: #218838;
          }

          .submit-btn {
               background: #8E2DE2;
               color: white;
               padding: 15px 40px;
               border: none;
               border-radius: 10px;
               font-weight: 600;
               font-size: 1.1rem;
               cursor: pointer;
               transition: all 0.3s ease;
               font-family: 'Kantumruy Pro', sans-serif;
          }

          .submit-btn:hover {
               background: #7a1dd1;
               transform: translateY(-2px);
               box-shadow: 0 5px 15px rgba(142, 45, 226, 0.3);
          }

          .footer {
               text-align: center;
               padding: 20px;
               background: #f8f9fa;
               color: #666;
               border-top: 1px solid #e9ecef;
          }

          .message {
               padding: 15px;
               border-radius: 10px;
               margin: 15px 0;
               text-align: center;
               font-weight: 600;
          }

          .success {
               background: #d4edda;
               color: #155724;
               border: 1px solid #c3e6cb;
          }

          .error {
               background: #f8d7da;
               color: #721c24;
               border: 1px solid #f5c6cb;
          }

          .back-home {
               background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
               width: fit-content;
               color: white;
               display: block;
               margin: 30px auto;
               padding: 10px 25px;
               border-radius: 50px;
               text-decoration: none;
               font-weight: bold;
               font-size: 1rem;
               text-transform: uppercase;
               transition: all 0.2s ease;
          }
          .back-home:hover{
               /* hover background gradient  */
               background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
               box-shadow: 0px 0px 20px #764ba2;
               border: 1px solid white;
          }

          @media (max-width: 768px) {
               .product-container {
                    flex-direction: column;
                    padding: 20px;
               }

               .header h1 {
                    font-size: 2rem;
               }

               .product-image-container {
                    height: 300px;
               }

               .navigation {
                    flex-direction: column;
                    gap: 15px;
               }

               .nav-btn,
               .submit-btn {
                    width: 100%;
                    justify-content: center;
               }
          }
     </style>
</head>

<body>
     <div class="container">
          <div class="header">
               <h1>កំណត់តម្លៃផលិតផល</h1>
               <div class="subtitle">សូមកំណត់តម្លៃសម្រាប់ផលិតផលនីមួយៗ</div>
          </div>

          <div class="progress-section">
               <div class="progress-container">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                         <h3>ចំនួនភាគរយនៃការកំណត់តម្លៃ</h3>
                         <span style="font-weight: 700; color: #8E2DE2;"><?php echo $stats['percentage']; ?>%</span>
                    </div>
                    <div class="progress-bar">
                         <div class="progress-fill"></div>
                    </div>
                    <div class="stats">
                         <div>សរុប: <?php echo $stats['total']; ?> ផលិតផល</div>
                         <div>បានកំណត់: <?php echo $stats['done']; ?> ផលិតផល</div>
                         <div>នៅសល់: <?php echo $stats['pending']; ?> ផលិតផល</div>
                    </div>
               </div>
          </div>

          <div class="category-filter">
               <h3>ជ្រើសរើសប្រភេទផលិតផល:</h3>
               <div class="category-buttons">
                    <?php foreach ($categories as $key => $name): ?>
                         <button
                              class="category-btn <?php echo $current_category === $key ? 'active' : ''; ?>"
                              onclick="window.location.href='update-price.php?category=<?php echo $key; ?>'">
                              <?php echo $name; ?>
                         </button>
                    <?php endforeach; ?>
               </div>
          </div>

          <?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
               <div class="message success">
                    <i class="fas fa-check-circle"></i> តម្លៃត្រូវបានរក្សាទុកដោយជោគជ័យ!
               </div>
          <?php endif; ?>

          <?php if (isset($error_message)): ?>
               <div class="message error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $error_message; ?>
               </div>
          <?php endif; ?>

          <?php if ($product): ?>
               <div class="product-container">
                    <div class="product-image-section">
                         <div class="product-image-container">
                              <?php if (!empty($product['image'])): ?>
                                   <img src="assets/images/<?php echo htmlspecialchars($product['image']); ?>"
                                        alt="<?php echo htmlspecialchars($product['name']); ?>"
                                        class="product-image"
                                        onerror="this.src='https://via.placeholder.com/400x400/8E2DE2/FFFFFF?text=No+Image'">
                              <?php else: ?>
                                   <img src="https://via.placeholder.com/400x400/8E2DE2/FFFFFF?text=No+Image"
                                        alt="No Image"
                                        class="product-image">
                              <?php endif; ?>
                         </div>
                    </div>

                    <div class="product-details-section">
                         <div class="product-code">កូដ: <?php echo htmlspecialchars($product['p_code']); ?></div>
                         <h2 class="product-name"><?php echo htmlspecialchars($product['name']); ?></h2>

                         <?php if (!empty($product['description'])): ?>
                              <div class="product-description">
                                   <?php echo nl2br(htmlspecialchars($product['description'])); ?>
                              </div>
                         <?php endif; ?>

                         <div class="product-category">
                              <i class="fas fa-tag"></i> ប្រភេទ: <?php echo htmlspecialchars($product['category']); ?>
                         </div>

                         <div class="stock-info">
                              <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                                   <div style="background: #e3f2fd; padding: 10px 20px; border-radius: 10px;">
                                        <div style="font-size: 0.9rem; color: #666;">ស្តុក</div>
                                        <div style="font-size: 1.5rem; font-weight: 700; color: #1976d2;">
                                             <?php echo $product['stock'] ?? 0; ?>
                                        </div>
                                   </div>
                                   <div style="background: #fff3e0; padding: 10px 20px; border-radius: 10px;">
                                        <div style="font-size: 0.9rem; color: #666;">ស្តុកអប្បបរមា</div>
                                        <div style="font-size: 1.5rem; font-weight: 700; color: #f57c00;">
                                             <?php echo $product['min_stock'] ?? 0; ?>
                                        </div>
                                   </div>
                              </div>
                         </div>

                         <form method="POST" class="price-form">
                              <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">

                              <div class="form-group">
                                   <label for="price">
                                        <i class="fas fa-dollar-sign"></i> កំណត់តម្លៃ (ដុល្លារ):
                                   </label>
                                   <div class="input-wrapper">
                                        <input type="number"
                                             id="price"
                                             name="price"
                                             class="price-input"
                                             value="<?php echo $product['price'] > 0 ? $product['price'] : ''; ?>"
                                             step="0.01"
                                             min="0"
                                             required
                                             placeholder="បញ្ចូលតម្លៃ...">
                                        <!-- <span class="price-currency ">$</span> -->
                                   </div>

                                   <label for="price"​ style="margin-top: 15px; display: block;">
                                        ស្តុកបច្ចុប្បន្ន:
                                   </label>
                                   <div class="input-wrapper">
                                        <input type="number"
                                             id="stock"
                                             name="stock"
                                             class="price-input"
                                             value="<?php echo $product['stock'] > 0 ? $product['stock'] : ''; ?>"
                                             min="0"
                                             required
                                             placeholder="បញ្ចូលតម្លៃ...">
                                        <!-- <span class="price-currency ">$</span> -->
                                   </div>
                              </div>

                              <div class="navigation">
                                   <button type="button" class="nav-btn prev"
                                        onclick="window.location.href='update-price.php?action=prev&product_id=<?php echo $product['id']; ?>&category=<?php echo $current_category; ?>'">
                                        <i class="fas fa-arrow-left"></i> ថយក្រោយ
                                   </button>

                                   <button type="submit" class="submit-btn">
                                        <i class="fas fa-save"></i> រក្សាទុកតម្លៃ
                                   </button>

                                   <button type="button" class="nav-btn next"
                                        onclick="window.location.href='update-price.php?action=next&product_id=<?php echo $product['id']; ?>&category=<?php echo $current_category; ?>'">
                                        បន្ទាប់ <i class="fas fa-arrow-right"></i>
                                   </button>
                              </div>
                         </form>
                    </div>

               </div>
               <a type="button" onclick="window.location.href='index.php'" class="back-home"><i class="fa fa-home" aria-hidden="true"></i> Back home</a>

          <?php else: ?>
               <div style="padding: 100px 20px; text-align: center;">
                    <div style="font-size: 4rem; color: #8E2DE2; margin-bottom: 20px;">
                         <i class="fas fa-check-circle"></i>
                    </div>
                    <h2 style="color: #495057; margin-bottom: 15px;">រួចរាល់!</h2>
                    <p style="color: #666; font-size: 1.2rem; max-width: 600px; margin: 0 auto;">
                         ផលិតផលទាំងអស់ត្រូវបានកំណត់តម្លៃរួចរាល់។
                         អ្នកអាចជ្រើសរើសប្រភេទផ្សេងទៀត ឬត្រឡប់មកវិញពេលក្រោយ។
                    </p>
               </div>
          <?php endif; ?>

          <div class="footer">
               <p>&copy; <?php echo date('Y'); ?> | គ្រប់គ្រងតម្លៃផលិតផលសម្រាប់ហាង​​ <b> <?= $system['shop_name'] ?? 'Souvenir Shop' ?></b> </p>
          </div>
     </div>

     <script>
          // Auto focus on price input
          document.addEventListener('DOMContentLoaded', function() {
               const priceInput = document.getElementById('price');
               if (priceInput) {
                    priceInput.focus();
                    priceInput.select();
               }

               // Keyboard navigation
               document.addEventListener('keydown', function(e) {
                    if (e.key === 'ArrowLeft') {
                         // Navigate to previous product
                         window.location.href = 'update-price.php?action=prev&product_id=<?php echo $product['id']; ?>&category=<?php echo $current_category; ?>';
                    } else if (e.key === 'ArrowRight' && !e.ctrlKey) {
                         // Navigate to next product
                         window.location.href = 'update-price.php?action=next&product_id=<?php echo $product['id']; ?>&category=<?php echo $current_category; ?>';
                    } else if (e.key === 'Enter' && e.ctrlKey) {
                         // Ctrl+Enter to submit form
                         document.querySelector('form').submit();
                    }
               });

               // Format price input
               priceInput.addEventListener('input', function(e) {
                    let value = e.target.value.replace(/[^0-9.]/g, '');
                    e.target.value = value;
               });
          });
     </script>
</body>

</html>