<?php
// telegram/send_ajax.php
header('Content-Type: application/json');


// DB connection 
require_once '../config/database.php';
require_once 'telegram_config.php';

// low stock query 
$low_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock <= min_stock AND stock > 0 AND is_active = 1");
$low_stock_stmt->execute();
$low_stock_count = $low_stock_stmt->fetchColumn();

// outstock query 
$out_of_stock_stmt = $pdo->prepare("SELECT COUNT(*) as count FROM products WHERE stock = 0 AND is_active = 1");
$out_of_stock_stmt->execute();
$out_of_stock_count = $out_of_stock_stmt->fetchColumn();

// Check if stock-file.txt exists, create if not
if (!file_exists('stock-file.txt')) {
    file_put_contents('stock-file.txt', "0,0");
    $array = [0, 0];
} else {
    $content = file_get_contents('stock-file.txt');
    // stock-file.txt (0,0)
    $array = explode(',', $content);
}



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['message'])) {
        echo json_encode(['ok' => false, 'error' => 'Message is required']);
        exit;
    }

    $message = $_POST['message'];
    $parseMode = isset($_POST['parse_mode']) ? $_POST['parse_mode'] : 'HTML';
    $chatId = isset($_POST['chat_id']) ? $_POST['chat_id'] : '';

    // 1. First send the sale success message
    $saleResults = [];
    if (empty($chatId)) {
        foreach ($chatIds as $chatId) {
            $result = sendToTelegram($botToken, $chatId, $message, $parseMode);
            $saleResults[] = [
                'chat_id' => $chatId,
                'result' => $result
            ];
        }
    } else {
        $result = sendToTelegram($botToken, $chatId, $message, $parseMode);
        $saleResults[] = [
            'chat_id' => $chatId,
            'result' => $result
        ];
    }

    // 2. Then check stock conditions and send alerts ONLY if needed
    $stockAlertResults = [];
    $stockAlertsSent = false;

    // Check if low stock count changed AND there are low stock items
    if ($array[0] != $low_stock_count && $low_stock_count > 0) {
        // Send Low Stock alert
        $lowStockMessage = "⚠️ *Low Stock Alert*\n\n";
        $lowStockMessage .= "Attention: *$low_stock_count* product(s) are running low on stock.\n\n";
        $lowStockMessage .= "📦 *Action Required:*\n";
        $lowStockMessage .= "• Check inventory levels\n";
        $lowStockMessage .= "• Plan for restocking\n";
        $lowStockMessage .= "• Review sales trends\n\n";
        $lowStockMessage .= "Please take necessary action to avoid stockouts.";

        foreach ($chatIds as $chatId) {
            $result = sendToTelegram($botToken, $chatId, $lowStockMessage, 'Markdown');
            $stockAlertResults[] = [
                'chat_id' => $chatId,
                'type' => 'low_stock',
                'result' => $result
            ];
        }
        $stockAlertsSent = true;
    }

    // Check if out of stock count changed AND there are out of stock items
    if ($array[1] != $out_of_stock_count && $out_of_stock_count > 0) {
        // Send Out of Stock alert
        $outStockMessage = "🚫 *URGENT: Out of Stock Alert*\n\n";
        $outStockMessage .= "Critical: *$out_of_stock_count* product(s) are completely OUT OF STOCK!\n\n";
        $outStockMessage .= "🔴 *Immediate Action Required:*\n";
        $outStockMessage .= "• Urgent restocking needed\n";
        $outStockMessage .= "• Check supplier lead times\n";
        $outStockMessage .= "• Update product status if needed\n\n";
        $outStockMessage .= "This affects sales and customer satisfaction. Please act immediately!";

        foreach ($chatIds as $chatId) {
            $result = sendToTelegram($botToken, $chatId, $outStockMessage, 'Markdown');
            $stockAlertResults[] = [
                'chat_id' => $chatId,
                'type' => 'out_of_stock',
                'result' => $result
            ];
        }
        $stockAlertsSent = true;
    }

    // Update the file with new counts if any alert was sent
    if ($stockAlertsSent) {
        file_put_contents('stock-file.txt', "$low_stock_count,$out_of_stock_count");
    }

    // Prepare response
    $response = [
        'ok' => true,
        'sale_message' => 'Sale completed message sent successfully',
        'sale_results' => $saleResults,
        'stock_alerts_sent' => $stockAlertsSent
    ];

    if ($stockAlertsSent) {
        $response['stock_alerts'] = $stockAlertResults;
        $response['stock_status'] = [
            'low_stock_count' => $low_stock_count,
            'out_of_stock_count' => $out_of_stock_count
        ];
    }

    echo json_encode($response);
    exit;
}

// Handle GET requests for stock check only (for cron jobs)
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['check_stock'])) {
    $stockAlertResults = [];
    $stockAlertsSent = false;

    // Check if low stock count changed AND there are low stock items
    if ($array[0] != $low_stock_count && $low_stock_count > 0) {
        // Send Low Stock alert
        $lowStockMessage = "⚠️ *Low Stock Alert*\n\n";
        $lowStockMessage .= "Attention: *$low_stock_count* product(s) are running low on stock.\n\n";
        $lowStockMessage .= "📦 *Action Required:*\n";
        $lowStockMessage .= "• Check inventory levels\n";
        $lowStockMessage .= "• Plan for restocking\n";
        $lowStockMessage .= "• Review sales trends\n\n";
        $lowStockMessage .= "Please take necessary action to avoid stockouts.";

        foreach ($chatIds as $chatId) {
            $result = sendToTelegram($botToken, $chatId, $lowStockMessage, 'Markdown');
            $stockAlertResults[] = [
                'chat_id' => $chatId,
                'type' => 'low_stock',
                'result' => $result
            ];
        }
        $stockAlertsSent = true;
    }

    // Check if out of stock count changed AND there are out of stock items
    if ($array[1] != $out_of_stock_count && $out_of_stock_count > 0) {
        // Send Out of Stock alert
        $outStockMessage = "🚫 *URGENT: Out of Stock Alert*\n\n";
        $outStockMessage .= "Critical: *$out_of_stock_count* product(s) are completely OUT OF STOCK!\n\n";
        $outStockMessage .= "🔴 *Immediate Action Required:*\n";
        $outStockMessage .= "• Urgent restocking needed\n";
        $outStockMessage .= "• Check supplier lead times\n";
        $outStockMessage .= "• Update product status if needed\n\n";
        $outStockMessage .= "This affects sales and customer satisfaction. Please act immediately!";

        foreach ($chatIds as $chatId) {
            $result = sendToTelegram($botToken, $chatId, $outStockMessage, 'Markdown');
            $stockAlertResults[] = [
                'chat_id' => $chatId,
                'type' => 'out_of_stock',
                'result' => $result
            ];
        }
        $stockAlertsSent = true;
    }

    // Update the file with new counts if any alert was sent
    if ($stockAlertsSent) {
        file_put_contents('stock-file.txt', "$low_stock_count,$out_of_stock_count");
    }

    $response = [
        'ok' => true,
        'stock_check_performed' => true,
        'stock_alerts_sent' => $stockAlertsSent,
        'current_stock' => [
            'low_stock' => $low_stock_count,
            'out_of_stock' => $out_of_stock_count
        ]
    ];

    if ($stockAlertsSent) {
        $response['stock_alerts'] = $stockAlertResults;
    }

    echo json_encode($response);
    exit;
}

// If no POST or GET with check_stock, show usage
echo json_encode([
    'ok' => false,
    'error' => 'Invalid request',
    'usage' => [
        'POST' => 'Send sale completion message and check stock',
        'GET' => 'Use ?check_stock=1 to check stock only'
    ]
]);

