<?php

require_once 'config/database.php';
exit("Script disabled to prevent accidental execution.");


// Disable foreign key checks
$pdo->exec("SET FOREIGN_KEY_CHECKS = 0");

// Tables to reset
$tables = [
     'customers',
     'end_day_stock',
     'products',
     'promotions',
     'sales',
     'sale_items',
     'shifts',
     'stock_logs',
     'system_logs'
];

// Truncate each table
foreach ($tables as $table) {
     $pdo->exec("TRUNCATE TABLE $table");
     echo "Reset table: $table<br>";
}

// Re-enable foreign key checks
$pdo->exec("SET FOREIGN_KEY_CHECKS = 1");

echo "Database reset complete!<br>";
echo "Users table preserved: " . $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn() . " rows<br>";
echo "Shop_info table preserved: " . $pdo->query("SELECT COUNT(*) FROM shop_info")->fetchColumn() . " rows<br>";
