<?php if (empty($products)): ?>
     <p>No products found.</p>
<?php else: ?>
     <?php foreach ($products as $product): ?>
         <div class="product-card <?php echo $product['stock'] <= 0 ? 'disabled' : ''; ?>"
              onclick="<?php echo $product['stock'] > 0 ? 'addToCart(' . $product['id'] . ')' : ''; ?>">
             <img src="assets/images/<?php echo $product['image'] ?: 'default-product.jpg'; ?>"
                  alt="<?php echo htmlspecialchars($product['name']); ?>">
             <h4><?php echo htmlspecialchars($product['name']); ?></h4>
             <div class="price">$<?php echo number_format($product['price'], 2); ?></div>
             <div class="stock <?php echo $product['stock'] <= 0 ? 'out-of-stock' : ($product['stock'] <= 10 ? 'low-stock' : ''); ?>">
                 Stock: <?php echo $product['stock']; ?>
             </div>
         </div>
     <?php endforeach; ?>
<?php endif; ?>

<nav aria-label="Page navigation example" class="mt-3">
     <ul class="pagination">
         <?php if ($page > 1): ?>
             <li class="page-item">
                 <a class="page-link" onclick="pagination(<?= $page - 1 ?>)">
                     <i class="fa fa-angle-double-left" aria-hidden="true"></i> Previous
                 </a>
             </li>
         <?php endif; ?>
         <?php if ($page < $totalPages): ?>
             <li class="page-item">
                 <a class="page-link" onclick="pagination(<?= $page + 1 ?>)">
                     Next <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                 </a>
             </li>
         <?php endif; ?>
     </ul>
</nav>