<?php
date_default_timezone_set('Asia/Phnom_Penh');
// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include authentication functions and database
require_once 'includes/auth.php';
require_once 'config/database.php';
require_once("autoclose-day.php");
require_once 'log_functions.php';


// Check if user is logged in and has appropriate role
if (!isLoggedIn()) {
    header('Location: index.php');
    exit();
}

checkRole(['cashier', 'admin', 'owner']);

// Get active shift for current cashier
$current_shift = null;
$shift_stmt = $pdo->prepare("SELECT * FROM shifts WHERE cashier_id = ? AND status = 'active' ORDER BY start_time DESC LIMIT 1");
$shift_stmt->execute([$_SESSION['user_id']]);
$current_shift = $shift_stmt->fetch();

// If no active shift, create one
if (!$current_shift && $_SESSION['user_role'] == 'cashier') {
    $stmt = $pdo->prepare("INSERT INTO shifts (cashier_id) VALUES (?)");
    $stmt->execute([$_SESSION['user_id']]);
    $current_shift_id = $pdo->lastInsertId();

    $shift_stmt = $pdo->prepare("SELECT * FROM shifts WHERE id = ?");
    $shift_stmt->execute([$current_shift_id]);
    $current_shift = $shift_stmt->fetch();
}

$today_sales_stmt = $pdo->prepare("SELECT SUM(total_amount) as total FROM sales WHERE DATE(created_at) = CURDATE() AND cashier_id = ?");
$today_sales_stmt->execute([$_SESSION['user_id']]);
$today_sales = $today_sales_stmt->fetchColumn();



// Casheir name fetch data 
// $casheir_name_stm = $pdo->prepare("SELECT full_name FROM users WHERE id = ?");
// $casheir_name_stm->execute([$_SESSION['user_id']]);
// $casheir_name_stm_resutl = $casheir_name_stm->fetchColumn();



$today_item_stmt = $pdo->prepare("
    SELECT SUM(si.quantity) as total 
    FROM sale_items si
    INNER JOIN sales s ON si.sale_id = s.id
    WHERE DATE(si.date) = CURDATE() 
    AND s.cashier_id = ?
");
$today_item_stmt->execute([$_SESSION['user_id']]);
$today_item = $today_item_stmt->fetchColumn();

// Get products from database with pagination
// $products_stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1 OFFSET = 12 ORDER BY name");
// $products_stmt->execute();
// $products = $products_stmt->fetchAll();

// Define pagination parameters
// $itemsPerPage = 12; // Number of items per page
// $page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1; // Get current page from URL
// $offset = ($page - 1) * $itemsPerPage; // Calculate offset

// $count_stmt = $pdo->prepare("SELECT COUNT(*) as total FROM products WHERE is_active = 1");
// $count_stmt->execute();
// $totalResult = $count_stmt->fetch();
// $totalItems = $totalResult['total'];
// $totalPages = ceil($totalItems / $itemsPerPage);

// $products_stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1 ORDER BY name LIMIT :limit OFFSET :offset");

// $products_stmt->bindValue(':limit', $itemsPerPage, PDO::PARAM_INT);
// $products_stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

// $products_stmt->execute();
// $products = $products_stmt->fetchAll();

// Initial load of products

$products_stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1");
$products_stmt->execute();
$products = $products_stmt->fetchAll();

// Get products from database with pagination end



// Handle sale completion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['complete_sale'])) {
    $customer_id = $_POST['customer_id'];
    try {
        $pdo->beginTransaction();

        // Get current year
        $current_year = date('Y');

        // Find the last bill number for current year
        $bill_stmt = $pdo->prepare("SELECT bill_number FROM sales WHERE bill_number LIKE ? ORDER BY id DESC LIMIT 1");
        $bill_stmt->execute(["BILL-{$current_year}-%"]);
        $last_bill = $bill_stmt->fetch();

        if ($last_bill) {
            // Extract the number from last bill (BILL-2025-000001 -> 000001)
            $parts = explode('-', $last_bill['bill_number']);
            $last_number = (int)end($parts);
            $next_number = $last_number + 1;
        } else {
            // First bill of the year
            $next_number = 1;
        }

        // Format with leading zeros (6 digits)
        $bill_number = sprintf('BILL-%s-%06d', $current_year, $next_number);

        $total_amount = $_POST['total_amount'];
        $cart_items = json_decode($_POST['cart_items'], true);

        // Insert sale
        $sale_stmt = $pdo->prepare("INSERT INTO sales (bill_number, cashier_id, shift_id, total_amount, final_amount, customer_id) VALUES (?, ?, ?, ?, ?, ?)");
        $sale_stmt->execute([$bill_number, $_SESSION['user_id'], $current_shift['id'], $total_amount, $total_amount, $customer_id]);
        $sale_id = $pdo->lastInsertId();

        // Insert sale items and update stock
        foreach ($cart_items as $item) {
            $sale_item_stmt = $pdo->prepare("INSERT INTO sale_items (sale_id, product_id, quantity, unit_price, total_price) VALUES (?, ?, ?, ?, ?)");
            $sale_item_stmt->execute([$sale_id, $item['id'], $item['quantity'], $item['price'], $item['price'] * $item['quantity']]);

            // Update product stock
            $update_stock_stmt = $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id = ?");
            $update_stock_stmt->execute([$item['quantity'], $item['id']]);

            // Log stock change
            $new_stock = $item['stock'] - $item['quantity'];
            $stock_log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, 'sale', ?, ?, 'POS Sale', ?)");
            $stock_log_stmt->execute([$item['id'], -$item['quantity'], $new_stock, $_SESSION['user_id']]);
        }

        // Update shift totals
        $update_shift_stmt = $pdo->prepare("UPDATE shifts SET total_sales = total_sales + ?, total_items = total_items + ? WHERE id = ?");
        $total_items = array_sum(array_column($cart_items, 'quantity'));
        $update_shift_stmt->execute([$total_amount, $total_items, $current_shift['id']]);

        $pdo->commit();

        // Log successful sale
        $logger->logSale('completed', $sale_id, $bill_number, [
            'total_amount' => $total_amount,
            'items_count' => count($cart_items),
            'payment_method' => 'cash' // or get from POST
        ]);

        // Log stock changes for each item
        foreach ($cart_items as $item) {
            $logger->logStock(
                'sale',
                $item['id'],
                -$item['quantity'],
                "POS Sale #$sale_id",
                [
                    'product_name' => $item['name'],
                    'new_stock' => $item['stock'] - $item['quantity']
                ]
            );
        }
        // return customer data with id
        // get customer 
        $customer_stmt = $pdo->prepare("SELECT * FROM customers WHERE id = ? LIMIT 1");
        $customer_stmt->execute([$customer_id]);
        $customer = $customer_stmt->fetch(PDO::FETCH_ASSOC);

        $customer_fullname = $customer ? $customer['fullname'] : 'N/A';
        $customer_phone = $customer ? $customer['phone'] : 'N/A';
        $customer_address = $customer ? $customer['address'] : 'N/A';

        // Return success response
        echo json_encode(['success' => true, 'bill_number' => $bill_number, 'sale_id' => $sale_id, 'customer_fullname' => $customer_fullname, 'customer_phone' => $customer_phone, 'customer_address' => $customer_address]);
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        // Log sale error
        $logger->logError('sales', 'Sale completion failed', $e->getMessage());
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
        exit;
    }
}

// Handle shift close
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['close_shift'])) {
    $stmt = $pdo->prepare("UPDATE shifts SET end_time = NOW(), status = 'closed' WHERE id = ?");
    $stmt->execute([$current_shift['id']]);

    // Create new shift
    $stmt = $pdo->prepare("INSERT INTO shifts (cashier_id) VALUES (?)");
    $stmt->execute([$_SESSION['user_id']]);



    echo "<script>
               alert('Shift closed successfully!');
               window.history.back();
          </script>";
    exit;
}

/// report generate here 
$report_data = [];
if (isset($_GET['generate_report'])) {

    $from_date = date("Y-m-d", strtotime($_GET['from_date'])) ?? date('Y-m-01');
    $to_date = date("Y-m-d", strtotime($_GET['to_date'])) ?? date('Y-m-d 23:59:59');
    // $to_date = $_GET['to_date'] ?? date('Y-m-d 23:59:59');

    // echo $from_date . " to " . $to_date;
    // exit;

    $report_type = $_GET['report_type'] ?? 'sales';
    $user_id = $_SESSION['user_id'];

    if ($report_type === 'sales') {
        // Sales by Bill
        $sales_by_bill_stmt = $pdo->prepare("
            SELECT s.bill_number, s.created_at, p.name, si.quantity, si.unit_price, si.total_price,
            customers.fullname as customer_name, customers.phone as customer_phone
            FROM sale_items si
            JOIN sales s ON si.sale_id = s.id
            JOIN products p ON si.product_id = p.id
            LEFT JOIN customers ON s.customer_id = customers.id
            WHERE DATE(s.created_at) BETWEEN ? AND ?
            AND s.cashier_id = ?
            ORDER BY s.created_at DESC, s.bill_number
        ");
        $sales_by_bill_stmt->execute([$from_date, $to_date, $user_id]);
        $report_data['sales_by_bill'] = $sales_by_bill_stmt->fetchAll();

        // Sales by Product
        $sales_by_product_stmt = $pdo->prepare("
            SELECT p.name, SUM(si.quantity) as total_qty, SUM(si.total_price) as total_sales, AVG(si.unit_price) as avg_price
            FROM sale_items si
            JOIN products p ON si.product_id = p.id
            JOIN sales s ON si.sale_id = s.id
            WHERE DATE(s.created_at) BETWEEN ? AND ?
            AND s.cashier_id = ?
            GROUP BY p.id, p.name
            ORDER BY total_sales DESC
        ");
        $sales_by_product_stmt->execute([$from_date, $to_date, $user_id]);
        $report_data['sales_by_product'] = $sales_by_product_stmt->fetchAll();

        // Total Sales Calendar
        $calendar_sales_stmt = $pdo->prepare("
            SELECT DATE(created_at) as sale_date, SUM(total_amount) as daily_total
            FROM sales 
            WHERE DATE(created_at) BETWEEN ? AND ?
            AND cashier_id = ?
            GROUP BY DATE(created_at)
            ORDER BY sale_date
        ");
        $calendar_sales_stmt->execute([$from_date, $to_date, $user_id]);
        $report_data['calendar_sales'] = $calendar_sales_stmt->fetchAll();
    } elseif ($report_type === 'stock') {
        // Sale Compare Stock
        $sale_compare_stmt = $pdo->prepare("
            SELECT 
                p.name,
                COALESCE(SUM(CASE WHEN sl.change_type = 'in' THEN sl.change_amount ELSE 0 END), 0) as beginning_stock,
                COALESCE(SUM(CASE WHEN sl.change_type = 'sale' THEN ABS(sl.change_amount) ELSE 0 END), 0) as qty_sold,
                p.stock as ending_stock,
                (COALESCE(SUM(CASE WHEN sl.change_type = 'in' THEN sl.change_amount ELSE 0 END), 0) - 
                 COALESCE(SUM(CASE WHEN sl.change_type = 'sale' THEN ABS(sl.change_amount) ELSE 0 END), 0) - p.stock) as variance
            FROM products p
            LEFT JOIN stock_logs sl ON p.id = sl.product_id AND DATE(sl.created_at) BETWEEN ? AND ?
            WHERE p.is_active = 1
            GROUP BY p.id, p.name, p.stock
            ORDER BY p.name
        ");
        $sale_compare_stmt->execute([$from_date, $to_date]);
        $report_data['sale_compare_stock'] = $sale_compare_stmt->fetchAll();
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_customer'])) {
    $fullname = trim($_POST['fullname']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']);

    // Insert new customer
    $stmt = $pdo->prepare("INSERT INTO customers (fullname, phone, address, created_by) VALUES (?, ?, ?, ?)");
    $stmt->execute([$fullname, $phone, $address, $_SESSION['user_id']]);

    // Redirect to prevent form resubmission
    // header("Location: " . $_SERVER['PHP_SELF']);
    echo "<script>
          alert('Customer added successfully. Please select the customer from the dropdown.');
          window.history.back();
     </script>";
    exit();
}

?>
<!DOCTYPE html>
<html lang="<?= $default_language == 'en' ? 'en' : 'km' ?>">

<head>
    <?php include_once('includes/meta.php') ?>
    <!-- <title>POS - <? #= $system['shop_name'] ?? 'Souvenir Shop' 
                        ?></title> -->
    <style>
        .cart-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 1rem;
        }

        .cart-table th,
        .cart-table td {
            padding: 0.75rem;
            text-align: left;
            border-bottom: 1px solid #ecf0f1;
        }

        .cart-table th {
            background: #34495e;
            color: white;
            font-weight: 600;
        }

        .cart-table tr:hover {
            background: #f8f9fa;
        }

        .quantity-controls {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .quantity-btn {
            background: #3498db;
            color: white;
            border: none;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.8rem;
        }

        .remove-btn {
            background: #e74c3c;
        }

        .shift-info {
            /* background: #2c3e50; */
            /* background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); */
            /* color: white; */
            padding: 0.5rem 0;
            /* border-radius: 5px; */
            margin-bottom: 1rem;
            border-bottom: 1px solid #9d9d9db0;
        }

        .low-stock {
            color: #e74c3c;
            font-weight: bold;
        }

        .out-of-stock {
            color: #e74c3c;
            font-style: italic;
        }

        .product-card.disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
    </style>
</head>

<body onload="checkingUpdate()">
    <!-- header  -->
    <?php include_once('includes/header.php') ?>
    <div class="container my-4">

        <!-- Shift Information -->
        <?php if ($current_shift): ?>
            <div class="shift-info d-flex justify-content-between">
                <!-- <strong>Shift Active</strong> |
                Start: <? #php echo date('H:i', strtotime($current_shift['start_time'])); 
                        ?> | -->
                <div class="text-dark">
                    <?= __("Today Sales") ?>: <span class="fw-bold">$ <?php echo number_format($today_sales, 2); ?></span> |
                    <?= __("Today Items") ?>: <span class="fw-bold"><?php echo $today_item ?? '0'; ?></span>
                </div>
                <!-- <div>
                    Total Sales: $<? #php echo number_format($current_shift['total_sales'], 2); 
                                    ?> |
                    Toal Items: <? #php echo $current_shift['total_items']; 
                                ?>
                </div> -->
            </div>
        <?php endif; ?>

        <div class="pos-container">

            <div class="products-section" id="pos_section">
                <div class="d-flex bg-search-pos" id="categoryFilter">
                    <a href="#" data-category="ទាំងអស់" class="btn text-primary btn-sm cat-filter active">ទាំងអស់</a>
                    <a href="#" data-category="បន្តោង" class="btn text-primary btn-sm cat-filter">បន្តោង</a>
                    <a href="#" data-category="ក្រវិល" class="btn text-primary btn-sm cat-filter">ក្រវិល</a>
                    <a href="#" data-category="ខ្សែដៃ" class="btn text-primary btn-sm cat-filter">ខ្សែដៃ</a>
                    <a href="#" data-category="ចិញ្ចៀន" class="btn text-primary btn-sm cat-filter">ចិញ្ចៀន</a>
                    <a href="#" data-category="ខ្សែក" class="btn text-primary btn-sm cat-filter">ខ្សែក</a>
                    <a href="#" data-category="ផ្សេងៗ" class="btn text-primary btn-sm cat-filter">ផ្សេងៗ</a>
                </div>
                <div class="bg-search-pos">
                    <div class="d-flex input-search">
                        <i class="fa fa-search pe-2" aria-hidden="true"></i>
                        <input type="text" placeholder="<?= __("Search") ?>..." id="pos_search">
                    </div>
                </div>
                <div class="products-grid" id="productsGrid">
                    <!-- Products will be loaded dynamically -->
                </div>

                <div id="paginationContainer">
                    <!-- Pagination will be loaded dynamically -->
                </div>
            </div>

            <div class="cart-section">
                <div class="cart-header">
                    <h3><i class="fa fa-shopping-cart" aria-hidden="true"></i> <?= __("Cart") ?></h3>
                    <div id="currentDateTime"></div>
                </div>

                <div class="pos-controls d-flex align-items-center" style="margin-bottom: 1rem;">
                    <!-- <button class="btn" onclick="showShiftReport()">Close Shift</button>
                    <button class="btn" onclick="showDailyReport()">Close Day</button> -->
                    <button class="btn btn-primary" onclick="showReport()" style="width: fit-content;"><i class="fa fa-file-text" aria-hidden="true"></i> <?= __("Your Report") ?></button>

                </div>

                <div class="cart-items" id="cartItems">
                    <div class="mb-2">
                        <!-- customer select -->
                        <label for="customerSelect" class="me-2 align-self-center fw-bold"><?= __("Customer") ?>:</label>
                        <div class="d-flex align-items-center justify-content-center gap-2">
                            <select id="customerSelect" class="form-select form-select-md" required>
                                <option value=""><?= __("Select customer") ?></option>
                                <?php
                                $customer_stmt = $pdo->prepare("SELECT * FROM customers WHERE active = 1 ORDER BY id DESC");
                                $customer_stmt->execute();
                                $customers = $customer_stmt->fetchAll();
                                foreach ($customers as $customer):
                                ?>
                                    <option value="<?php echo $customer['id']; ?>"><?php echo htmlspecialchars($customer['fullname']) . " - " . __("Tel") . " : " . $customer['phone']; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <a type="button" onclick="showAddCustomerModal()" class="fs-4" title="Add new customer"><i class="fa fa-plus-circle" aria-hidden="true"></i></a>
                        </div>
                    </div>
                    <table class="table table-hover" id="cartTable">
                        <thead>
                            <tr>
                                <th><?= __("Product") ?></th>
                                <th><?= __("Price") ?>
                                <th><?= __("Qty") ?></th>
                                <th><?= __("Total") ?></th>
                                <th><?= __("Action") ?></th>
                            </tr>
                        </thead>
                        <tbody id="cartTableBody">
                            <!-- Cart items will be populated by JavaScript -->
                        </tbody>
                    </table>
                    <div id="emptyCartMessage" style="text-align: center; color: #7f8c8d; padding: 2rem;">
                        <!-- <i class="fas fa-shopping-cart fa-2x"></i> -->
                        <i class="fa fa-shopping-cart fa-3x" aria-hidden="true"></i>
                        <p class="m-0 p-0"><?= __("Your cart is empty") ?></p>
                        <p><?= __("Click on products to add them") ?></p>
                    </div>
                </div>

                <div class="cart-total" id="cartTotal">
                    <?= __("Total") ?>: $ 0.00
                </div>

                <div class="pos-controls">
                    <button class="btn btn-danger" onclick="clearCart()"><i class="fa fa-refresh" aria-hidden="true"></i> <?= __("Clear Cart") ?></button>
                    <button class="btn btn-success" onclick="checkout()"><i class="fa fa-shopping-cart" aria-hidden="true"></i> <?= __("Pay now") ?></button>
                </div>
            </div>
        </div>


        <!-- Report Modals -->
        <!-- <div id="shiftReportModal" class="modal d-none">
            <div class="modal-content">
                <span class="close">&times;</span>
                <h2>Shift Report</h2>
                <div id="shiftReportContent">
                    <div class="shift-report">
                        <h4>Shift Summary</h4>
                        <p><strong>Start Time:</strong>
                            <?php echo $current_shift ? date('Y-m-d H:i', strtotime($current_shift['start_time'])) : 'N/A'; ?>
                        </p>
                        <p><strong>Total Sales:</strong>
                            $<?php echo $current_shift ? number_format($current_shift['total_sales'], 2) : '0.00'; ?>
                        </p>
                        <p><strong>Total Items Sold:</strong>
                            <?php echo $current_shift ? $current_shift['total_items'] : '0'; ?></p>
                        <p><strong>Current Shift Duration:</strong> <span
                                id="shiftDuration"><?php echo $current_shift ? floor((time() - strtotime($current_shift['start_time'])) / 3600) . ' hours ' . floor(((time() - strtotime($current_shift['start_time'])) % 3600) / 60) . ' minutes' : 'N/A'; ?></span>
                        </p>

                        <h4>Top Selling Items This Shift</h4>
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Qty Sold</th>
                                    <th>Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                        <div style="margin-top: 1rem;">
                            <button class="btn btn-success" onclick="closeShift()">Close Shift</button>
                            <button class="btn" onclick="printShiftReport()">Print Report</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->

        <div id="dailyReportModal"
            style="<?php echo isset($_GET['generate_report']) ? 'display: block;' : 'display: none;' ?>"
            class="modal">
            <div class="report-modal" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalCenterTitle"><?= __("Your Report") ?></h5>
                        <button type="button" class="close btn btn-sm" data-dismiss="modal"
                            onclick="closeReportModal()" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body pos_report">
                        <div class="filter-section">
                            <form method="GET" id="reportForm" onsubmit="return setReportTab()">
                                <input type="hidden" name="generate_report" value="1">

                                <input type="hidden" id="currentUsername"
                                    value="<?php echo htmlspecialchars($_SESSION['username'] ?? ''); ?>">
                                <input type="hidden" id="currentUserRole"
                                    value="<?php echo htmlspecialchars($_SESSION['user_role'] ?? ''); ?>">

                                <div class="filter-row">
                                    <div class="form-group">
                                        <label><i class="fas fa-calendar-alt"></i> <?= __("From Date") ?></label>
                                        <input type="text" name="from_date" class="form-control datepicker"
                                            value="<?php echo htmlspecialchars($_GET['from_date'] ?? date('01 M Y')); ?>"
                                            placeholder="<?= __("DD MMM YYYY") ?>"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <label><i class="fas fa-calendar-check"></i> <?= __("To Date") ?></label>
                                        <input type="text" name="to_date" class="form-control datepicker"
                                            value="<?php echo htmlspecialchars($_GET['to_date'] ?? date('d M Y')); ?>"
                                            placeholder="<?= __("DD MMM YYYY") ?>"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <label><i class="fas fa-chart-bar"></i> <?= __("Report Type") ?></label>
                                        <select name="report_type" id="reportTypeSelect" class="form-select">
                                            <?php $current_report_type = htmlspecialchars($_GET['report_type'] ?? 'sales'); ?>

                                            <option value="sales"
                                                <?php echo $current_report_type === 'sales' ? 'selected' : ''; ?>>
                                                <?= __("Sales Report") ?></option>

                                            <option value="stock"
                                                <?php echo $current_report_type === 'stock' ? 'selected' : ''; ?>>
                                                <?= __("Stock Report") ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="button-group">
                                    <button type="submit" class="btn btn-dark">
                                        <i class="fa fa-search" aria-hidden="true"></i> <?= __("Generate Report") ?>
                                    </button>
                                    <?php if (isset($_GET['generate_report'])): ?>
                                        <!-- <button type="button" class="btn btn-warning"
                                            onclick="printReportPosbutton('<? #php echo htmlspecialchars($_SESSION['username'] ?? ''); 
                                                                            ?>', '<?php echo htmlspecialchars($_SESSION['user_role'] ?? ''); ?>')">
                                            <i class="fa fa-print" aria-hidden="true"></i>
                                            Print Report
                                        </button>
                                        <button type="button" class="btn btn-success" onclick="exportReportPos()">
                                            <i class="fa fa-file-excel" aria-hidden="true"></i>
                                            </i> Export CSV
                                        </button> -->
                                    <?php endif; ?>
                                </div>
                            </form>
                        </div>

                        <?php if (isset($_GET['generate_report'])): ?>
                            <ul class="nav nav-tabs my-4" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="bill-tab" data-bs-toggle="tab"
                                        data-bs-target="#bill-tab-pane" type="button" role="tab"
                                        aria-controls="bill-tab-pane" aria-selected="true">
                                        <i class="fas fa-receipt"></i>
                                        <?= __("Views by Bill") ?></button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="product-tab" data-bs-toggle="tab"
                                        data-bs-target="#product-tab-pane" type="button" role="tab"
                                        aria-controls="product-tab-pane" aria-selected="false"> <i
                                            class="fas fa-cube"></i> <?= __("Views by Product") ?></button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="total-sale-tab" data-bs-toggle="tab"
                                        data-bs-target="#total-sale-tab-pane" type="button" role="tab"
                                        aria-controls="total-sale-tab-pane" aria-selected="false"><i
                                            class="fas fa-calendar"></i> <?= __("Total Sales") ?></button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="compare-stock-tab" data-bs-toggle="tab"
                                        data-bs-target="#compare-stock-tab-pane" type="button" role="tab"
                                        aria-controls="compare-stock-tab-pane" aria-selected="false"><i
                                            class="fas fa-balance-scale"></i> <?= __("Sale Compare Stock") ?></button>
                                </li>
                            </ul>
                            <div class="tab-content" id="reports" style="display: block;">
                                <div class="tab-pane fade show active" id="bill-tab-pane" role="tabpanel"
                                    aria-labelledby="bill-tab" tabindex="0">
                                    <h4><i class="fas fa-receipt"></i> <?= __("Sales by Bill") ?>
                                        (<?php echo date('d/M/Y', strtotime(htmlspecialchars($_GET['from_date']))) . ' - ' . date('d/M/Y', strtotime(htmlspecialchars($_GET['to_date']))); ?>)
                                    </h4>
                                    <?php if (!empty($report_data['sales_by_bill'])): ?>
                                        <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                                            <button type="button" onclick="printTable('salebybill_table', 'Sales by Bill')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                                            <button type="button" onclick="exportTableToCSV('salebybill_table', 'Sales by Bill')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                                        </div>

                                        <div class="respone-table">
                                            <div class="bg-table p-3">
                                                <table class="table table-striped table-hover" id="salebybill_table">
                                                    <thead>
                                                        <tr>
                                                            <th><?= __("Bill Number") ?></th>
                                                            <th><?= __("Customer") ?> / <?= __("Phone") ?></th>
                                                            <th><?= __("Date") ?> / <?= __("Time") ?></th>
                                                            <th><?= __("Item") ?></th>
                                                            <th><?= __("Unit Price") ?></th>
                                                            <th><?= __("Qty") ?></th>
                                                            <th><?= __("Amount") ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($report_data['sales_by_bill'] as $item): ?>
                                                            <tr>
                                                                <td><a type="button" onclick="modalDetailBill('<?= $item['bill_number'] ?>')" class="link text-dark"><?php echo htmlspecialchars($item['bill_number']); ?></a></td>
                                                                <td><?php echo htmlspecialchars($item['customer_name'] . " / " . $item['customer_phone']); ?></td>
                                                                <td><?php echo date('d M Y h:i A', strtotime($item['created_at'])); ?>
                                                                </td>
                                                                <td><?php echo htmlspecialchars($item['name']); ?></td>
                                                                <td>$<?php echo number_format($item['unit_price'], 2); ?>
                                                                </td>
                                                                <td><?php echo $item['quantity']; ?></td>
                                                                <td>$<?php echo number_format($item['total_price'], 2); ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                                            <i class="fas fa-receipt fa-4x"></i>
                                            <h4><?= __("No Sales Data Found") ?></h4>
                                            <p><?= __("No sales data available for the selected period.") ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="tab-pane fade" id="product-tab-pane" role="tabpanel"
                                    aria-labelledby="product-tab" tabindex="0">
                                    <h4><i class="fas fa-cube"></i> <?= __("Sales by Product") ?>
                                        (<?php echo date('d/M/Y', strtotime(htmlspecialchars($_GET['from_date']))) . ' - ' . date('d/M/Y', strtotime(htmlspecialchars($_GET['to_date']))); ?>)
                                    </h4>
                                    <?php if (!empty($report_data['sales_by_product'])): ?>
                                        <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                                            <button type="button" onclick="printTable('salebyproduct', 'Sales by Product')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                                            <button type="button" onclick="exportTableToCSV('salebyproduct', 'Sales by Product')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                                        </div>
                                        <div class="respone-table">
                                            <div class="bg-table p-3">
                                                <table class="table table-striped table-hover" id="salebyproduct">
                                                    <thead>
                                                        <tr>
                                                            <th><?= __("Product") ?></th>
                                                            <th><?= __("Total Qty") ?></th>
                                                            <th><?= __("Total Sales") ?></th>
                                                            <th><?= __("Average Price") ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($report_data['sales_by_product'] as $product): ?>
                                                            <tr>
                                                                <td><?php echo htmlspecialchars($product['name']); ?></td>
                                                                <td><?php echo $product['total_qty']; ?></td>
                                                                <td>$<?php echo number_format($product['total_sales'], 2); ?>
                                                                </td>
                                                                <td>$<?php echo number_format($product['avg_price'], 2); ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div style="text-align: center; padding: 3rem; color: #7f8c8d;">
                                            <i class="fas fa-cube fa-4x"></i>
                                            <h4><?= __("No Product Sales Data") ?></h4>
                                            <p><?= __("No product sales data available for the selected period.") ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="tab-pane fade" id="total-sale-tab-pane" role="tabpanel"
                                    aria-labelledby="total-sale-tab" tabindex="0">
                                    <h4><i class="fas fa-calendar"></i> <?= __("Total Sales Calendar View") ?>
                                        (<?php echo date('M Y', strtotime(htmlspecialchars($_GET['from_date']))); ?>)
                                    </h4>
                                    <?php
                                    if (isset($report_data['calendar_sales'])):
                                    ?>
                                        <div class="btn-group mt-2 mb-3" role="group" aria-label="Button group" id="button_group">
                                            <button type="button" class="btn btn-warning"
                                                onclick="printReportPosbutton('<?php echo htmlspecialchars($_SESSION['username'] ?? ''); ?>', '<?php echo htmlspecialchars($_SESSION['user_role'] ?? ''); ?>')">
                                                <i class="fa fa-print" aria-hidden="true"></i>
                                                <?= __("Print") ?>
                                            </button>
                                            <button type="button" class="btn btn-success" onclick="exportReportPos()">
                                                <i class="fa fa-file-excel" aria-hidden="true"></i>
                                                </i> <?= __("Export as CSV") ?>
                                            </button>
                                        </div>
                                        <div class="respone-table">
                                            <div class="calendar-view" id="calendarView">
                                                <?php
                                                // Generate calendar days
                                                $start_date = new DateTime(htmlspecialchars($_GET['from_date']));
                                                $end_date = new DateTime(htmlspecialchars($_GET['to_date']));
                                                $interval = new DateInterval('P1D');
                                                // The DatePeriod needs the end date to be included, so we add 1 day to the end date for the loop
                                                $end_date->modify('+1 day');
                                                $period = new DatePeriod($start_date, $interval, $end_date);

                                                // Create a map of sales by date
                                                $sales_by_date = [];
                                                foreach ($report_data['calendar_sales'] as $sale) {
                                                    $sales_by_date[$sale['sale_date']] = $sale['daily_total'];
                                                }

                                                // NOTE: If $report_data is not available, this loop may cause errors. 
                                                // Make sure $report_data is defined and contains 'calendar_sales' data before this block.

                                                foreach ($period as $date) {
                                                    $date_str = $date->format('Y-m-d');
                                                    $has_sales = isset($sales_by_date[$date_str]);
                                                    $sales_amount = $has_sales ? $sales_by_date[$date_str] : 0;
                                                ?>
                                                    <div class="calendar-day <?php echo $has_sales ? 'has-sales' : ''; ?>">
                                                        <?php echo $date->format('d'); ?>
                                                        <?php if ($has_sales): ?>
                                                            <div class="sales-amount">
                                                                $<?php echo number_format($sales_amount, 0); ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    <?php
                                    else:
                                    ?>
                                        <div style="text-align: center; padding: 4rem; color: #7f8c8d; background: #f8f9fa; border-radius: 15px;">
                                            <i class="fas fa-calendar fa-4x" style="margin-bottom: 1rem;"></i>
                                            <h4><?= __("No Total Sales Calendar View Data") ?></h4>
                                            <p><?= __("No Total Sales Calendar View data available for the selected period.") ?></p>
                                        </div>
                                    <?php endif; ?>

                                </div>

                                <div class="tab-pane fade" id="compare-stock-tab-pane" role="tabpanel"
                                    aria-labelledby="compare-stock-tab" tabindex="0">
                                    <h4><i class="fas fa-balance-scale"></i> <?= __("Sale Compare Stock") ?>
                                        (<?php echo date('d/M/Y', strtotime(htmlspecialchars($_GET['from_date']))) . ' - ' . date('d/M/Y', strtotime(htmlspecialchars($_GET['to_date']))); ?>)
                                    </h4>
                                    <?php if (!empty($report_data['sale_compare_stock'])): ?>
                                        <div class="btn-group  mb-3 mt-2" role="group" aria-label="Basic example">
                                            <button type="button" onclick="printTable('salecomparestock_table', 'Sale Compare Stock')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                                            <button type="button" onclick="exportTableToCSV('salecomparestock_table', 'Sale Compare Stock')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
                                        </div>
                                        <div class="respone-table">
                                            <div class="bg-table p-3">
                                                <table class="table table-striped table-hover" id="salecomparestock_table">
                                                    <thead>
                                                        <tr>
                                                            <th><?= __("Product") ?></th>
                                                            <th><?= __("Beginning Stock") ?></th>
                                                            <th><?= __("Qty Sold") ?></th>
                                                            <th><?= __("Ending Stock") ?></th>
                                                            <th><?= __("Stock Variance") ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($report_data['sale_compare_stock'] as $item): ?>
                                                            <tr>
                                                                <td><?php echo htmlspecialchars($item['name']); ?></td>
                                                                <td><?php echo $item['beginning_stock']; ?></td>
                                                                <td><?php echo $item['qty_sold']; ?></td>
                                                                <td><?php echo $item['ending_stock']; ?></td>
                                                                <td
                                                                    style="color: <?php echo $item['variance'] == 0 ? 'green' : 'red'; ?>; font-weight: bold;">
                                                                    <?php echo $item['variance']; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div
                                            style="text-align: center; padding: 4rem; color: #7f8c8d; background: #f8f9fa; border-radius: 15px;">
                                            <i class="fas fa-chart-bar fa-4x" style="margin-bottom: 1rem;"></i>
                                            <h4><?= __("No Report Generated") ?></h4>
                                            <p><?= __('Select date range and report type, then click "Generate Report" to view
                                                analytics.') ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add User Modal -->
    <div id="addCustomerModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2><?= __("Add New Customer") ?></h2>
            <form method="POST">
                <div class="form-group">
                    <label><?= __("Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="<?= __("Name") ?>" name="fullname" required>
                </div>
                <div class="form-group">
                    <label><?= __("Phone") ?> <span class="text-danger">*</span></label>
                    <input type="tel" class="form-control" placeholder="<?= __("Phone") ?>" name="phone" required>
                </div>
                <div class="form-group">
                    <label><?= __("Address") ?></label>
                    <textarea type="tel" class="form-control" placeholder="<?= __("Address") ?>" name="address"></textarea>
                </div>

                <button type="submit" class="btn btn-primary" name="add_customer"><?= __("Add Customer") ?></button>
            </form>
        </div>
    </div>

    <?php include_once('includes/script.php'); ?>

    <script>
        function checkingUpdate() {
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // window.location.reload();
                // document.getElementById("updateAlert").innerHTML = this.responseText;
                if (this.responseText === "RELOAD") {
                    // alert("Hello world");
                    window.location.reload();
                }
            }
            xhttp.open("GET", "checkupdate-product.php");
            xhttp.send();
        }
        setInterval(checkingUpdate, 3000);
    </script>
    <script>
        $(document).ready(function() {
            $("#recent_sale_table").dataTable({
                "order": [],
            });
            $("#productsTable").dataTable({
                "order": [],
            });
            $("#salebybill_table").dataTable({
                "order": [],
            });
            $("#salebyproduct").dataTable({
                "order": [],
            });
            $("#salecomparestock_table").dataTable({
                "order": [],
            });
        });

        function showAddCustomerModal() {
            document.getElementById('addCustomerModal').style.display = 'block';
        }

        function closeReportModal() {
            if (window.history && window.history.replaceState) {
                history.replaceState(null, '', 'pos.php');
                $('#dailyReportModal').hide();
            }
        }

        function pagination(page) {
            // Validate page number
            if (page < 1) page = 1;

            // Show loading indicator
            document.getElementById('productsGrid').innerHTML = `
                    <div class="text-center py-5" style="grid-column: 1 / -1;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="mt-2">Loading products...</p>
                    </div>
                `;

            // Update URL without reload using history.replaceState
            if (window.history && window.history.replaceState) {
                const url = new URL(window.location);
                url.searchParams.set('page', page);
                history.replaceState(null, '', url.toString());
            }

            // Make AJAX request
            fetch(`fetch_products.php?page=${page}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Update products grid
                        document.getElementById('productsGrid').innerHTML = data.products;

                        // Update pagination
                        document.getElementById('paginationContainer').innerHTML = data.pagination;
                    } else {
                        throw new Error('Failed to load products');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('productsGrid').innerHTML = `
                <div class="alert alert-danger" style="grid-column: 1 / -1;">
                    Error loading products. Please try again.
                </div>
            `;
                });
        }
    </script>


    <!-- print and export section js -->

    <!-- // print section  -->
    <script>
        function printReportPosbutton(username = 'Unknown User', userRole = 'Unknown Role') {
            const activeReportTab = document.querySelector('#reports .tab-pane.active');
            if (!activeReportTab) {
                alert('No active report tab found.');
                return;
            }

            // ===========================================
            // CENTRALIZED FONT SIZE CONTROL - CHANGE HERE
            // ===========================================
            const fontSizeSettings = {
                body: '14px', // Main body text
                header1: '24px', // Shop name
                header2: '18px', // Report title
                info: '13px', // Generated by, date range info
                table: '13px', // Table text
                tableHeader: '13px', // Table header text
                printBody: '13px', // Body text when printing
                printTable: '12px' // Table text when printing
            };
            // ===========================================

            // Get report title and remove dates from it
            const reportTitleWithDate = activeReportTab.querySelector('h4').innerText;

            // Remove date ranges from report titles (anything in parentheses)
            let reportTitle = reportTitleWithDate.replace(/\s*\(.*\)$/, '');

            // If it's "Sale Compare Stock", keep it as is, otherwise clean up
            if (reportTitleWithDate.includes('Sale Compare Stock')) {
                reportTitle = 'Sale Compare Stock';
            }

            const shopName = "<?php echo addslashes($shop_info['shop_name'] ?? 'Souvenir Shop'); ?>";
            const currentDate = new Date().toLocaleString();

            // Get date range in dd/mmm/yyyy format
            const fromDate = formatDateForPrint(document.querySelector('input[name="from_date"]').value);
            const toDate = formatDateForPrint(document.querySelector('input[name="to_date"]').value);

            // Clone the table to avoid modifying the original
            const table = activeReportTab.querySelector('table');
            // print totalsale calendar
            if (!table) {
                printElementById("total-sale-tab-pane");
            }

            function printElementById(elementId) {
                // Store original HTML
                const originalContent = document.body.innerHTML;

                // Get the element to print
                const printContent = document.getElementById(elementId).innerHTML;

                // Replace entire body with just the element content
                document.body.innerHTML = printContent;

                // Add print-specific styling
                const style = document.createElement("style");
                style.innerHTML = `
                    @media print {
                        body { margin: 0; padding: 20px; }
                        .calendar-view { 
                            display: grid; 
                            grid-template-columns: repeat(7, 1fr);
                            gap: 10px;
                            margin-top: 20px;
                        }
                        .calendar-day { 
                            border: 1px solid #ddd; 
                            padding: 10px; 
                            text-align: center;
                            min-height: 60px;
                            position: relative;
                        }
                        .calendar-day.has-sales { 
                            background-color: #e8f5e9; 
                            border-color: #4caf50;
                        }
                        .sales-amount { 
                            font-size: 12px; 
                            color: #2e7d32; 
                            margin-top: 5px; 
                            font-weight: bold;
                        }
                    }
                `;
                document.head.appendChild(style);

                // Trigger print
                window.print();

                // Restore original content
                document.body.innerHTML = originalContent;

                // Re-attach event listeners if needed
                window.location.reload(); // Or use more specific restoration
            }



            const tableClone = table.cloneNode(true);

            // Create print window
            const printWindow = window.open('', '_blank', 'width=1200,height=700');

            // Build the print content
            const printContent = `
            <html>
                <head>
                    <title>${reportTitle} - ${shopName}</title>
                    <style>
                        body { 
                            font-family: Arial, sans-serif; 
                            margin: 15px; 
                            color: #333;
                            font-size: ${fontSizeSettings.body};
                        }
                        .print-header {
                            text-align: center;
                            margin-bottom: 20px;
                            border-bottom: 2px solid #333;
                            padding-bottom: 15px;
                        }
                        .print-header h1 {
                            color: #2c3e50;
                            margin: 0 0 8px 0;
                            font-size: ${fontSizeSettings.header1};
                        }
                        .print-header h2 {
                            margin: 5px 0;
                            font-size: ${fontSizeSettings.header2};
                            color: #34495e;
                        }
                        .print-info {
                            display: flex;
                            justify-content: space-between;
                            margin-bottom: 15px;
                            font-size: ${fontSizeSettings.info};
                            line-height: 1.3;
                        }
                        .print-info div {
                            margin-bottom: 3px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 15px;
                            font-size: ${fontSizeSettings.table};
                        }
                        th {
                            background-color: #34495e !important;
                            background-image: none !important;
                            color: white !important;
                            padding: 12px 8px;
                            text-align: center;
                            border: 1px solid #2c3e50;
                            font-weight: bold;
                            font-size: ${fontSizeSettings.tableHeader};
                            -webkit-print-color-adjust: exact;
                            print-color-adjust: exact;
                        }
                        td {
                            padding: 8px 7px;
                            border: 1px solid #ddd;
                            font-size: ${fontSizeSettings.table};
                            line-height: 1.2;
                            text-align: center;
                        }
                        tr:nth-child(even) {
                            background-color: #f8f9fa;
                        }
                        .no-print {
                            display: none;
                        }
                        td, th {
                            white-space: nowrap;
                            overflow: hidden;
                            text-overflow: ellipsis;
                            max-width: 200px;
                        }
                        td:nth-child(3) {
                            white-space: normal;
                            max-width: 250px;
                            text-align: left;
                        }
                        th:nth-child(3) {
                            text-align: center;
                            white-space: normal;
                        }
                        @media print {
                            body { 
                                margin: 10px; 
                                font-size: ${fontSizeSettings.printBody};
                            }
                            .print-header { 
                                margin-bottom: 10px; 
                                padding-bottom: 10px;
                            }
                            .print-header h1 { font-size: ${parseInt(fontSizeSettings.header1) - 2}px; }
                            .print-header h2 { font-size: ${parseInt(fontSizeSettings.header2) - 2}px; }
                            th { 
                                background-color: #34495e !important; 
                                background-image: none !important;
                                color: white !important; 
                                padding: 10px 6px;
                                font-size: ${fontSizeSettings.printTable};
                                -webkit-print-color-adjust: exact;
                                print-color-adjust: exact;
                            }
                            td { 
                                padding: 6px 5px;
                                font-size: ${fontSizeSettings.printTable};
                                text-align: center;
                            }
                            td:nth-child(3) { /* Item name column */
                                text-align: left;
                            }
                            th:nth-child(3) { /* Item header */
                                text-align: center;
                            }
                            table { font-size: ${fontSizeSettings.printTable}; }
                        }
                    </style>
                </head>
                <body>
                    <div class="print-header">
                        <h1>${shopName}</h1>
                        <h2>${reportTitle}</h2>
                    </div>
                    
                    <div class="print-info">
                        <div>
                            <strong>Generated By:</strong> ${username}<br>
                            <strong>Report Type:</strong> ${reportTitle}<br>
                            <strong>Date Range:</strong> ${fromDate} to ${toDate}
                        </div>
                        <div>
                            <strong>Print Date:</strong> ${currentDate}<br>
                            <strong>Page:</strong> 1
                        </div>
                    </div>
                    
                    ${tableClone.outerHTML}
                    
                    <script>
                        window.onload = function() {
                            const style = document.createElement('style');
                            style.innerHTML = '@media print { th { background-color: #34495e !important; color: white !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; } }';
                            document.head.appendChild(style);
                            
                            window.print();
                            setTimeout(function() {
                                window.close();
                            }, 500);
                        };
                    <\/script>
                </body>
            </html>`;

            printWindow.document.write(printContent);
            printWindow.document.close();
        }

        // Helper function to format date for print
        function formatDateForPrint(dateString) {
            if (!dateString) return '';
            const date = new Date(dateString);
            if (isNaN(date.getTime())) return dateString;

            const day = date.getDate().toString().padStart(2, '0');
            const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            const month = monthNames[date.getMonth()];
            const year = date.getFullYear();

            return `${day}/${month}/${year}`;
        }

        // export section 
        function exportReportPos() {
            const activeReportTab = document.querySelector('#reports .tab-pane.active');
            if (!activeReportTab) {
                alert('No active report tab found.');
                return;
            }

            // const table = activeReportTab.querySelector('table');
            // if (!table) {
            //     alert('No table data found to export.');
            //     return;
            // }

            // export totalsale calendar start

            const table = activeReportTab.querySelector("table");
            if (!table) {
                exportToCSV();
            }

            function exportToCSV() {
                // Get data from the calendar
                const calendarData = extractCalendarData();

                // Convert to CSV
                const csvContent = convertToCSV(calendarData);

                // Download the file
                downloadCSV(csvContent, "totalsales_calendar_" + "<?= date('d_M_Y_h_i_s') ?>" + ".csv");
            }

            function extractCalendarData() {
                const data = [];
                const days = document.querySelectorAll("#calendarView .calendar-day");

                // Get the month/year from the heading
                const heading = document.querySelector("#total-sale-tab-pane h4").textContent;
                const monthYearMatch = heading.match(/\(([^)]+)\)/);
                const monthYear = monthYearMatch ? monthYearMatch[1] : "";

                // Extract data for each day
                days.forEach((day) => {
                    const dayNumber = parseInt(day.textContent.match(/\d+/)[0]);
                    const hasSales = day.classList.contains("has-sales");
                    const salesAmount = hasSales ?
                        parseFloat(
                            day.querySelector(".sales-amount").textContent.replace(/[$,]/g, "")
                        ) :
                        0;

                    // Assuming we know the month/year, we can create a date
                    // You might need to adjust this based on your actual date structure
                    const currentDate = new Date();
                    const exportDate = new Date(
                        currentDate.getFullYear(),
                        currentDate.getMonth(),
                        dayNumber
                    );

                    data.push({
                        date: exportDate.toISOString().split("T")[0], // YYYY-MM-DD
                        day: dayNumber,
                        has_sales: hasSales ? "Yes" : "No",
                        sales_amount: salesAmount,
                        formatted_date: exportDate.toLocaleDateString("en-US", {
                            weekday: "short",
                            day: "numeric",
                            month: "short",
                            year: "numeric",
                        }),
                    });
                });

                return data;
            }

            function convertToCSV(data) {
                // CSV headers
                const headers = [
                    "Date",
                    "Day",
                    "Has Sales",
                    "Sales Amount ($)",
                    "Formatted Date",
                ];

                // Create CSV content
                let csvContent = headers.join(",") + "\n";

                // Add data rows
                data.forEach((item) => {
                    const row = [
                        `"${item.date}"`,
                        item.day,
                        `"${item.has_sales}"`,
                        item.sales_amount,
                        `"${item.formatted_date}"`,
                    ];
                    csvContent += row.join(",") + "\n";
                });

                return csvContent;
            }

            function downloadCSV(csvContent, filename) {
                // Create a blob and download link
                const blob = new Blob([csvContent], {
                    type: "text/csv;charset=utf-8;"
                });
                const url = URL.createObjectURL(blob);
                const link = document.createElement("a");

                // Set download attributes
                link.setAttribute("href", url);
                link.setAttribute("download", filename);
                link.style.visibility = "hidden";

                // Append to body and trigger download
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

                // Clean up
                URL.revokeObjectURL(url);
            }
            // export totalsale calendar end




            // Get the report title exactly as shown in the tab
            const reportTitle = activeReportTab.querySelector('h4').textContent
                .replace(/<i[^>]*>.*?<\/i>/g, '') // Remove icons
                .replace(/[^\w\s()-]/g, '') // Remove special characters except parentheses and hyphens
                .trim();

            const shopName = "<?php echo addslashes($shop_info['shop_name'] ?? 'Souvenir_Shop'); ?>";
            const username = "<?php echo addslashes($_SESSION['username']); ?>";
            const currentDate = new Date().toISOString().split('T')[0];

            let csvContent = '';

            // Add headers
            const headers = [];
            table.querySelectorAll('thead th').forEach(th => {
                headers.push(`"${th.textContent.trim()}"`);
            });
            csvContent += headers.join(',') + '\\n';

            // Add data rows
            table.querySelectorAll('tbody tr').forEach(tr => {
                const row = [];
                tr.querySelectorAll('td').forEach(td => {
                    // Remove any HTML and clean the text
                    let text = td.textContent.trim();
                    // Remove currency symbols and commas for numbers (but keep for item names)
                    if (td.cellIndex !== 2) { // Don't remove from item name column (adjust index as needed)
                        text = text.replace(/[$,]/g, '');
                    }
                    // Handle quotes in text
                    text = text.replace(/"/g, '""');
                    row.push(`"${text}"`);
                });
                csvContent += row.join(',') + '\\n';
            });

            // Create and download file
            const blob = new Blob([csvContent], {
                type: 'text/csv;charset=utf-8;'
            });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);

            // Use the exact report title for filename
            const fileName = `${reportTitle.replace(/\\s+/g, '_')}.csv`;

            link.setAttribute('href', url);
            link.setAttribute('download', fileName);
            link.style.visibility = 'hidden';

            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            // Show success message
            showExportSuccess();
        }
    </script>
    <!-- <script src="assets/js/pos.js"></script> -->

    <!-- // POS functionality with database integration -->
    <script>
        let cart = [];
        let products = <?php echo json_encode($products); ?>;

        // Load products on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateDateTime();
            setInterval(updateDateTime, 1000);
            updateCartDisplay();
        });

        function addToCart(productId) {
            const product = products.find(p => p.id === productId);
            if (!product || product.stock <= 0) return;

            const cartItem = cart.find(item => item.id === productId);

            if (cartItem) {
                if (cartItem.quantity < product.stock) {
                    cartItem.quantity++;
                } else {
                    alert('Not enough stock! Available: ' + product.stock);
                    return;
                }
            } else {
                cart.push({
                    id: product.id,
                    name: product.name,
                    price: parseFloat(product.price),
                    stock: parseInt(product.stock),
                    quantity: 1,
                    category: product.category
                });
            }

            updateCartDisplay();
        }

        function removeFromCart(productId) {
            cart = cart.filter(item => item.id !== productId);
            updateCartDisplay();
        }

        function updateQuantity(productId, change) {
            const cartItem = cart.find(item => item.id === productId);
            if (!cartItem) return;

            const product = products.find(p => p.id === productId);
            const newQuantity = cartItem.quantity + change;

            if (newQuantity <= 0) {
                removeFromCart(productId);
            } else if (newQuantity <= product.stock) {
                cartItem.quantity = newQuantity;
            } else {
                alert('Not enough stock! Available: ' + product.stock);
            }

            updateCartDisplay();
        }

        function updateCartDisplay() {
            const cartTableBody = document.getElementById('cartTableBody');
            const emptyCartMessage = document.getElementById('emptyCartMessage');
            const cartTotal = document.getElementById('cartTotal');

            if (cart.length === 0) {
                cartTableBody.innerHTML = '';
                emptyCartMessage.style.display = 'block';
            } else {
                emptyCartMessage.style.display = 'none';
                cartTableBody.innerHTML = cart.map(item => `
                    <tr>
                        <td>${item.name}</td>
                        <td>$${item.price.toFixed(2)}</td>
                        <td>
                            <div class="quantity-controls">
                                <button class="quantity-btn" onclick="updateQuantity(${item.id}, -1)">-</button>
                                <span>${item.quantity}</span>
                                <button class="quantity-btn" onclick="updateQuantity(${item.id}, 1)">+</button>
                            </div>
                        </td>
                        <td>$${(item.price * item.quantity).toFixed(2)}</td>
                        <td>
                            <button class="quantity-btn remove-btn" onclick="removeFromCart(${item.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `).join('');
            }

            const total = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);
            cartTotal.textContent = `<?= __("Total") ?>: $${total.toFixed(2)}`;
        }

        function clearCart() {
            if (cart.length === 0) {
                alert('Cart is already empty!');
                return;
            }

            if (confirm('Are you sure you want to clear the cart?')) {
                cart = [];
                updateCartDisplay();
            }
        }



        // function completeSale() {
        //     const total = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);

        //     // customer id 
        //     var customer_id = document.getElementById("customerSelect").value;

        //     // Send AJAX request to complete sale
        //     fetch('pos.php', {
        //             method: 'POST',
        //             headers: {
        //                 'Content-Type': 'application/x-www-form-urlencoded',
        //             },
        //             // body: 'customer_id =' + customer_id, complete_sale=1&total_amount=' + total + '&cart_items=' + JSON.stringify(cart)
        //             body: 'complete_sale=1&customer_id=' + customer_id + '&total_amount=' + total + '&cart_items=' + JSON.stringify(cart)
        //         })
        //         .then(response => response.json())
        //         // before 
        //         .then(data => {
        //             if (data.success) {
        //                 showBill(data.bill_number, data.customer_fullname, data.customer_phone, data.customer_address);
        //             } else {
        //                 alert('Error completing sale: ' + data.error);
        //             }
        //         })
        //         .catch(error => {
        //             alert('Error completing sale: ' + error);
        //         });
        // }

        function checkout() {
            var customer_id = document.getElementById("customerSelect").value;

            if (cart.length === 0 || customer_id == "") {
                alert('Please select Customer and Add Item into card before completing the sale.');
                return;
            } else {
                completeSale();
            }

        }


        function showBill(bill, customer_fullname, customer_phone, customer_address) {
            // const billNumber = 'BILL-' + Date.now();
            const billNumber = bill;
            const customerName = customer_fullname;
            const customerPhone = customer_phone;
            const customerAddress = customer_address;
            const total = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);

            const billContent = `
                <div class="bill-container">
                    <div class="bill-header">
                        <?php
                        if ($system['print_logo'] == '1') {
                        ?>
                            <img src="assets/images/<?= $system['logo'] ?? 'logo.png' ?>" alt="Logo" width="100">
                        <?php
                        }
                        ?>
                        <h2><?= $system['shop_name'] ?? "Souvenir Shop" ?></h2>
                        <p class="m-0 p-0"><?= $system['address'] ?? "-" ?></p>
                        <p class="m-0 p-0">Tel: <?= $system['phone'] ?? "-" ?></p>
                        <?php
                        if ($system['print_tax_id'] == '1') {
                        ?>
                            <p class="m-0 p-0">TAX ID: <?= $system['tax_rate'] ?? "-" ?></p>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="bill-info">
                        <p class="m-0 p-0"><strong><?= __("Bill No") ?>:</strong> ${billNumber}</p>
                        <p class="m-0 p-0"><strong><?= __("Date") ?>:</strong> <?= date("d M Y h:i:s A") ?></p>
                        <p class="m-0 p-0"><strong><?= __("Cashier") ?>:</strong> <?php echo $_SESSION['username']; ?></p>
                        <p class="m-0 p-0"><strong><?= __("Customer") ?>:</strong> ${customerName}</p>
                        <p class="m-0 p-0"><strong><?= __("Tel") ?>:</strong> ${customerPhone}</p>
                        <p class="m-0 p-0"><strong><?= __("Address") ?>:</strong> ${customerAddress}</p>
                    </div>
                    <div class="bill-items">
                        <table style="width: 100%; border-collapse: collapse;">
                            <thead>
                                <tr>
                                    <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;">#</th>
                                    <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Item") ?></th>
                                    <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Price") ?></th>
                                    <th style="text-align: center; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Qty") ?></th>
                                    <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Total") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                ${cart.map((item, index) => `
                                    <tr>
                                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">${index + 1}</td>
                                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">${item.name}</td>
                                        <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${item.price.toFixed(2)}</td>
                                        <td style="text-align: center; padding: 8px; border-bottom: 1px solid #ddd;">${item.quantity}</td>
                                        <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${(item.price * item.quantity).toFixed(2)}</td>
                                    </tr>
                                `).join('')}
                            </tbody>
                        </table>
                    </div>
                    <div class="bill-total">
                        <div style="display: flex; justify-content: space-between; font-size: 1.2rem; font-weight: bold; margin-top: 1rem; padding-top: 1rem; border-top: 2px solid #2c3e50;">
                            <span><?= __("Total") ?>:</span>
                            <span>$${total.toFixed(2)}</span>
                        </div>
                    </div>
                    <?php
                    if ($system['print_qrcode'] == '1') {
                    ?>
                    <img class="d-block m-auto mt-3" src="assets/images/<?= $system['qrcode'] ?? 'qrcode.jpg' ?>" alt="Qrcode" width="250"/>
                    <small class="text-muted text-center d-block"><?= __("Pay with QR Code.") ?></small>
                    <?php } ?>

                    <p style="text-align: center; margin-top: 1rem;"><?= $system["receipt_header"] ?? "Thank you for shopping with us!" ?></p>
                    <div class="d-flex justify-content-center gap-3" id="button_group">
                        <button onclick="printBill()" class="btn btn-warning btn-sm"><?= __("Print") ?></button>
                        <button onclick="closeBill()" class="btn btn-danger btn-sm"><?= __("Close") ?></button>
                    </div>
                </div>
            `;

            // Replace page content with bill
            document.body.innerHTML = billContent;
        }

        function printBill() {
            // Print the page
            window.print();
        }

        function closeBill() {
            window.location.reload();
        }




        /// TELEGRAM PUSH WHEN Complete SALE
        function completeSale() {
            const total = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);

            // customer id 
            var customer_id = document.getElementById("customerSelect").value;

            // Send AJAX request to complete sale
            fetch('pos.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'complete_sale=1&customer_id=' + customer_id + '&total_amount=' + total + '&cart_items=' + JSON.stringify(cart)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showBill(data.bill_number, data.customer_fullname, data.customer_phone, data.customer_address);

                        // Send Telegram notification after successful sale
                        sendTelegramNotification(data, cart, total);
                    } else {
                        alert('Error completing sale: ' + data.error);
                    }
                })
                .catch(error => {
                    alert('Error completing sale: ' + error);
                });
        }

        function sendTelegramNotification(saleData, cartItems, total) {
            // Format date and time
            const now = new Date();
            const formattedDate = now.toLocaleDateString('en-US', {
                day: 'numeric', // "d" - day without leading zero
                month: 'short', // "M" - short month name (Dec)
                year: 'numeric' // "Y" - full year
            });

            const formattedTime = now.toLocaleTimeString('en-US', {
                hour: 'numeric', // "h" - hour (1-12)
                minute: '2-digit', // "i" - minutes with leading zero
                hour12: true // "A" - AM/PM
            });

            // Start building the message
            let message = `<b>✅ SALE COMPLETED SUCCESSFULLY</b>\n`;
            message += `━━━━━━━━━━━━━━━━\n`;
            message += `<b>🆔 Bill No:</b> <code>${saleData.bill_number}</code>\n`;
            message += `<b>👤 Cashier:</b> <?= $_SESSION['full_name'] ?>\n`;
            message += `<b>📅 Date&Time:</b> ${formattedDate} ${formattedTime}\n`;
            message += `<b>👨‍💼 Customer:</b> ${saleData.customer_fullname || 'N/A'}\n`;
            message += `<b>📞 Phone:</b> ${saleData.customer_phone || 'N/A'}\n`;
            message += `<b>📍 Address:</b> ${saleData.customer_address || 'N/A'}\n`;
            message += `━━━━━━━━━━━━━━━━\n`;
            message += `<b>📋 ITEMS SOLD</b>\n`;
            message += `━━━━━━━━━━━━━━━━\n`;

            // Add cart items to the message
            cartItems.forEach((item, index) => {

                const itemTotal = item.price * item.quantity;
                message += `${index + 1}. <b>${item.name} (${item.category})</b>\n`;
                message += `Qty: ${item.quantity} × $${item.price.toFixed(2)} = <b>$${itemTotal.toFixed(2)}</b>\n`;
                // message += `Code: <code>${item.code || 'N/A'}</code>\n\n`;
            });

            message += `━━━━━━━━━━━━━━━━\n`;
            message += `<b>💰 Total:</b> $${total.toFixed(2)}\n`;
            message += `━━━━━━━━━━━━━━━━\n`;

            // Get the result div (create one if it doesn't exist)
            let resultDiv = document.getElementById('telegramResult');
            if (!resultDiv) {
                resultDiv = document.createElement('div');
                resultDiv.id = 'telegramResult';
                resultDiv.style.display = 'none';
                document.body.appendChild(resultDiv);
            }

            // Send the message via AJAX
            fetch('telegram/send_ajax.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `message=${encodeURIComponent(message)}&parse_mode=HTML`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.ok) {
                        console.log('✅ Telegram notification sent successfully!');
                        // Optional: Show success message to user
                        // alert('Sale completed and notification sent!');
                    } else {
                        console.error('❌ Failed to send Telegram notification:', data.description);
                    }
                })
                .catch(error => {
                    console.error('Network error while sending Telegram notification:', error);
                });
        }


        function updateDateTime() {
            const now = new Date();

            // Format date as dd MMM YYYY
            const dateFormatter = new Intl.DateTimeFormat('en-GB', {
                day: '2-digit',
                month: 'short',
                year: 'numeric'
            });

            const dateString = dateFormatter.format(now);
            const timeString = now.toLocaleTimeString();

            document.getElementById('currentDateTime').textContent =
                dateString + ' ' + timeString;
        }

        // Search functionality
        // by select 
        document.getElementById('category').addEventListener('change', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            if (searchTerm === 'all') {
                // alert('All');
                // fetch all product 
                renderFilteredProducts(products);
            } else {
                const filteredProducts = products.filter(product =>
                    product.name.toLowerCase().includes(searchTerm)
                );
                renderFilteredProducts(filteredProducts);
            }

        });

        document.getElementById('productSearch').addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const filteredProducts = products.filter(product =>
                product.name.toLowerCase().includes(searchTerm)
            );
            renderFilteredProducts(filteredProducts);
        });

        function renderFilteredProducts(filteredProducts) {
            const grid = document.getElementById('productsGrid');
            grid.innerHTML = filteredProducts.map(product => `
                <div class="product-card ${product.stock <= 0 || product.price === 0.00 ? 'disabled' : ''}" 
                     onclick="${product.stock > 0 ? 'addToCart(' + product.id + ')' : ''}">
                    <img src="assets/images/${product.image || 'default-product.jpg'}" alt="${product.name}">
                    <p class="m-0 p-0 text-muted">${product.p_code ?? 'N/A'}</p>
                    <h4>${product.name}</h4>
                    <div class="price">$${parseFloat(product.price).toFixed(2)}</div>
                    <div class="stock ${product.stock <= 0 ? 'out-of-stock' : (product.stock <= product.min_stock ? 'low-stock' : '')}">
                        Stock: ${product.stock}
                    </div>
                </div>
            `).join('');
        }

        // Report functions
        function showShiftReport() {
            document.getElementById('shiftReportModal').style.display = 'block';
        }

        function showDailyReport() {
            document.getElementById('dailyReportModal').style.display = 'block';
        }

        function showReport() {
            document.getElementById('dailyReportModal').style.display = 'block';

        }

        function closeShift() {
            if (confirm('Are you sure you want to close this shift?')) {
                fetch('pos.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: 'close_shift=1'
                    })
                    .then(response => {
                        alert('Shift closed successfully!');
                        window.location.reload();
                    })
                    .catch(error => {
                        alert('Error closing shift: ' + error);
                    });
            }
        }

        function closeDay() {
            if (confirm('Are you sure you want to close the day? This will finalize all transactions.')) {
                alert('Day closing functionality will be implemented here.');
            }
        }

        function printShiftReport() {
            const printContent = document.getElementById('shiftReportContent').innerHTML;
            const originalContent = document.body.innerHTML;

            document.body.innerHTML = printContent;
            window.print();
            document.body.innerHTML = originalContent;
            window.location.reload();
        }

        function printDailyReport() {
            const printContent = document.getElementById('dailyReportContent').innerHTML;
            const originalContent = document.body.innerHTML;

            document.body.innerHTML = printContent;
            window.print();
            document.body.innerHTML = originalContent;
            window.location.reload();
        }

        // Modal functionality
        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }

        // Close modals when clicking X
        document.querySelectorAll('.close').forEach(closeBtn => {
            closeBtn.addEventListener('click', function() {
                this.closest('.modal').style.display = 'none';
            });
        });

        // Close modals when clicking outside
        window.addEventListener('click', function(event) {
            document.querySelectorAll('.modal').forEach(modal => {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            });
        });

        // Image preview for profile photo
        document.getElementById('profilePhoto')?.addEventListener('change', function(e) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('photoPreview').src = e.target.result;
            }
            reader.readAsDataURL(this.files[0]);
        });

        // filter category 
        document.querySelectorAll('.cat-filter').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const category = this.getAttribute('data-category');
                // Update URL without page reload
                const url = new URL(window.location);
                url.searchParams.set('category', category);
                window.history.pushState({}, '', url);

                // Or redirect with the category parameter
                // window.location.href = `?category=${encodeURIComponent(category)}`;

                // Or filter content dynamically (AJAX)
                filterProductsByCategory(category);
            });
        });
    </script>

    <!-- //filter script  -->
    <script>
        // Global variables
        let currentCategory = 'ទាំងអស់';
        let currentPage = 1;
        let searchKeyword = '';
        const itemsPerPage = 8;
        let searchTimeout = null;

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            // Setup event listeners
            setupCategoryFilters();
            setupSearchInput();

            // Check URL parameters and load products
            loadFromURL();

            // Initial load
            loadProducts();
        });

        function loadFromURL() {
            const urlParams = new URLSearchParams(window.location.search);
            const urlCategory = urlParams.get('category');
            const urlPage = urlParams.get('page');
            const urlSearch = urlParams.get('search');

            // Set category from URL
            if (urlCategory) {
                setActiveCategory(urlCategory);
            } else {
                // If no category in URL, show 'ទាំងអស់' by default
                setActiveCategory('ទាំងអស់');
            }

            // Set page from URL
            if (urlPage) {
                currentPage = parseInt(urlPage);
            }

            // Set search from URL
            if (urlSearch) {
                searchKeyword = decodeURIComponent(urlSearch);
                document.getElementById('pos_search').value = searchKeyword;
            }
        }

        function setupCategoryFilters() {
            document.querySelectorAll('.cat-filter').forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    const category = this.getAttribute('data-category');

                    // Set active category
                    setActiveCategory(category);

                    // Reset to page 1 when changing category
                    currentPage = 1;

                    // Load products for this category
                    loadProducts();

                    // Update URL
                    updateURL();
                });
            });
        }

        function setupSearchInput() {
            const searchInput = document.getElementById('pos_search');

            // Real-time search with debounce
            searchInput.addEventListener('input', function() {
                clearTimeout(searchTimeout);

                searchTimeout = setTimeout(() => {
                    searchKeyword = this.value.trim();
                    currentPage = 1; // Reset to page 1 when searching

                    // Load products with search filter
                    loadProducts();

                    // Update URL
                    updateURL();
                }, 300); // 300ms debounce
            });

            // Clear search button (optional)
            searchInput.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    this.value = '';
                    searchKeyword = '';
                    currentPage = 1;
                    loadProducts();
                    updateURL();
                }
            });
        }

        function setActiveCategory(category) {
            // Update active state
            document.querySelectorAll('.cat-filter').forEach(btn => {
                btn.classList.remove('active');
                if (btn.getAttribute('data-category') === category) {
                    btn.classList.add('active');
                }
            });
            currentCategory = category;
        }

        function loadProducts() {
            // Show loading
            showLoading();

            // Send AJAX request
            const formData = new FormData();
            formData.append('category', currentCategory);
            formData.append('page', currentPage);
            formData.append('search', searchKeyword);
            formData.append('itemsPerPage', itemsPerPage);

            fetch('ajax/filter_products.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        renderProducts(data.products);
                        renderPagination(data.totalPages, data.currentPage);
                    } else {
                        showError('Error loading products: ' + (data.error || 'Unknown error'));
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showError('Network error. Please try again.');
                });
        }

        function showLoading() {
            const grid = document.getElementById('productsGrid');
            grid.innerHTML = `
                <div class="loading-container" style="grid-column: 1/-1; text-align: center; padding: 50px;">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2 text-muted">Loading products...</p>
                </div>
            `;
        }

        function renderProducts(products) {
            const grid = document.getElementById('productsGrid');

            if (!products || products.length === 0) {
                let message = 'No products found.';
                if (searchKeyword) {
                    message = `No products found for "${searchKeyword}"`;
                    if (currentCategory !== 'ទាំងអស់') {
                        message += ` in ${currentCategory} category`;
                    }
                } else if (currentCategory !== 'ទាំងអស់') {
                    message = `No products found in ${currentCategory} category`;
                }

                grid.innerHTML = `
                    <div class="no-products" style="grid-column: 1/-1; text-align: center; padding: 50px;">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> ${message}
                        </div>
                    </div>
                `;
                return;
            }

            // Generate HTML for products
            let productsHTML = '';
            products.forEach(product => {
                const isDisabled = parseInt(product.stock) <= 0 || parseFloat(product.price) === 0.00;
                const isLowStock = parseInt(product.stock) <= parseInt(product.min_stock) && parseInt(product.stock) > 0;
                const stockClass = isDisabled ? '' : (isLowStock ? 'low-stock' : '');

                // Highlight search term in product name and code
                const highlightedName = searchKeyword ? highlightText(product.name, searchKeyword) : product.name;
                const highlightedCode = searchKeyword ? highlightText(product.p_code || 'N/A', searchKeyword) : (product.p_code || 'N/A');

                productsHTML += `
                    <div class="product-card ${isDisabled ? 'disabled' : ''}" 
                        onclick="${!isDisabled ? `addToCart(${product.id})` : ''}">
                        <img src="assets/images/${product.image || 'default-product.jpg'}" 
                            alt="${product.name}"
                            onerror="this.src='assets/images/default-product.jpg'">
                        <p class="m-0 p-0 text-muted">${highlightedCode}</p>
                        <h4>${highlightedName}</h4>
                        <div class="price">$${parseFloat(product.price).toFixed(2)}</div>
                        <div class="stock ${stockClass}">
                            Stock: ${product.stock}
                        </div>
                    </div>
                `;
            });

            grid.innerHTML = productsHTML;
        }

        function highlightText(text, searchTerm) {
            if (!searchTerm) return text;

            const regex = new RegExp(`(${searchTerm.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')})`, 'gi');
            return text.replace(regex, '<mark class="bg-warning">$1</mark>');
        }

        function renderPagination(totalPages, currentPage) {
            const paginationContainer = document.getElementById('paginationContainer');

            if (totalPages <= 1) {
                paginationContainer.innerHTML = '';
                return;
            }

            let paginationHTML = `
                <nav aria-label="Page navigation example" class="mt-3">
                    <ul class="pagination">
            `;

            // Previous button
            if (currentPage > 1) {
                paginationHTML += `
                    <li class="page-item">
                        <a class="page-link" href="#" onclick="changePage(${currentPage - 1}); return false;">
                            <i class="fa fa-angle-double-left" aria-hidden="true"></i> Previous
                        </a>
                    </li>
                `;
            }

            // Page numbers
            const maxVisiblePages = 5;
            let startPage = Math.max(1, currentPage - Math.floor(maxVisiblePages / 2));
            let endPage = Math.min(totalPages, startPage + maxVisiblePages - 1);

            // Adjust start page if we're near the end
            if (endPage - startPage + 1 < maxVisiblePages) {
                startPage = Math.max(1, endPage - maxVisiblePages + 1);
            }

            // First page and ellipsis
            if (startPage > 1) {
                paginationHTML += `
                    <li class="page-item ${1 === currentPage ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="changePage(1); return false;">1</a>
                    </li>
                `;
                if (startPage > 2) {
                    paginationHTML += '<li class="page-item disabled"><span class="page-link">...</span></li>';
                }
            }

            // Page numbers
            for (let i = startPage; i <= endPage; i++) {
                paginationHTML += `
                    <li class="page-item ${i === currentPage ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="changePage(${i}); return false;">${i}</a>
                    </li>
                `;
            }

            // Last page and ellipsis
            if (endPage < totalPages) {
                if (endPage < totalPages - 1) {
                    paginationHTML += '<li class="page-item disabled"><span class="page-link">...</span></li>';
                }
                paginationHTML += `
                    <li class="page-item ${totalPages === currentPage ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="changePage(${totalPages}); return false;">${totalPages}</a>
                    </li>
                `;
            }

            // Next button
            if (currentPage < totalPages) {
                paginationHTML += `
                    <li class="page-item">
                        <a class="page-link" href="#" onclick="changePage(${currentPage + 1}); return false;">
                            Next <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                        </a>
                    </li>
                `;
            }

            paginationHTML += `
                    </ul>
                </nav>
            `;

            paginationContainer.innerHTML = paginationHTML;
        }

        function changePage(page) {
            currentPage = page;
            loadProducts();
            updateURL();

            // Scroll to top of products grid
            document.getElementById('productsGrid').scrollIntoView({
                behavior: 'smooth'
            });
        }

        function updateURL() {
            const url = new URL(window.location);

            // Set category
            if (currentCategory !== 'ទាំងអស់') {
                url.searchParams.set('category', currentCategory);
            } else {
                url.searchParams.delete('category');
            }

            // Set page
            if (currentPage > 1) {
                url.searchParams.set('page', currentPage);
            } else {
                url.searchParams.delete('page');
            }

            // Set search
            if (searchKeyword) {
                url.searchParams.set('search', searchKeyword);
            } else {
                url.searchParams.delete('search');
            }

            // Update URL without reloading
            window.history.pushState({
                category: currentCategory,
                page: currentPage,
                search: searchKeyword
            }, '', url);
        }

        function showError(message) {
            const grid = document.getElementById('productsGrid');
            grid.innerHTML = `
                <div class="error-container" style="grid-column: 1/-1; text-align: center; padding: 50px;">
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i> ${message}
                    </div>
                </div>
            `;
        }

        // Handle browser back/forward buttons
        window.addEventListener('popstate', function(event) {
            // Reload from URL when user navigates with back/forward
            loadFromURL();
            loadProducts();
        });

        // Handle initial page load - if URL has parameters, use them
        window.addEventListener('load', function() {
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('category') || urlParams.has('search') || urlParams.has('page')) {
                loadFromURL();
                loadProducts();
            }
        });

        $("#customerSelect").select2();

        $(".datepicker").datepicker({
            format: 'dd M yyyy',
        });
        // $(".datepicker2").datepicker({
        //     dateFormat: 'dd mm yy'
        // });
    </script>

    <!-- show bill and re-print  -->
    <script>
        // Pass PHP variables to JavaScript
        window.shopName = "<?= addslashes($system['shop_name'] ?? 'Souvenir Shop') ?>";
        window.shopAddress = "<?= addslashes($system['address'] ?? '-') ?>";
        window.shopPhone = "<?= addslashes($system['phone'] ?? '-') ?>";
        window.receiptHeader = "<?= addslashes($system['receipt_header'] ?? 'Thank you for shopping with us!') ?>";
    </script>
    <script>
        function modalDetailBill(billNumber) {
            $.ajax({
                type: "POST",
                url: "ajax.php",
                data: {
                    bill_number: billNumber,
                },
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        const bill = response.data;

                        // Extract data
                        const billNum = bill.bill_number || billNumber;
                        const billDate = bill.created_at || new Date().toLocaleString();
                        const cashierName = bill.cashier_name || bill.cashier_username || bill.cashier_id || "N/A";
                        const customerName = bill.customer_name || "N/A";
                        const customerPhone = bill.customer_phone || "N/A";
                        const customerAddress = bill.customer_address || "N/A";

                        const paymentMethod = bill.payment_method || "N/A";
                        const subtotal = parseFloat(bill.total_amount) || 0;
                        const discount = parseFloat(bill.discount) || 0;
                        const total = parseFloat(bill.final_amount) || subtotal;
                        // alert(customerAddress);

                        // Generate items HTML
                        let itemsRows = '';
                        if (bill.items && bill.items.length > 0) {
                            itemsRows = bill.items.map((item, index) => `
                        <tr>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;">${index + 1}</td>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;">${item.product_name || "Item"}</td>
                            <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${(parseFloat(item.unit_price) || 0).toFixed(2)}</td>
                            <td style="text-align: center; padding: 8px; border-bottom: 1px solid #ddd;">${item.quantity || 1}</td>
                            <td style="text-align: right; padding: 8px; border-bottom: 1px solid #ddd;">$${(parseFloat(item.total_price) || 0).toFixed(2)}</td>
                        </tr>
                    `).join('');
                        }

                        // Create bill content - REPLACES ENTIRE BODY
                        const billContent = `
                            <div class="bill-container">
                                <div class="bill-header" style="text-align: center; margin-bottom: 20px;">
                                    <?php
                                    if ($system['print_logo'] == '1') {
                                    ?>
                                        <img src="assets/images/<?= $system['logo'] ?? 'logo.png' ?>" alt="Logo" width="100">
                                    <?php
                                    }
                                    ?>
                                        <h2><?= $system['shop_name'] ?? "Souvenir Shop" ?></h2>
                                        <p class="m-0 p-0"><?= $system['address'] ?? "-" ?></p>
                                        <p class="m-0 p-0">Tel: <?= $system['phone'] ?? "-" ?></p>

                                    <?php
                                    if ($system['print_tax_id'] == '1') {
                                    ?>
                                        <p class="m-0 p-0"><?= __("TAX ID") ?>: <?= $system['tax_rate'] ?? "-" ?></p>
                                    <?php
                                    }
                                    ?>
                                </div>
                                
                                <div class="bill-info" style="margin-bottom: 20px;">
                                    <p class="m-0 p-0"><strong><?= __("Bill No") ?>:</strong> ${billNum}</p>
                                    <p class="m-0 p-0"><strong><?= __("Date") ?>:</strong> ${billDate}</p>
                                    <p class="m-0 p-0"><strong><?= __("Cashier") ?>:</strong> ${cashierName}</p>
                                    <p class="m-0 p-0"><strong><?= __("Payment") ?> Method:</strong> ${paymentMethod}</p>
                                    <p class="m-0 p-0"><strong><?= __("Customer") ?>:</strong> ${customerName}</p>
                                    <p class="m-0 p-0"><strong><?= __("Tel") ?>:</strong> ${customerPhone}</p>
                                    <p class="m-0 p-0"><strong><?= __("Address") ?>:</strong> ${customerAddress}</p>
                                </div>
                                
                                <div class="bill-items">
                                    <table style="width: 100%; border-collapse: collapse;">
                                        <thead>
                                            <tr>
                                                <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;">#</th>
                                                <th style="text-align: left; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Item") ?></th>
                                                <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Price") ?></th>
                                                <th style="text-align: center; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Qty") ?></th>
                                                <th style="text-align: right; border-bottom: 1px solid #ddd; padding: 8px;"><?= __("Total") ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            ${itemsRows}
                                        </tbody>
                                    </table>
                                </div>
                                
                                <div class="bill-total" style="margin-top: 20px;">
                                    
                                    <div style="display: flex; justify-content: space-between; font-size: 1.2rem; font-weight: bold; margin-top: 1rem; padding-top: 1rem; border-top: 2px solid #2c3e50;">
                                        <span><?= __("Total") ?>:</span>
                                        <span>$${total.toFixed(2)}</span>
                                    </div>
                                </div>
                                <?php
                                if ($system['print_logo'] == '1') {
                                ?>

                                <img class="d-block m-auto mt-3" src="assets/images/<?= $system['qrcode'] ?? 'qrcode.jpg' ?>" alt="Qrcode" width="250"/>
                                <small class="text-muted text-center d-block"><?= __("Pay with QR Code.") ?></small>

                                <?php } ?>

                                <p style="text-align: center; margin-top: 1rem;">${window.receiptHeader || "Thank you for shopping with us!"}</p>
                                
                                <div style="display: flex; justify-content: center; gap: 1rem; margin-top: 20px;" id="button_group">
                                    <button onclick="window.print()" class="btn btn-warning btn-sm"><?= __("Print") ?></button>
                                    <button onclick="window.location.reload()" class="btn btn-danger btn-sm"><?= __("Back") ?></button>
                                </div>
                            </div>
                        `;

                        // Replace entire body with bill content
                        document.body.innerHTML = billContent;

                    } else {
                        alert("Error: " + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", xhr.responseText);
                    alert("Failed to load bill details.");
                },
            });
        }
    </script>

</body>

</html>