<?php
require_once('telegram/telegram_config.php');
// Handle product actions
$message = '';
$current_file = basename($_SERVER['PHP_SELF']);


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     if (isset($_POST['add_product'])) {
          $name = $_POST['name'];
          $description = $_POST['description'];
          $price = $_POST['price'];
          $stock = $_POST['stock'];
          $min_stock = $_POST['min_stock'];
          $category = $_POST['category'];
          $created_by = $_SESSION['user_id'];
          $nameByCode = isset($_POST['nameByCode']) ? 1 : 0;

          // print_r($nameByCode);
          // exit;
          // check price and stock values eqal to zero
          if ($price <= 0 || $stock <= 0) {
               echo "<script>
                    alert('Error: Price and Stock must be greater than zero!');
                    window.history.back();
               </script>";
               exit;
          }

          // Define category to code prefix mapping
          $category_prefixes = [
               'បន្តោង' => 'A',
               'ក្រវិល' => 'B',
               'ខ្សែដៃ' => 'C',
               'ចិញ្ចៀន' => 'D',
               'ខ្សែក' => 'E',
               'ផ្សេងៗ' => 'Z'
          ];

          // Get the prefix for the selected category
          $prefix = isset($category_prefixes[$category]) ? $category_prefixes[$category] : 'Z';

          // Find the maximum p_code for this category
          $stmt = $pdo->prepare("SELECT p_code FROM products WHERE p_code LIKE ? ORDER BY p_code DESC LIMIT 1");
          $stmt->execute([$prefix . '-%']);
          $last_p_code = $stmt->fetch(PDO::FETCH_ASSOC);

          if ($last_p_code) {
               // Extract the number from the p_code (e.g., "A-001" -> 1)
               $last_number = intval(substr($last_p_code['p_code'], strpos($last_p_code['p_code'], '-') + 1));
               $new_number = $last_number + 1;
          } else {
               // If no p_code exists for this category, start from 1
               $new_number = 1;
          }

          // Format the new p_code (e.g., A-001, A-002)
          $p_code = $prefix . '-' . str_pad($new_number, 3, '0', STR_PAD_LEFT);

          // Handle image upload - Check for cropped image first
          $image = 'default-product.jpg';

          if (!empty($_POST['cropped_image_data'])) {
               // Handle base64 image from cropper
               $croppedImageData = $_POST['cropped_image_data'];

               // Extract the image data
               if (preg_match('/^data:image\/(\w+);base64,/', $croppedImageData, $type)) {
                    $imageData = substr($croppedImageData, strpos($croppedImageData, ',') + 1);
                    $imageData = base64_decode($imageData);

                    if ($imageData !== false) {
                         // Generate unique filename
                         $image = "product-" . uniqid() . '.jpg';
                         $upload_dir = 'assets/images/';

                         // Save the image
                         file_put_contents($upload_dir . $image, $imageData);
                    }
               }
          } elseif (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
               // Handle traditional file upload (fallback)
               $upload_dir = 'assets/images/';
               $image = "product-" . uniqid() . '_' . $_FILES['image']['name'];
               move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $image);
          }

          if ($nameByCode == 1) {
               $name = $p_code;
          }

          // Insert product with p_code
          $stmt = $pdo->prepare("INSERT INTO products (p_code, name, description, price, stock, min_stock, category, image, is_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 1)");
          $addProduct = $stmt->execute([$p_code, $name, $description, $price, $stock, $min_stock, $category, $image]);
          if ($addProduct) {
               // telegram alert ADD NEW PRODUCT
               $newProductMessage = "✅ *NEW PRODUCT ADDED*\n";
               $newProductMessage .= "━━━━━━━━━━━━━━━━\n";
               $newProductMessage .= "📦 Product Name: *$name*\n";
               $newProductMessage .= "📍 Category: $category\n";
               $newProductMessage .= "💰 Price: $" . number_format($price, 2) . "\n";
               $newProductMessage .= "📊 Stock: $stock units\n";
               $newProductMessage .= "🔖 Code: `$p_code`\n";
               $newProductMessage .= "━━━━━━━━━━━━━━━━\n";
               // $newProductMessage .= "✅ Added to inventory successfully";

               foreach ($chatIds as $chatId) {
                    $result = sendToTelegram($botToken, $chatId, $newProductMessage, 'Markdown');
                    $stockAlertResults[] = [
                         'chat_id' => $chatId,
                         'type' => 'new_product',
                         'result' => $result
                    ];
               }
          }
          // Get the new product ID
          $product_id = $pdo->lastInsertId();

          // Log stock addition
          $log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, 'in', ?, ?, 'New Product', ?)");
          $log_stmt->execute([$product_id, $stock, $stock, $created_by]);

          // Log activity
          $logger->logProduct('created', $product_id, $name, [
               'price' => $price,
               'stock' => $stock,
               'category' => $category
          ]);

          echo "<script>
               alert('Product added successfully with code: $p_code!');
               window.history.back();
          </script>";
          exit;
     } elseif (isset($_POST['edit_product'])) {
          $product_id = $_POST['product_id'];
          $name = $_POST['name'];
          $description = $_POST['description'];
          $price = $_POST['price'];
          $stock_to_add = isset($_POST['stock']) ? (int)$_POST['stock'] : 0;
          $min_stock = $_POST['min_stock'];
          // $category = $_POST['category'];
          $current_image = $_POST['current_image'] ?? '';
          $nameByCode = isset($_POST['nameByCode']) ? 1 : 0;


          // Get current product data
          $current_stmt = $pdo->prepare("SELECT stock, price, image, category as old_category, p_code, name as product_name FROM products WHERE id = ?");
          $current_stmt->execute([$product_id]);
          $current_data = $current_stmt->fetch(PDO::FETCH_ASSOC);

          $current_stock = $current_data['stock'];
          $current_price = $current_data['price'];
          $old_image = $current_data['image'];
          $old_category = $current_data['old_category'];
          $old_p_code = $current_data['p_code'];
          $product_name = $current_data['product_name'];



          // Define category to code prefix mapping
          $category_prefixes = [
               'បន្តោង' => 'A',
               'ក្រវិល' => 'B',
               'ខ្សែដៃ' => 'C',
               'ចិញ្ចៀន' => 'D',
               'ខ្សែក' => 'E',
               'ផ្សេងៗ' => 'Z'
          ];

          // Check if category has changed
          // if ($category != $old_category) {
          //      // Get the prefix for the new category
          //      $prefix = isset($category_prefixes[$category]) ? $category_prefixes[$category] : 'Z';

          //      // Find the maximum p_code for this new category
          //      $stmt = $pdo->prepare("SELECT p_code FROM products WHERE p_code LIKE ? AND id != ? ORDER BY p_code DESC LIMIT 1");
          //      $stmt->execute([$prefix . '-%', $product_id]);
          //      $last_p_code = $stmt->fetch(PDO::FETCH_ASSOC);

          //      if ($last_p_code) {
          //           // Extract the number from the p_code (e.g., "A-001" -> 1)
          //           $last_number = intval(substr($last_p_code['p_code'], strpos($last_p_code['p_code'], '-') + 1));
          //           $new_number = $last_number + 1;
          //      } else {
          //           // If no p_code exists for this category, start from 1
          //           $new_number = 1;
          //      }

          //      // Format the new p_code (e.g., A-001, A-002)
          //      $p_code = $prefix . '-' . str_pad($new_number, 3, '0', STR_PAD_LEFT);
          // } else {
          //      // Keep old p_code if category hasn't changed
          //      $p_code = $old_p_code;
          // }

          // if ($nameByCode == 1) {
          //      $name = $p_code;
          // }

          // Handle image upload - Check for cropped image first
          $image = $old_image; // Keep old image by default

          if (!empty($_POST['cropped_image_data'])) {
               // Handle base64 image from cropper
               $croppedImageData = $_POST['cropped_image_data'];

               // Extract the image data
               if (preg_match('/^data:image\/(\w+);base64,/', $croppedImageData, $type)) {
                    $imageData = substr($croppedImageData, strpos($croppedImageData, ',') + 1);
                    $imageData = base64_decode($imageData);

                    if ($imageData !== false) {
                         // Delete old image if exists and not default
                         if ($old_image != 'default-product.jpg' && !empty($old_image)) {
                              $upload_dir = 'assets/images/';
                              if (file_exists($upload_dir . $old_image)) {
                                   unlink($upload_dir . $old_image);
                              }
                         }

                         // Generate unique filename
                         $image = "product-" . uniqid() . '.jpg';
                         $upload_dir = 'assets/images/';

                         // Save the image
                         file_put_contents($upload_dir . $image, $imageData);
                    }
               }
          } elseif (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
               // Handle traditional file upload (fallback)
               $upload_dir = 'assets/images/';

               // Delete old image if exists and not default
               if ($old_image != 'default-product.jpg' && !empty($old_image)) {
                    if (file_exists($upload_dir . $old_image)) {
                         unlink($upload_dir . $old_image);
                    }
               }

               // Generate new filename
               $image = "product-" . uniqid() . '_' . basename($_FILES['image']['name']);
               move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $image);
          }

          // Calculate new stock value
          $new_stock_value = $current_stock + $stock_to_add;

          // Update product in database
          $stmt = $pdo->prepare("UPDATE products SET 
                    -- p_code = ?,
                    name = ?, 
                    description = ?, 
                    price = ?, 
                    stock = ?, 
                    min_stock = ?, 
                    -- category = ?, 
                    image = ?,
                    updated_at = NOW() 
                    WHERE id = ?");

          $success = $stmt->execute([
               // $p_code,
               $product_name,
               $description,
               $price,
               $new_stock_value,
               $min_stock,
               // $category,
               $image,
               $product_id
          ]);

          if ($success) {
               // Set update flag
               $updating = $pdo->prepare("UPDATE products SET is_update = 1 WHERE id = ?");
               $updating->execute([$product_id]);

               // Log stock change if any
               if ($stock_to_add != 0) {
                    $change_type = ($stock_to_add > 0) ? 'in' : 'out';
                    $reason = 'Manual Stock Update';

                    $log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, ?, ?, ?, ?, ?)");
                    $log_stmt->execute([
                         $product_id,
                         $change_type,
                         $stock_to_add,
                         $new_stock_value,
                         $reason,
                         $_SESSION['user_id']
                    ]);

                    // Log stock adjustment
                    $logger->logStock(
                         'adjustment',
                         $product_id,
                         $stock_to_add,
                         $reason,
                         [
                              'product_name' => $product_name,
                              'new_stock' => $new_stock_value
                         ]
                    );
               }

               // Add log entry if category changed
               // if ($category != $old_category) {
               //      $change_reason = "Category changed from '$old_category' to '$category'. Product code updated from $old_p_code to $p_code";

               //      $log_stmt = $pdo->prepare("INSERT INTO stock_logs (product_id, change_type, change_amount, new_stock, reason, created_by) VALUES (?, 'category_change', 0, ?, ?, ?)");
               //      $log_stmt->execute([
               //           $product_id,
               //           $new_stock_value,
               //           $change_reason,
               //           $_SESSION['user_id']
               //      ]);
               // }


               //TELEGRAM WHEN UPDATE Product 

               // telegram alert
               $updateMessage = "✅ *PRODUCT UPDATED*\n";
               $updateMessage .= "━━━━━━━━━━━━━━━━━━━━━━━\n";
               $updateMessage .= "📦 *Product Name:* $name\n";
               $updateMessage .= "🔖 *Product Code:* `$old_p_code`\n";
               $updateMessage .= "━━━━━━━━━━━━━━━━━━━━━━━\n";
               $updateMessage .= "📊 *Stock Update Details*\n";
               $updateMessage .= "• Previous Stock: $current_stock units\n";
               $updateMessage .= "• Added Stock: +$stock_to_add units\n";
               $updateMessage .= "• New Total Stock: *$new_stock_value units*\n";
               $updateMessage .= "━━━━━━━━━━━━━━━━━━━━━━━\n";
               $updateMessage .= "💰 *Price Update Details*\n";
               $updateMessage .= "• Previous Price: $" . number_format($current_price, 2) . "\n";
               $updateMessage .= "• New Price: $" . number_format($price, 2) . "\n";

               // $updateMessage .= "✅ Product updated successfully";

               foreach ($chatIds as $chatId) {
                    $result = sendToTelegram($botToken, $chatId, $updateMessage, 'Markdown');
                    $stockAlertResults[] = [
                         'chat_id' => $chatId,
                         'type' => 'update_product',
                         'result' => $result
                    ];
               }

               // Log the product update activity
               $logger->logProduct('updated', $product_id, $name, [
                    'price' => $price,
                    'stock' => $new_stock_value,
                    'category' => $old_category,
                    'image_changed' => ($image != $old_image)
               ]);
               $message = __("Product updated successfully!");
               echo "<script>
                         alert('" . $message . "');
                         window.history.back();
                    </script>";
               exit;
          } else {
               echo "<script>
                         alert('Error updating product!');
                         window.history.back();
                    </script>";
               exit;
          }
     } elseif (isset($_POST['delete_product_id'])) {
          $product_id = $_POST['delete_product_id'];
          
          // Get product details before deletion for logging
          $stmt = $pdo->prepare("SELECT name, p_code, category FROM products WHERE id = ?");
          $stmt->execute([$product_id]);
          $product_data = $stmt->fetch(PDO::FETCH_ASSOC);
          
          // Soft delete the product
          $stmt = $pdo->prepare("UPDATE products SET is_active = 0 WHERE id = ?");
          $stmt->execute([$product_id]);
          
          // Get user info for logging (assuming you have session user data)
          $user_id = $_SESSION['user_id'] ?? null;
          $username = $_SESSION['username'] ?? 'Unknown';
          
          // Log the product deletion
          $logger->log(
               'product_deleted',
               'products',
               "Product '{$product_data['name']}' (ID: $product_id) was soft-deleted by $username",
               'success', // Changed to 'warning' as deletion is a critical action
               $user_id, // User who performed the action
               [
                    'product_id' => $product_id,
                    'product_name' => $product_data['name'],
                    'product_code' => $product_data['p_code'],
                    'category_id' => $product_data['category'],
                    'deleted_by' => $username,
                    'user_id' => $user_id,
                    'action' => 'soft_delete',
                    'deleted_at' => date('Y-m-d H:i:s'),
                    'ip_address' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
                    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
               ]
          );

          echo "<script>
               alert('Product deleted successfully!');
               window.history.back();
          </script>";
          exit;
     } elseif (isset($_POST['save_end_day_stock'])) {
          $date = $_POST['date'];
          $created_by = $_SESSION['user_id'];
          $username = $_SESSION['username'];
          $i = 0;

          // Check if arrays are set
          if (isset($_POST['product_id']) && isset($_POST['actual_count'])) {
               $product_ids = $_POST['product_id'];
               $actual_counts = $_POST['actual_count'];

               $total_products = count($product_ids);
               $adjusted_products = 0;
               $total_difference = 0;


               // Start transaction for data consistency
               $pdo->beginTransaction();

               try {
                    // Log start of end day stock process
                    $logger->log(
                         'end_day_stock_start',
                         'inventory',
                         "Started end day stock process for date: $date. Products to process: $total_products",
                         'success',
                         null,
                         [
                              'date' => $date,
                              'user_id' => $created_by,
                              'username' => $username,
                              'total_products' => $total_products
                         ]
                    );

                    $product_details = []; // Store product details for summary

                    //update status last_count in tb end_day_stock
                    $stmt = $pdo->prepare("UPDATE end_day_stock SET last_count = 0");
                    $stmt->execute();

                    // print_r($actual_counts);
                    // echo "<br> <br>";

                    // print_r($product_ids);
                    // exit;

                    // Loop through all products
                    foreach ($product_ids as $key => $product_id) {

                         $actual_count = (int)$actual_counts[$key];

                         // Get current product stock
                         $product_stmt = $pdo->prepare("SELECT stock, name, p_code FROM products WHERE id = ?");
                         $product_stmt->execute([$product_id]);
                         $product = $product_stmt->fetch();

                         if ($product) {
                              $product_name = $product['name'];
                              $product_code = $product['p_code'];
                              $beginning_stock = (int)$product['stock'];

                              // Calculate sales quantity for today
                              $sales_stmt = $pdo->prepare("
                                   SELECT COALESCE(SUM(si.quantity), 0) as total_sold 
                                   FROM sale_items si 
                                   JOIN sales s ON si.sale_id = s.id 
                                   WHERE si.product_id = ? AND DATE(s.created_at) = ?
                                   ");
                              $sales_stmt->execute([$product_id, $date]);
                              $sales_qty = (int)$sales_stmt->fetchColumn();

                              // Calculate expected stock (beginning stock - sales)
                              $expected_stock = $beginning_stock - $sales_qty;

                              // Calculate difference (actual count - expected stock)
                              $difference = $actual_count - $expected_stock;

                              // Store product details for summary
                              $product_details[] = [
                                   'product_id' => $product_id,
                                   'product_name' => $product_name,
                                   'product_code' => $product_code,
                                   'beginning_stock' => $beginning_stock,
                                   'sales_qty' => $sales_qty,
                                   'expected_stock' => $expected_stock,
                                   'actual_count' => $actual_count,
                                   'difference' => $difference
                              ];

                              // Log individual product processing
                              $logger->log(
                                   'end_day_stock_product',
                                   'inventory',
                                   "Processing product: $product_name (ID: $product_id, Code: $product_code)",
                                   'success',
                                   null,
                                   [
                                        'product_id' => $product_id,
                                        'product_name' => $product_name,
                                        'product_code' => $product_code,
                                        'beginning_stock' => $beginning_stock,
                                        'sales_qty' => $sales_qty,
                                        'expected_stock' => $expected_stock,
                                        'actual_count' => $actual_count,
                                        'difference' => $difference,
                                        'date' => $date
                                   ]
                              );



                              // Insert into end_day_stock table
                              $stmt = $pdo->prepare("
                                   INSERT INTO end_day_stock 
                                   (product_id, date, beginning_stock, sales_qty, expected_stock, actual_count, difference, created_by, last_count) 
                                   VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
                                   ");
                              $stmt->execute([
                                   $product_id,
                                   $date,
                                   $beginning_stock,
                                   $sales_qty,
                                   $expected_stock,
                                   $actual_count,
                                   $difference,
                                   $created_by,
                                   1
                              ]);
                              $end_day_stock_id = $pdo->lastInsertId();

                              // Update product stock with actual count
                              $update_stmt = $pdo->prepare("UPDATE products SET stock = ?, is_update = 1 , updated_at = NOW() WHERE id = ?");
                              $update_stmt->execute([$actual_count, $product_id]);

                              // Set is_update flag
                              // $is_updating = $pdo->prepare("UPDATE products SET is_update = 1 WHERE id = ?");
                              // $is_updating->execute([$product_id]);

                              // Log the stock adjustment if there's a difference
                              if ($difference != 0) {
                                   $adjusted_products++;
                                   $total_difference += abs($difference);

                                   $change_type = $difference > 0 ? 'in' : 'out';
                                   $log_reason = "End day stock adjustment for date: $date. Actual: $actual_count, Expected: $expected_stock, Difference: $difference";

                                   $log_stmt = $pdo->prepare("
                                        INSERT INTO stock_logs 
                                        (product_id, end_day_stock_id, change_type, change_amount, new_stock, reason, created_by) 
                                        VALUES (?, ?, ?, ?, ?, ?, ?)
                                   ");
                                   $log_stmt->execute([
                                        $product_id,
                                        $end_day_stock_id,
                                        $change_type,
                                        abs($difference), // Use absolute value for change_amount
                                        $actual_count,
                                        $log_reason,
                                        $created_by
                                   ]);

                                   // Log stock adjustment
                                   $logger->logStock(
                                        'adjustment',
                                        $product_id,
                                        $difference,
                                        $log_reason,
                                        [
                                             'product_name' => $product_name,
                                             'product_code' => $product_code,
                                             'end_day_stock_id' => $end_day_stock_id,
                                             'date' => $date,
                                             'beginning_stock' => $beginning_stock,
                                             'expected_stock' => $expected_stock,
                                             'actual_count' => $actual_count,
                                             'adjustment_type' => $change_type
                                        ]
                                   );
                              } else {
                                   // Log no adjustment needed
                                   $logger->log(
                                        'end_day_stock_no_adjustment',
                                        'inventory',
                                        "No stock adjustment needed for product: $product_name (ID: $product_id)",
                                        'success',
                                        null,
                                        [
                                             'product_id' => $product_id,
                                             'product_name' => $product_name,
                                             'beginning_stock' => $beginning_stock,
                                             'actual_count' => $actual_count,
                                             'expected_stock' => $expected_stock,
                                             'date' => $date
                                        ]
                                   );
                              }
                         } else {
                              // Log error for product not found
                              $logger->logError(
                                   'inventory',
                                   "Product not found during end day stock save",
                                   "Product ID $product_id not found in database"
                              );
                         }
                    }
                    // Commit transaction
                    $pdo->commit();


                    //​ TELEGRAM ALERT WHEN user end_day_stock


                    // AFTER THE LOOP - Send Telegram notification for end day stock completion
                    if (count($product_ids) > 0) {
                         $currentDateTime = date('Y-m-d H:i:s');
                         $formattedDate = date('F j, Y', strtotime($date));
                         $formattedTime = date('h:i A');
                         $total_products = count($product_details);
                         $userProcessed = $_SESSION['full_name'];

                         // Calculate statistics
                         $perfect_matches = 0;
                         $overstock_products = 0;
                         $understock_products = 0;
                         $total_adjustment = 0;

                         foreach ($product_details as $product) {
                              if ($product['difference'] == 0) {
                                   $perfect_matches++;
                              } elseif ($product['difference'] > 0) {
                                   $overstock_products++;
                                   $total_adjustment += $product['difference'];
                              } else {
                                   $understock_products++;
                                   $total_adjustment += abs($product['difference']);
                              }
                         }

                         // Build Telegram message
                         $endDayMessage = "📊 *END DAY STOCK COMPLETED*\n";
                         $endDayMessage .= "══════════════════════════\n";
                         $endDayMessage .= "📅 *Date:* $formattedDate\n";
                         $endDayMessage .= "⏰ *Time:* $formattedTime\n";
                         $endDayMessage .= "👤 *Processed by:* $userProcessed\n"; // Add username if available
                         $endDayMessage .= "══════════════════════════\n";
                         $endDayMessage .= "📦 *Summary*\n";
                         $endDayMessage .= "├ Total Products: $total_products\n";
                         $endDayMessage .= "└ ✅ Perfect Match: $perfect_matches\n\n";
                         // $endDayMessage .= "├ 📈 Overstock: $overstock_products\n";
                         // $endDayMessage .= "└ 📉 Understock: $understock_products\n";

                         // if ($total_difference > 0) {
                         //      $endDayMessage .= "📊 *Adjustment Details*\n";
                         //      $endDayMessage .= "├ Total Adjustments: $adjusted_products products\n";
                         //      $endDayMessage .= "└ Total Units Adjusted: $total_adjustment units\n";
                         // }

                         $endDayMessage .= "══════════════════════════\n";
                         $endDayMessage .= "✅ *Status:* Inventory count completed successfully\n";
                         $endDayMessage .= "📝 All stock levels have been updated in the system.";

                         // Send to Telegram
                         foreach ($chatIds as $chatId) {
                              $result = sendToTelegram($botToken, $chatId, $endDayMessage, 'Markdown');
                              $stockAlertResults[] = [
                                   'chat_id' => $chatId,
                                   'type' => 'end_day_stock',
                                   'result' => $result
                              ];
                         }
                    }



                    // Log successful completion
                    $logger->log(
                         'end_day_stock_complete',
                         'inventory',
                         "End day stock process completed successfully for date: $date",
                         'success',
                         null,
                         [
                              'date' => $date,
                              'total_products_processed' => $total_products,
                              'adjusted_products' => $adjusted_products,
                              'total_difference' => $total_difference,
                              'user_id' => $created_by,
                              'username' => $username,
                              'product_summary' => $product_details
                         ]
                    );
                    // echo  "Done";
                    echo "<script>
                              alert('End Day Stock Saved!');
                              window.history.back();
                         </script>";
                    exit;
               } catch (Exception $e) {
                    // Rollback transaction on error
                    $pdo->rollBack();

                    // Log the error
                    $logger->logError(
                         'inventory',
                         "End day stock save failed",
                         $e->getMessage()
                    );

                    echo "<script>
                              alert('Error saving end day stock: " . addslashes($e->getMessage()) . "');
                              window.history.back();
                         </script>";
                    exit;
               }
          } else {
               // Log no data received error
               $logger->logError(
                    'inventory',
                    "End day stock save attempted with no data",
                    "No product_id or actual_count arrays received in POST data"
               );

               echo "<script>
                    Swal.fire({
                         icon: 'warning',
                         title: 'No Data',
                         text: 'No product data received!',
                         confirmButtonText: 'OK'
                    }).then((result) => {
                         window.history.back();
                    });
               </script>";
               exit;
          }
     }

     // Telegram Fucntion


}
?>
<div id="stockManagement" class="tab-content <?= (basename($_SERVER['PHP_SELF']) == 'stock.php' || (isset($current_tab) && $current_tab === 'stockManagement')) ? 'active' : '' ?>">
     <h3><?= __("Stock Management") ?></h3>

     <div class="filter-section">
          <h4><?= __("Stock Alerts") ?></h4>
          <div class="row">

               <div class="col-md-4">
                    <!-- <button class="btn btn-danger btn-lg w-100" onclick="filterStock('out')"><?= __("Out of Stock") ?> (<?php echo $out_of_stock_count; ?>)</button> -->
                    <button class="btn btn-danger btn-lg w-100" onclick="shortByStock('out')"><?= __("Out of Stock") ?> (<?php echo $out_of_stock_count; ?>)</button>
               </div>
               <div class="col-md-4">
                    <button class="btn btn-warning btn-lg w-100" onclick="shortByStock('low')"><?= __('Low Stock') ?> (<?php echo $low_stock_count; ?>)</button>
               </div>
               <div class="col-md-4">
                    <button class="btn btn-primary btn-lg w-100" onclick="shortByStock('all')"><?= __("All Items") ?> (<?php echo count($products); ?>)</button>
               </div>

          </div>
          <!-- <div style="display: flex; gap: 1rem; margin-bottom: 1rem;">
                        <button class="btn btn-danger" onclick="filterStock('out')">Out of Stock (<?php echo $out_of_stock_count; ?>)</button>

                        <button class="btn" style="background: #f39c12; color: white;" onclick="filterStock('low')">Low Stock (<?php echo $low_stock_count; ?>)</button>
                        <button class="btn" onclick="filterStock('all')">All Items (<?php echo count($products); ?>)</button>
                    </div> -->
     </div>


     <div class="row my-4">
          <div class="col-md-6">
               <div class="btn-group btn-rounded-0 mb-3" role="group" aria-label="Basic example">
                    <button type="button" onclick="printTable('productsTable', 'Stock Management')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                    <button type="button" onclick="exportTableToCSV('productsTable', 'Stock Management')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
               </div>
          </div>
          <div class="col-md-6">
               <div style="width: fit-content; margin-left:auto;">
                    <button class="btn btn-primary" onclick="showAddProductModal()">
                         <i class="fas fa-plus"></i> <?= __("Add New Product") ?>
                    </button>
               </div>
          </div>
     </div>

     <!-- <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" id="productSearch" placeholder="Search products..." onkeyup="searchProducts()">
                </div> -->

     <div class="respone-table">
          <div class="bg-table p-3">
               <table class="table table-striped table-hover" id="productsTable">
                    <thead>
                         <tr>
                              <th><?= __("Image") ?></th>
                              <th><?= __("Code") ?></th>
                              <th><?= __("Product Name") ?></th>
                              <th><?= __("Category") ?></th>
                              <th><?= __("Current Stock") ?></th>
                              <th><?= __("Min Stock") ?></th>
                              <th><?= __("Price") ?></th>
                              <th><?= __("Status") ?></th>
                              <th><?= __("Actions") ?></th>
                         </tr>
                    </thead>
                    <tbody id="productsTableBody">
                         <?php foreach ($products as $product): ?>
                              <?php
                              $status_class = '';
                              $status_text = __("In Stock");
                              if ($product['stock'] == 0) {
                                   $status_class = 'alert-low';
                                   $status_text = __("Out of Stock");
                              } elseif ($product['stock'] <= $product['min_stock']) {
                                   $status_class = 'alert-medium';
                                   $status_text = __("Low Stock");
                              }
                              ?>
                              <tr data-stock="<?php echo $product['stock']; ?>" data-min-stock="<?php echo $product['min_stock']; ?>">
                                   <td><img src="assets/images/<?= $product['image'] ?? "default-product.jpg" ?>" width="40" alt="Product"></td>
                                   <!-- <td>P<? #php echo str_pad($product['id'], 3, '0', STR_PAD_LEFT); 
                                             ?></td> -->
                                   <td><?= $product['p_code'] ?? 'N/A'; ?></td>
                                   <td><?php echo htmlspecialchars($product['name']); ?></td>
                                   <td><?php echo htmlspecialchars($product['category'] ?: 'Uncategorized'); ?></td>
                                   <td class="<?php echo $status_class; ?>"><?php echo $product['stock']; ?></td>
                                   <td><?php echo $product['min_stock']; ?></td>
                                   <td>$<?php echo number_format($product['price'], 2); ?></td>
                                   <td>
                                        <p class="m-0 p-0"><span class="<?php echo $status_class; ?>"><?php echo $status_text; ?></span></p>
                                        <small class="text-muted"><?= date("d M Y h:i:s A", strtotime($product['created_at'])) ?></small>
                                   </td>
                                   <td>
                                        <a type="button" class="me-1 btn btn-sm btn-success" title="Edit" onclick="editProductButton(<?php echo $product['id']; ?>)">
                                             <i class="fa fa-edit" aria-hidden="true"></i>
                                        </a>
                                        <a type="button" class="btn btn-sm btn-danger" title="Delete" onclick="deleteProduct(<?php echo $product['id']; ?>)">
                                             <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>
                                   </td>
                              </tr>
                         <?php endforeach; ?>
                    </tbody>
               </table>
          </div>
     </div>


     <!-- <div style="margin-top: 1rem;">
                    <button class="btn btn-success" onclick="showAddProductModal()">
                        <i class="fas fa-plus"></i> Add New Product
                    </button>
                </div> -->
</div>

<!-- Add Product Modal -->
<div id="addProductModal" class="modal">
     <div class="modal-content">
          <span class="close">&times;</span>
          <h2><?= __("Add New Product") ?></h2>
          <form method="POST" enctype="multipart/form-data" id="addProductForm">
               <input type="hidden" name="add_product" value="1">
               <div class="form-group">
                    <label><?= __("Product Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="name" id="productNameInput" placeholder="<?= __("Product Name") ?>" readonly required>
               </div>
               <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" name="nameByCode" value="1" role="switch" id="switchNameByCategory" checked>
                    <label class="form-check-label" for="switchNameByCategory"><?= __("Use product code for name.") ?></label>
               </div>
               <div class="form-group">
                    <label><?= __("Description") ?></label>
                    <textarea name="description" class="form-control" placeholder="<?= __("Description") ?>" rows="3"></textarea>
               </div>
               <div class="form-group">
                    <label><?= __("Category") ?> <span class="text-danger">*</span></label>
                    <select name="category" class="form-select" required>
                         <option value="" disabled><?= __("Select Category") ?></option>
                         <option value="បន្តោង">បន្តោង [A-00X]</option>
                         <option value="ក្រវិល">ក្រវិល [B-00X]</option>
                         <option value="ខ្សែដៃ">ខ្សែដៃ [C-00X]</option>
                         <option value="ចិញ្ចៀន">ចិញ្ចៀន [D-00X]</option>
                         <option value="ខ្សែក">ខ្សែក [E-00X]</option>
                         <option value="ផ្សេងៗ">ផ្សេងៗ [Z-00X]</option>
                    </select>
               </div>
               <div class="form-group">
                    <label><?= __("Sale Price") ?> ($) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="price" min="0.01" placeholder="<?= __("Sale Price") ?>" step="0.01" required>
               </div>
               <div class="form-group">
                    <label><?= __("Stock In") ?> <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="stock" min="1" placeholder="<?= __("Stock In") ?>" required>
               </div>
               <div class="form-group">
                    <label><?= __("Minimum Stock Level") ?> <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="min_stock" min="1" placeholder="<?= __("Minimum Stock Level") ?>" value="10" required>
               </div>

               <!-- Product Image Upload Section -->
               <div class="form-group">
                    <label><?= __("Product Image") ?></label>

                    <!-- Drag & Drop Area -->
                    <div id="productDropArea" class="drag-drop-area" style="border: 2px dashed #ced4da; border-radius: 10px; padding: 30px 20px; text-align: center; margin-bottom: 15px; cursor: pointer; background: #f8f9fa; transition: all 0.3s;">
                         <div style="font-size: 48px; margin-bottom: 10px;">📷</div>
                         <h4 style="margin: 0 0 10px; color: #495057;"><?= __("Drag & Drop product photo here") ?></h4>
                         <p style="color: #6c757d; margin: 0 0 20px;"><?= __("or click to browse files") ?></p>
                         <button type="button" id="productBrowseBtn" class="btn btn-outline-primary">
                              📁 <?= __("Browse Files") ?>
                         </button>
                         <input type="file" name="image" class="form-control d-none" id="productImageInput" accept="image/*">
                    </div>

                    <!-- Selected File Info -->
                    <div id="productFileInfo" class="alert alert-info d-none" style="display: flex; align-items: center; justify-content: space-between;">
                         <div style="display: flex; align-items: center; gap: 10px;">
                              <span id="productFileIcon" style="font-size: 20px;">📷</span>
                              <div>
                                   <div id="productFileName" style="font-weight: bold;"></div>
                                   <div id="productFileSize" style="font-size: 12px;"></div>
                              </div>
                         </div>
                         <button type="button" id="productChangeFileBtn" class="btn btn-sm btn-outline-secondary"><?= __("Change") ?></button>
                    </div>

                    <!-- Hidden field for cropped image -->
                    <input type="hidden" name="cropped_image_data" id="productCroppedImageData">

                    <!-- Image Editor Section -->
                    <div id="productEditorSection" class="d-none">
                         <h5><?= __("Edit Product Image") ?></h5>
                         <div class="row">
                              <!-- Left: Image Editor -->
                              <div class="col-md-8">
                                   <div class="image-editor-container" style="background: #f8f9fa; border-radius: 8px; padding: 15px; margin-bottom: 15px;">
                                        <div id="productImageContainer" style="width: 100%; height: 300px; overflow: hidden; position: relative; background: #e9ecef; border-radius: 6px;">
                                             <img id="productImageToCrop" style="max-width: 100%; max-height: 100%; display: block; margin: 0 auto;">
                                        </div>

                                        <!-- Zoom Controls -->
                                        <div class="zoom-controls mt-3" style="text-align: center;">
                                             <div class="d-flex align-items-center justify-content-center gap-2">
                                                  <button type="button" id="productZoomOut" class="btn btn-sm btn-outline-secondary">-</button>
                                                  <input type="range" id="productZoomSlider" min="0.1" max="3" step="0.1" value="1" style="width: 60%;">
                                                  <button type="button" id="productZoomIn" class="btn btn-sm btn-outline-secondary">+</button>
                                                  <span id="productZoomValue" class="badge bg-secondary ms-2">100%</span>
                                             </div>
                                        </div>
                                   </div>
                              </div>

                              <!-- Right: Adjustments & Preview -->
                              <div class="col-md-4">
                                   <!-- Adjustment Controls -->
                                   <div class="adjustment-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                        <h6 class="mb-3">🛠️ <?= __("Adjustments") ?></h6>
                                        <div class="mb-3">
                                             <label class="form-label small d-flex justify-content-between">
                                                  <span>🔄 <?= __("Rotation") ?></span>
                                                  <span id="productRotationValue">0°</span>
                                             </label>
                                             <div class="d-flex gap-2">
                                                  <button type="button" id="productRotateLeft" class="btn btn-sm btn-outline-secondary flex-fill">↺</button>
                                                  <input type="range" id="productRotationSlider" min="-180" max="180" value="0" class="form-range flex-fill">
                                                  <button type="button" id="productRotateRight" class="btn btn-sm btn-outline-secondary flex-fill">↻</button>
                                             </div>
                                        </div>
                                   </div>

                                   <!-- Compression Settings -->
                                   <div class="compression-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                        <h6 class="mb-3">📦 <?= __("Compression") ?></h6>
                                        <div class="mb-3">
                                             <label class="form-label small d-flex justify-content-between">
                                                  <span><?= __("Quality") ?></span>
                                                  <span id="productQualityValue">85%</span>
                                             </label>
                                             <input type="range" id="productQualitySlider" min="10" max="100" value="85" class="form-range">
                                        </div>
                                        <div class="small text-muted">
                                             <i class="fas fa-weight-hanging"></i> <?= __("Estimated") ?>: <span id="productEstimatedSize">-</span>
                                        </div>
                                   </div>

                                   <!-- Preview -->
                                   <div class="preview-panel text-center" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                                        <div style="width: 100px; height: 100px; border-radius: 8px; overflow: hidden; border: 3px solid #007bff; margin: 0 auto 10px; background: #f8f9fa;">
                                             <img id="productCropPreview" style="width: 100%; height: 100%; object-fit: cover;">
                                        </div>
                                        <p class="small text-muted mb-0"><?= __("Preview") ?></p>
                                   </div>
                              </div>
                         </div>

                         <!-- Action Buttons -->
                         <div class="d-flex justify-content-between mt-3 pt-3 border-top">
                              <button type="button" id="productResetBtn" class="btn btn-outline-secondary">
                                   <i class="fas fa-redo"></i> <?= __("Reset All") ?>
                              </button>
                              <div class="d-flex gap-2">
                                   <button type="button" id="productCancelCropBtn" class="btn btn-secondary">
                                        <?= __("Cancel") ?>
                                   </button>
                                   <button type="button" id="productApplyCropBtn" class="btn btn-primary">
                                        <i class="fas fa-check"></i> <?= __("Apply Crop") ?>
                                   </button>
                              </div>
                         </div>
                    </div>

                    <!-- Final Image Preview -->
                    <div id="productFinalPreview" class="d-none mt-3 text-center">
                         <h6> <?= __("Product Image Preview") ?> </h6>
                         <div style="width: 150px; height: 150px; border-radius: 8px; overflow: hidden; border: 3px solid #28a745; margin: 0 auto 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                              <img id="productFinalImage" style="width: 100%; height: 100%; object-fit: cover;">
                         </div>
                         <button type="button" id="productEditAgainBtn" class="btn btn-outline-primary btn-sm">
                              <i class="fas fa-edit"></i> <?= __("Edit Again") ?>
                         </button>
                    </div>
               </div>

               <div class="d-flex justify-content-end gap-2 mt-4">
                    <button type="button" class="btn btn-secondary close-modal"><?= __('Cancel') ?></button>
                    <button type="submit" class="btn btn-primary"><?= __("Add Product") ?></button>
               </div>
          </form>
     </div>
</div>

<!-- Edit Product Modal -->
<div id="editProductModal" class="modal">
     <div class="modal-content" style="max-width: 800px;">
          <span class="close">&times;</span>
          <h2><?= __("Edit Product") ?></h2>
          <form method="POST" enctype="multipart/form-data" id="editProductForm">
               <input type="hidden" id="edit_product_id" name="product_id">
               <input type="hidden" name="edit_product" value="1">
               <input type="hidden" id="edit_current_image" name="current_image">

               <div class="row">
                    <!-- Left Column: Product Details -->
                    <div class="col-md-12">
                         <div class="form-group">
                              <label><?= __("Product Name") ?> <span class="text-danger">*</span></label>
                              <input type="text" class="form-control" name="name" id="p_name" placeholder="<?= __("Product Name") ?>" readonly required>
                         </div>
                         <div class="form-check form-switch mb-3">
                              <input class="form-check-input" type="checkbox" name="nameByCode" value="1" role="switch" id="switchNameByCategoryEdit" checked>
                              <label class="form-check-label" for="switchNameByCategoryEdit"><?= __("Use product code for name.") ?></label>
                         </div>

                         <div class="form-group">
                              <label><?= __("Description") ?></label>
                              <textarea name="description" class="form-control" id="p_description" placeholder="<?= __("Description") ?>" rows="3"></textarea>
                         </div>
                         <div class="form-group">
                              <label><?= __("Category") ?> <span class="text-danger">*</span></label>
                              <select name="category" id="p_category" class="form-select" disabled>
                                   <option value="" disabled><?= __("Select Category") ?></option>
                                   <option value="បន្តោង">បន្តោង [A-00X]</option>
                                   <option value="ក្រវិល">ក្រវិល [B-00X]</option>
                                   <option value="ខ្សែដៃ">ខ្សែដៃ [C-00X]</option>
                                   <option value="ចិញ្ចៀន">ចិញ្ចៀន [D-00X]</option>
                                   <option value="ខ្សែក">ខ្សែក [E-00X]</option>
                                   <option value="ផ្សេងៗ">ផ្សេងៗ [Z-00X]</option>
                              </select>
                         </div>
                    </div>

                    <!-- Right Column: Stock & Price -->
                    <div class="col-md-12">
                         <div class="form-group">
                              <label><?= __("Sale Price") ?> ($) <span class="text-danger">*</span></label>
                              <input type="number" class="form-control" id="sale_price" min="0.01" name="price" placeholder="<?= __("Sale Price") ?>" step="0.01" required>
                         </div>
                         <div class="form-group">
                              <label class="text-danger"><?= __("Add Stock In") ?> <span class="text-danger"></span></label>
                              <input type="number" class="form-control" id="current_stock_value" name="stock" min="0" placeholder="<?= __("Add Stock In") ?>">
                              <small class="text-muted"><?= __("Current stock") ?>: <span id="current_stock_display">0</span></small>
                         </div>
                         <div class="form-group">
                              <label><?= __("Minimum Stock Level") ?> <span class="text-danger">*</span></label>
                              <input type="number" class="form-control" id="p_min_stock" name="min_stock" min="1" required placeholder="<?= __("Minimum Stock Level") ?>">
                         </div>
                    </div>
               </div>

               <!-- Product Image Upload Section -->
               <div class="form-group mt-4">
                    <label><?= __("Product Image") ?></label>

                    <!-- Current Image Preview -->
                    <div id="editCurrentImagePreview" class="text-center mb-3">
                         <div style="width: 150px; height: 150px; border-radius: 8px; overflow: hidden; border: 3px solid #007bff; margin: 0 auto 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                              <img id="preview_p_img" style="width: 100%; height: 100%; object-fit: cover;">
                         </div>
                         <button type="button" id="editChangeImageBtn" class="btn btn-outline-primary btn-sm">
                              <i class="fas fa-edit"></i> <?= __("Change Image") ?>
                         </button>
                    </div>

                    <!-- Drag & Drop Area (Initially Hidden) -->
                    <div id="editProductDropArea" class="drag-drop-area" style="border: 2px dashed #ced4da; border-radius: 10px; padding: 30px 20px; text-align: center; margin-bottom: 15px; cursor: pointer; background: #f8f9fa; transition: all 0.3s; display: none;">
                         <div style="font-size: 48px; margin-bottom: 10px;">📷</div>
                         <h4 style="margin: 0 0 10px; color: #495057;"><?= __("Drag & Drop new product photo here") ?></h4>
                         <p style="color: #6c757d; margin: 0 0 20px;"><?= __("or click to browse files") ?></p>
                         <button type="button" id="editProductBrowseBtn" class="btn btn-outline-primary">
                              📁 <?= __("Browse Files") ?>
                         </button>
                         <input type="file" class="form-control d-none" id="editProductImageInput" accept="image/*">
                         <button type="button" id="editCancelUploadBtn" class="btn btn-outline-secondary btn-sm mt-2">
                              <?= __("Cancel") ?>
                         </button>
                    </div>

                    <!-- Selected File Info -->
                    <div id="editProductFileInfo" class="alert alert-info" style="display: flex; align-items: center; justify-content: space-between; display: none;">
                         <div style="display: flex; align-items: center; gap: 10px;">
                              <span id="editProductFileIcon" style="font-size: 20px;">📷</span>
                              <div>
                                   <div id="editProductFileName" style="font-weight: bold;"></div>
                                   <div id="editProductFileSize" style="font-size: 12px;"></div>
                              </div>
                         </div>
                         <button type="button" id="editProductChangeFileBtn" class="btn btn-sm btn-outline-secondary"><?= __("Change") ?></button>
                    </div>

                    <!-- Hidden field for cropped image -->
                    <input type="hidden" name="cropped_image_data" id="editProductCroppedImageData">

                    <!-- Image Editor Section -->
                    <div id="editProductEditorSection" style="display: none;">
                         <h5><?= __("Edit Product Image") ?></h5>
                         <div class="row">
                              <!-- Left: Image Editor -->
                              <div class="col-md-8">
                                   <div class="image-editor-container" style="background: #f8f9fa; border-radius: 8px; padding: 15px; margin-bottom: 15px;">
                                        <div id="editProductImageContainer" style="width: 100%; height: 300px; overflow: hidden; position: relative; background: #e9ecef; border-radius: 6px;">
                                             <img id="editProductImageToCrop" style="max-width: 100%; max-height: 100%; display: block; margin: 0 auto;">
                                        </div>

                                        <!-- Zoom Controls -->
                                        <div class="zoom-controls mt-3" style="text-align: center;">
                                             <div class="d-flex align-items-center justify-content-center gap-2">
                                                  <button type="button" id="editProductZoomOut" class="btn btn-sm btn-outline-secondary">-</button>
                                                  <input type="range" id="editProductZoomSlider" min="0.1" max="3" step="0.1" value="1" style="width: 60%;">
                                                  <button type="button" id="editProductZoomIn" class="btn btn-sm btn-outline-secondary">+</button>
                                                  <span id="editProductZoomValue" class="badge bg-secondary ms-2">100%</span>
                                             </div>
                                        </div>
                                   </div>
                              </div>

                              <!-- Right: Adjustments & Preview -->
                              <div class="col-md-4">
                                   <!-- Adjustment Controls -->
                                   <div class="adjustment-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                        <h6 class="mb-3">🛠️ <?= __("Adjustments") ?></h6>
                                        <div class="mb-3">
                                             <label class="form-label small d-flex justify-content-between">
                                                  <span>🔄 <?= __("Rotation") ?></span>
                                                  <span id="editProductRotationValue">0°</span>
                                             </label>
                                             <div class="d-flex gap-2">
                                                  <button type="button" id="editProductRotateLeft" class="btn btn-sm btn-outline-secondary flex-fill">↺</button>
                                                  <input type="range" id="editProductRotationSlider" min="-180" max="180" value="0" class="form-range flex-fill">
                                                  <button type="button" id="editProductRotateRight" class="btn btn-sm btn-outline-secondary flex-fill">↻</button>
                                             </div>
                                        </div>
                                   </div>

                                   <!-- Compression Settings -->
                                   <div class="compression-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                        <h6 class="mb-3">📦 <?= __("Compression") ?></h6>
                                        <div class="mb-3">
                                             <label class="form-label small d-flex justify-content-between">
                                                  <span><?= __("Quality") ?></span>
                                                  <span id="editProductQualityValue">85%</span>
                                             </label>
                                             <input type="range" id="editProductQualitySlider" min="10" max="100" value="85" class="form-range">
                                        </div>
                                        <div class="small text-muted">
                                             <i class="fas fa-weight-hanging"></i> <?= __("Estimated") ?>: <span id="editProductEstimatedSize">-</span>
                                        </div>
                                   </div>

                                   <!-- Preview -->
                                   <div class="preview-panel text-center" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                                        <div style="width: 100px; height: 100px; border-radius: 8px; overflow: hidden; border: 3px solid #007bff; margin: 0 auto 10px; background: #f8f9fa;">
                                             <img id="editProductCropPreview" style="width: 100%; height: 100%; object-fit: cover;">
                                        </div>
                                        <p class="small text-muted mb-0"><?= __("Preview") ?></p>
                                   </div>
                              </div>
                         </div>

                         <!-- Action Buttons -->
                         <div class="d-flex justify-content-between mt-3 pt-3 border-top">
                              <button type="button" id="editProductResetBtn" class="btn btn-outline-secondary">
                                   <i class="fas fa-redo"></i> <?= __("Reset All") ?>
                              </button>
                              <div class="d-flex gap-2">
                                   <button type="button" id="editProductCancelCropBtn" class="btn btn-secondary">
                                        <?= __("Cancel") ?>
                                   </button>
                                   <button type="button" id="editProductApplyCropBtn" class="btn btn-primary">
                                        <i class="fas fa-check"></i> <?= __("Apply Crop") ?>
                                   </button>
                              </div>
                         </div>
                    </div>

                    <!-- New Image Preview -->
                    <div id="editProductNewPreview" class="text-center mt-3" style="display: none;">
                         <h6><?= __("New Product Image") ?></h6>
                         <div style="width: 150px; height: 150px; border-radius: 8px; overflow: hidden; border: 3px solid #28a745; margin: 0 auto 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                              <img id="editProductNewImage" style="width: 100%; height: 100%; object-fit: cover;">
                         </div>
                         <button type="button" id="editProductEditAgainBtn" class="btn btn-outline-primary btn-sm">
                              <i class="fas fa-edit"></i> <?= __("Edit Again") ?>
                         </button>
                    </div>
               </div>

               <div class="d-flex justify-content-end gap-2 mt-4">
                    <button type="button" class="btn btn-secondary" onclick="closeEditModal()"><?= __("Cancel") ?></button>
                    <button type="submit" class="btn btn-success"><?= __("Update Product") ?></button>
               </div>
          </form>
     </div>
</div>

<script>
     function shortByStock(type) {
          // Check if DataTable exists and destroy it properly
          if ($.fn.DataTable.isDataTable('#productsTable')) {
               $('#productsTable').DataTable().destroy();
          }

          // Show loading in tbody only
          const tbody = document.getElementById("productsTableBody");
          if (tbody) {
               tbody.innerHTML = `
            <tr>
                <td colspan="9" class="text-center p-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2">Loading products...</p>
                </td>
            </tr>`;
          }

          var xhr = new XMLHttpRequest();
          xhr.open("POST", "sort-by-stock.php", true);
          xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

          xhr.onreadystatechange = function() {
               if (this.readyState === XMLHttpRequest.DONE) {
                    if (this.status === 200) {
                         // Update only tbody content
                         if (tbody) {
                              tbody.innerHTML = this.responseText;

                              // Check if we have actual data (not just error/empty message)
                              if (tbody.querySelector('tr[data-stock]')) {
                                   // Reinitialize DataTable only if we have data rows
                                   setTimeout(() => {
                                        $('#productsTable').DataTable({
                                             "pageLength": 25,
                                             "lengthMenu": [
                                                  [10, 25, 50, 100, -1],
                                                  [10, 25, 50, 100, "All"]
                                             ],
                                             "order": [
                                                  [0, 'asc']
                                             ],
                                             "language": {
                                                  "search": "Search:",
                                                  "lengthMenu": "Show _MENU_ entries",
                                                  "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                                                  "infoEmpty": "No products found",
                                                  "zeroRecords": "No matching products found"
                                             },
                                             "drawCallback": function(settings) {
                                                  // Reattach click events after DataTable redraw
                                                  reattachEventHandlers();
                                             }
                                        });
                                   }, 100);
                              }
                         }

                         // Update active button styling
                         document.querySelectorAll('.stock-filter-btn').forEach(btn => {
                              btn.classList.remove('active', 'btn-primary');
                              btn.classList.add('btn-outline-primary');
                         });

                         // Highlight active filter
                         const activeBtn = document.querySelector(`[data-filter="${type}"]`);
                         if (activeBtn) {
                              activeBtn.classList.remove('btn-outline-primary');
                              activeBtn.classList.add('active', 'btn-primary');
                         }
                    } else {
                         if (tbody) {
                              tbody.innerHTML = `
                        <tr>
                            <td colspan="9" class="text-center text-danger p-3">
                                Error loading products. Please try again.
                            </td>
                        </tr>`;
                         }
                    }
               }
          };

          xhr.timeout = 10000;
          xhr.ontimeout = function() {
               if (tbody) {
                    tbody.innerHTML = `
                <tr>
                    <td colspan="9" class="text-center text-warning p-3">
                        Request timed out. Please try again.
                    </td>
                </tr>`;
               }
          };

          xhr.onerror = function() {
               if (tbody) {
                    tbody.innerHTML = `
                <tr>
                    <td colspan="9" class="text-center text-danger p-3">
                        Network error. Please check your connection.
                    </td>
                </tr>`;
               }
          };

          // Send request
          xhr.send("type=" + encodeURIComponent(type));
     }

     // Function to reattach event handlers
     function reattachEventHandlers() {
          // Reattach click events for filter buttons
          document.querySelectorAll('.stock-filter-btn').forEach(btn => {
               btn.onclick = function() {
                    const type = this.getAttribute('data-filter');
                    shortByStock(type);
               };
          });

          // Reattach edit/delete button events
          document.querySelectorAll('.btn-success[onclick*="editProductButton"]').forEach(btn => {
               const match = btn.getAttribute('onclick').match(/editProductButton\((\d+)\)/);
               if (match) {
                    btn.onclick = function() {
                         editProductButton(match[1]);
                    };
               }
          });

          // document.querySelectorAll('.btn-danger[onclick*="deleteProduct"]').forEach(btn => {
          //      const match = btn.getAttribute('onclick').match(/deleteProduct\((\d+)\)/);
          //      if (match) {
          //           btn.onclick = function() {
          //                deleteProduct(match[1]);
          //           };
          //      }
          // });

     }
</script>

<script>
     // function deleteProduct(productId) {
     //      if (confirm('Are you sure you want to delete this product?')) {
     //           var currentFile = "<?= $current_file ?>";
     //           const formData = new FormData();
     //           formData.append('delete_product', '1');
     //           formData.append('product_id', productId);

     //           // Send AJAX request
     //           fetch(currentFile, {
     //                     method: 'POST',
     //                     body: formData
     //                })
     //                .then(response => {
     //                     if (response.ok) {
     //                          // Reload page on success
     //                          location.reload();
     //                     } else {
     //                          alert('Error deleting product');
     //                     }
     //                })
     //                .catch(error => {
     //                     console.error('Error:', error);
     //                     alert('Error deleting product');
     //                });
     //      }
     // }

     
     // Delete Customer
     function deleteProduct(productId) {
          if (confirm('Are you sure you want to delete this product?')) {
               // Create a form to submit the deletion
               const form = document.createElement('form');
               form.method = 'POST';
               form.style.display = 'none';

               const input = document.createElement('input');
               input.type = 'hidden';
               input.name = 'delete_product_id';
               input.value = productId;
               form.appendChild(input);

               document.body.appendChild(form);
               form.submit();
          }
     }
</script>
<script>
     document.addEventListener('DOMContentLoaded', function() {
          const nameSwitch = document.getElementById('switchNameByCategory');
          const nameInput = document.getElementById('productNameInput');

          nameSwitch.addEventListener('change', function() {
               if (this.checked) {
                    // When checked (ON) - use product code for name
                    nameInput.readOnly = true;
                    nameInput.required = false;
                    nameInput.classList.add('bg-light');
               } else {
                    // When unchecked (OFF) - allow manual input
                    nameInput.readOnly = false;
                    nameInput.required = true;
                    nameInput.classList.remove('bg-light');
                    nameInput.focus(); // Optional: focus on the input when enabled
               }
          });

          // Initialize state on page load
          if (nameSwitch.checked) {
               nameInput.readOnly = true;
               nameInput.required = false;
               nameInput.classList.add('bg-light');
          }
     });

     document.addEventListener('DOMContentLoaded', function() {
          const nameSwitch = document.getElementById('switchNameByCategoryEdit');
          const nameInput = document.getElementById('p_name');

          nameSwitch.addEventListener('change', function() {
               if (this.checked) {
                    // When checked (ON) - use product code for name
                    nameInput.readOnly = true;
                    nameInput.required = false;
                    nameInput.classList.add('bg-light');
               } else {
                    // When unchecked (OFF) - allow manual input
                    nameInput.readOnly = false;
                    nameInput.required = true;
                    nameInput.classList.remove('bg-light');
                    nameInput.focus(); // Optional: focus on the input when enabled
               }
          });

          // Initialize state on page load
          if (nameSwitch.checked) {
               nameInput.readOnly = true;
               nameInput.required = false;
               nameInput.classList.add('bg-light');
          }
     });
</script>