<?php
// Handle refresh POS data
if (isset($_GET['refresh_pos'])) {
    // This will force a fresh load of POS data
    $refresh_pos = true;
}

// Active cashiers and shifts - Get only the latest active shift for each cashier today
$active_shifts_stmt = $pdo->prepare("
    SELECT s1.*, u.username, u.full_name 
    FROM shifts s1 
    JOIN users u ON s1.cashier_id = u.id 
    WHERE s1.status = 'active' 
    AND DATE(s1.start_time) = CURDATE()
    AND s1.start_time = (
        SELECT MAX(s2.start_time) 
        FROM shifts s2 
        WHERE s2.cashier_id = s1.cashier_id 
        AND DATE(s2.start_time) = CURDATE() 
        AND s2.status = 'active'
    )
    ORDER BY s1.start_time DESC
    LIMIT 1
");
$active_shifts_stmt->execute();
$active_shifts = $active_shifts_stmt->fetchAll();

// Get top items for each active shift
foreach ($active_shifts as &$shift) {
    $top_items_stmt = $pdo->prepare("
        SELECT p.name, SUM(si.quantity) as qty_sold
        FROM sale_items si
        JOIN sales s ON si.sale_id = s.id
        JOIN products p ON si.product_id = p.id
        WHERE s.shift_id = ?
        GROUP BY p.id, p.name
        ORDER BY qty_sold DESC
        LIMIT 6
    ");
    $top_items_stmt->execute([$shift['id']]);
    $shift['top_items'] = $top_items_stmt->fetchAll();
}

// recent sale 

$recent_sales_stmt = $pdo->prepare("
    SELECT s.*, u.username, u.full_name,
           (SELECT COUNT(*) FROM sale_items WHERE sale_id = s.id) as item_count
    FROM sales s 
    JOIN users u ON s.cashier_id = u.id 
    ORDER BY s.created_at DESC 
    LIMIT 10
");
$recent_sales_stmt->execute();
$recent_sales = $recent_sales_stmt->fetchAll();
