<?php

$report_data = [];
if (isset($_GET['generate_report'])) {

    // $from_date = $_GET['from_date'] ?? date('Y-m-01');
    // $to_date = $_GET['to_date'] ?? date('Y-m-d 23:59:59');

    $from_date = date("Y-m-d", strtotime($_GET['from_date'])) ?? date('Y-m-01');
    $to_date = date("Y-m-d", strtotime($_GET['to_date'])) ?? date('Y-m-d 23:59:59');


    $report_type = $_GET['report_type'] ?? 'sales';

    if ($report_type === 'sales') {
        // Sales by Bill
        $sales_by_bill_stmt = $pdo->prepare("
            SELECT s.bill_number, s.created_at, p.name, si.quantity, si.unit_price, si.total_price ,
            customers.fullname as customer_name, customers.phone as customer_phone
            FROM sale_items si
            JOIN sales s ON si.sale_id = s.id
            JOIN products p ON si.product_id = p.id
            JOIN customers ON s.customer_id = customers.id
            WHERE DATE(s.created_at) BETWEEN ? AND ?
            ORDER BY s.created_at DESC, s.bill_number
        ");
        $sales_by_bill_stmt->execute([$from_date, $to_date]);
        $report_data['sales_by_bill'] = $sales_by_bill_stmt->fetchAll();

        // Sales by Product
        $sales_by_product_stmt = $pdo->prepare("
            SELECT p.name, SUM(si.quantity) as total_qty, SUM(si.total_price) as total_sales, AVG(si.unit_price) as avg_price
            FROM sale_items si
            JOIN products p ON si.product_id = p.id
            JOIN sales s ON si.sale_id = s.id
            WHERE DATE(s.created_at) BETWEEN ? AND ?
            GROUP BY p.id, p.name
            ORDER BY total_sales DESC
        ");
        $sales_by_product_stmt->execute([$from_date, $to_date]);
        $report_data['sales_by_product'] = $sales_by_product_stmt->fetchAll();

        // Total Sales Calendar
        $calendar_sales_stmt = $pdo->prepare("
            SELECT DATE(created_at) as sale_date, SUM(total_amount) as daily_total
            FROM sales 
            WHERE DATE(created_at) BETWEEN ? AND ?
            GROUP BY DATE(created_at)
            ORDER BY sale_date
        ");
         

        $calendar_sales_stmt->execute([$from_date, $to_date]);
        $report_data['calendar_sales'] = $calendar_sales_stmt->fetchAll();
       
    } elseif ($report_type === 'stock') {
        // Sale Compare Stock
        $sale_compare_stmt = $pdo->prepare("
            SELECT 
                p.name,
                COALESCE(SUM(CASE WHEN sl.change_type = 'in' THEN sl.change_amount ELSE 0 END), 0) as beginning_stock,
                COALESCE(SUM(CASE WHEN sl.change_type = 'sale' THEN ABS(sl.change_amount) ELSE 0 END), 0) as qty_sold,
                p.stock as ending_stock,
                (COALESCE(SUM(CASE WHEN sl.change_type = 'in' THEN sl.change_amount ELSE 0 END), 0) - 
                 COALESCE(SUM(CASE WHEN sl.change_type = 'sale' THEN ABS(sl.change_amount) ELSE 0 END), 0) - p.stock) as variance
            FROM products p
            JOIN stock_logs sl ON p.id = sl.product_id AND DATE(sl.created_at) BETWEEN ? AND ?
            WHERE p.is_active = 1
            GROUP BY p.id, p.name, p.stock
            ORDER BY p.name
        ");
        $sale_compare_stmt->execute([$from_date, $to_date]);
        $report_data['sale_compare_stock'] = $sale_compare_stmt->fetchAll();
    }
}

?>