<?php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['change_password'])) {
        // ទទួលយកទិន្នន័យពី form
        $c_password = $_POST['c_password'];
        $new_password = $_POST['new_password'];
        $cf_new_password = $_POST['cf_new_password'];

        // ពិនិត្យថាតើមានអ្នកប្រើប្រាស់ដែលបានចូលរួម
        if (!isset($_SESSION['user_id'])) {
            echo "<script>
                alert('សូមចូលគណនីមុនពេលកែប្រែពាក្យសម្ងាត់!');
                window.history.back();
            </script>";
            exit;
        }

        $user_id = $_SESSION['user_id']; // អត្តសញ្ញាណអ្នកប្រើប្រាស់ពី session

        // ពិនិត្យថាតើមានការបញ្ចូលទិន្នន័យទាំងអស់
        if (empty($c_password) || empty($new_password) || empty($cf_new_password)) {
            echo "<script>
                alert('សូមបំពេញទិន្នន័យទាំងអស់!');
                window.history.back();
            </script>";
            exit;
        }

        // ពិនិត្យថាតើពាក្យសម្ងាត់ថ្មីនិងការបញ្ជាក់ត្រូវគ្នាដែរឬទេ
        if ($new_password !== $cf_new_password) {
            echo "<script>
                alert('ពាក្យសម្ងាត់ថ្មីនិងការបញ្ជាក់មិនត្រូវគ្នាទេ!');
                window.history.back();
            </script>";
            exit;
        }

        // ពិនិត្យថាតើពាក្យសម្ងាត់ថ្មីមានភាពរឹងមាំ
        if (strlen($new_password)  < 3) {
            echo "<script>
                alert('ពាក្យសម្ងាត់ថ្មីត្រូវតែមានយ៉ាងហោចណាស់ 4 តួអក្សរ!');
                window.history.back();
            </script>";
            exit;
        }

        try {
            // ទាញយកពាក្យសម្ងាត់ចាស់ពី Database
            $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
            $stmt->execute([$user_id]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$user) {
                echo "<script>
                    alert('មិនមានអ្នកប្រើប្រាស់នេះទេ!');
                    window.history.back();
                </script>";
                exit;
            }

            // ពិនិត្យពាក្យសម្ងាត់ចាស់ (ប្រើ password_verify ប្រសិនបើពាក្យសម្ងាត់ត្រូវបានរក្សាទុកជា hash)
            if (password_verify($c_password, $user['password'])) {
                // ពាក្យសម្ងាត់ចាស់ត្រឹមត្រូវ ផ្លាស់ប្តូរពាក្យសម្ងាត់ថ្មី
                $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);

                // ធ្វើបច្ចុប្បន្នភាពពាក្យសម្ងាត់ថ្មី
                $update_stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
                $update_result = $update_stmt->execute([$hashed_new_password, $user_id]);

                if ($update_result) {
                    echo "<script>
                        alert('បានកែប្រែពាក្យសម្ងាត់ដោយជោគជ័យ!');
                        window.history.back();
                    </script>";
                } else {
                    echo "<script>
                        alert('មានបញ្ហាក្នុងការកែប្រែពាក្យសម្ងាត់!');
                        window.history.back();
                    </script>";
                }
            } else {
                // ពាក្យសម្ងាត់ចាស់មិនត្រឹមត្រូវ
                echo "<script>
                    alert('ពាក្យសម្ងាត់ចាស់មិនត្រឹមត្រូវទេ!');
                    window.history.back();
                </script>";
            }
        } catch (PDOException $e) {
            echo "<script>
                alert('មានកំហុសក្នុងប្រព័ន្ធ៖ " . addslashes($e->getMessage()) . "');
                window.history.back();
            </script>";
        }
        exit;
    }
    // elseif (isset($_POST['change_profile'])) {
    //     $stmt = $pdo->prepare("SELECT profile_picture FROM users WHERE id = ?");
    //     $stmt->execute([$_SESSION['user_id']]);
    //     $old_image = $stmt->fetchColumn();

    //     // បង្កើតឈ្មោះថ្មី និងផ្ទុកឯកសារ
    //     $new_filename = 'profile_' . time() . '.jpg';
    //     move_uploaded_file($_FILES['profile']['tmp_name'], 'assets/images/' . $new_filename);

    //     // លុបរូបភាពចាស់
    //     if ($old_image && file_exists('assets/images/' . $old_image)) {
    //         unlink('assets/images/' . $old_image);
    //     }

    //     // ធ្វើបច្ចុប្បន្នភាព Database
    //     $pdo->prepare("UPDATE users SET profile_picture = ? WHERE id = ?")
    //         ->execute([$new_filename, $_SESSION['user_id']]);

    //     echo "<script>alert('កែប្រែរូបភាពដោយជោគជ័យ!'); window.history.back();</script>";
    //     exit;
    // }

    // Make sure session is started at the VERY TOP of your file
    // session_start();

    // Your database connection code should be here
    // $pdo = new PDO(...);

    if (isset($_POST['change_profile']) && isset($_POST['cropped_image_data'])) {
        error_log("Profile change request received"); // For debugging

        // 1. Validate session and database connection
        if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
            echo "<script>alert('Session expired. Please login again.'); window.location.reload();</script>";
            exit;
        }

        if (!isset($pdo)) {
            echo "<script>alert('Database connection failed.'); window.history.back();</script>";
            exit;
        }

        // 2. Get Base64 data
        $base64_image = $_POST['cropped_image_data'];

        // Debug: Check if data is received
        error_log("Base64 data length: " . strlen($base64_image));

        // Check if base64 string is valid
        if (empty($base64_image) || strpos($base64_image, 'data:image/') !== 0) {
            echo "<script>alert('Invalid image data received!'); window.history.back();</script>";
            exit;
        }

        // Extract image data
        $image_parts = explode(";base64,", $base64_image);
        if (count($image_parts) !== 2) {
            echo "<script>alert('Invalid image format!'); window.history.back();</script>";
            exit;
        }

        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
        $image_base64 = base64_decode($image_parts[1]);

        // Verify base64 decoding was successful
        if ($image_base64 === false) {
            echo "<script>alert('Failed to decode image data!'); window.history.back();</script>";
            exit;
        }

        // 3. Get the old image path for deletion
        try {
            $stmt = $pdo->prepare("SELECT profile_picture FROM users WHERE id = ?");
            $stmt->execute([$_SESSION['user_id']]);
            $old_image = $stmt->fetchColumn();
        } catch (PDOException $e) {
            echo "<script>alert('Database error: " . addslashes($e->getMessage()) . "'); window.history.back();</script>";
            exit;
        }

        // 4. Create new filename and save the file
        $upload_dir = 'assets/images/';

        // Check if directory exists and is writable
        if (!is_dir($upload_dir)) {
            if (!mkdir($upload_dir, 0755, true)) {
                echo "<script>alert('Cannot create upload directory!'); window.history.back();</script>";
                exit;
            }
        }

        if (!is_writable($upload_dir)) {
            echo "<script>alert('Upload directory is not writable!'); window.history.back();</script>";
            exit;
        }

        // Create unique filename (always save as JPG)
        $new_filename = 'profile_' . $_SESSION['user_id'] . '_' . time() . '.jpg';
        $upload_path = $upload_dir . $new_filename;

        // Save the file
        $bytes_written = file_put_contents($upload_path, $image_base64);
        if ($bytes_written === false) {
            echo "<script>alert('Error saving image to server! Check permissions.'); window.history.back();</script>";
            exit;
        }

        // Verify the file was created
        if (!file_exists($upload_path) || filesize($upload_path) === 0) {
            echo "<script>alert('Failed to save image file!'); window.history.back();</script>";
            exit;
        }

        // 5. Delete the old image (if it exists and is not a default image)
        $default_images = ['default.jpg', 'default.png', 'avatar.jpg', 'avatar.png'];
        if (
            $old_image &&
            file_exists($upload_dir . $old_image) &&
            $old_image != $new_filename &&
            !in_array($old_image, $default_images) &&
            strpos($old_image, 'profile_' . $_SESSION['user_id'] . '_') === 0
        ) {
            // Try to delete, but don't fail if we can't
            @unlink($upload_dir . $old_image);
        }

        // 6. Update Database
        try {
            $update_stmt = $pdo->prepare("UPDATE users SET profile_picture = ? WHERE id = ?");
            $result = $update_stmt->execute([$new_filename, $_SESSION['user_id']]);

            if ($result && $update_stmt->rowCount() > 0) {
                // Update session
                $_SESSION['profile_picture'] = $new_filename;

                echo "<script>
                        alert('Update profile successfully!');
                        window.history.back();
                    </script>";
                exit;
            } else {
                // Delete the new file if update failed
                if (file_exists($upload_path)) {
                    unlink($upload_path);
                }
                echo "<script>alert('Failed to update profile in database!'); window.history.back();</script>";
            }
            exit;
        } catch (PDOException $e) {
            // Delete the new file if database update failed
            if (file_exists($upload_path)) {
                unlink($upload_path);
            }
            echo "<script>alert('Database error: " . addslashes($e->getMessage()) . "'); window.history.back();</script>";
        }
        exit;
    }
}
?>

<header class="header">
    <div class="container">
        <div class="logo">
            <?php
            $system_stmt = $pdo->prepare("SELECT * FROM shop_info");
            $system_stmt->execute();
            $system = $system_stmt->fetch(PDO::FETCH_ASSOC); // Changed from fetchAll() to fetch()

            $user_profile = $pdo->prepare("SELECT profile_picture FROM users WHERE id = ?");
            $user_profile->execute([$_SESSION['user_id']]);
            $profile = $user_profile->fetch(PDO::FETCH_ASSOC);
            ?>
            <h1>

                <img src="assets/images/<?= $system['logo'] ?? 'logo.png' ?>" alt="Logo" width="55">

                <!-- <i class="fas fa-gift"></i> -->
                <?php
                echo $system['shop_name'] ?? "Souvenir Shop";
                ?>
            </h1>
        </div>
        <div class="d-flex align-items-center gap-3">
            <!-- <div class="language">
                <form method="GET" id="languageForm">
                    <select name="lang" class="form-select" onchange="document.getElementById('languageForm').submit();">
                        <?php
                        // foreach ($available_languages as $lang_code => $lang_name) {
                        //     $selected = ($current_lang === $lang_code) ? 'selected' : '';
                        ?>
                            <option value="<?= $lang_code; ?>" <?= $selected; ?>><?= $lang_name; ?></option>
                        <?php
                        // }
                        ?>
                    </select>
                </form>

            </div> -->
            <div class="user-menu">
                <div class="profile-dropdown">
                    <div id="profileDropdown" class="language">
                        <!-- <i class="fa fa-globe" aria-hidden="true"></i>  -->
                        <?php 
                        if($current_lang == 'en'){
                            $flag = 'en';
                        } else{
                            $flag = 'kh';
                        } 
                        ?>
                        <img src="assets/images/flages/<?= $flag ?>.png" alt="" width="20">
                        <?= $available_languages[$current_lang]; ?>
                    </div>
                    <!-- <img src="assets/images/<?= $profile['profile_picture'] ?? 'default-profile.png'; ?>" alt="Profile" class="profile-pic" id="profileDropdown"> -->
                    <div class="dropdown-content">
                         <?php
                        foreach ($available_languages as $lang_code => $lang_name) {
                            $selected = ($current_lang === $lang_code) ? 'selected' : '';
                        ?>
                            <a type="button" onclick="window.location.href='?lang=<?= $lang_code; ?>'" class="d-block w-100">
                                <img src="assets/images/flages/<?= $lang_code ?>.png" alt="" width="20">
                                <?= strtoupper($lang_code) ?> : <?= $lang_name ?></a>
                        <?php
                        }
                        ?>
                        <!-- <a href="#" onclick="openPhotoModal()"><i class="fas fa-camera"></i> Change Photo</a>
                        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a> -->
                    </div>
                </div>
            </div>

            <div class="user-menu">
                <div class="profile-dropdown">
                    <img src="assets/images/<?= $profile['profile_picture'] ?? 'default-profile.png'; ?>" alt="Profile" class="profile-pic" id="profileDropdown">
                    <div class="dropdown-content">
                        <a href="#" onclick="showChangePassword()"><i class="fas fa-key"></i> <?= __("Change Password") ?></a>
                        <a href="#" onclick="openPhotoModal()"><i class="fas fa-camera"></i> <?= __("Change Photo") ?></a>
                        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> <?= __("Logout") ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</header>
<!-- Modals -->
<div id="changePasswordModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2><?= __("Change Password") ?></h2>
        <form id="changePasswordForm" method="POST">
            <div class="mb-3">
                <label for="c_password" class="form-label"><?= __("Current Password") ?> <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="c_password" name="c_password" placeholder="<?= __("Current Password") ?>" required>
            </div>
            <div class="mb-3">
                <label for="new_password" class="form-label"><?= __("New Password") ?> <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="new_password" name="new_password" placeholder="<?= __("New Password") ?>" required>
            </div>
            <div class="mb-3">
                <label for="cf_new_password" class="form-label"><?= __("Confirm New Password") ?> <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="cf_new_password" name="cf_new_password" placeholder="<?= __("Confirm New Password") ?>" required>
            </div>
            <button name="change_password" type="submit" class="btn btn-success"><?= __("Update Password") ?></button>
        </form>
    </div>
</div>

<!-- <div id="changePhotoModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Change Profile Photo</h2>
        <form id="changePhotoForm" method="POST" enctype="multipart/form-data">
            <div class="image-preview">
                <img id="photoPreview" width="100" class="my-3">
            </div>
            <div class="mb-3">
                <input type="file" onclick="changeProfile()" name="profile" class="form-control" id="profilePhoto" accept="image/*" required>
            </div>
            <button type="submit" name="change_profile" class="btn btn-success">Update Photo</button>
        </form>
    </div>
</div> -->


<!-- <div id="changePhotoModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Change Profile Photo</h2>
        <form id="changePhotoForm" method="POST" enctype="multipart/form-data">

            <input type="hidden" name="cropped_image_data" id="croppedImageData">

            <div class="mb-3">
                <label for="profilePhoto" class="form-label">Select Image</label>
                <input type="file" name="profile_upload" class="form-control" id="profilePhotoInput" accept="image/*" required>
            </div>

            <div class="image-crop-container" style="max-width: 100%; max-height: 400px; margin-bottom: 15px;">
                <img id="imageToCrop" style="max-width: 100%; display: none;">
            </div>

            <div id="cropControls" style="text-align: center; display: none; margin-bottom: 15px;">
                <button type="button" id="rotateLeft" class="btn btn-secondary">Rotate Left</button>
                <button type="button" id="rotateRight" class="btn btn-secondary">Rotate Right</button>
                <button type="button" id="zoomIn" class="btn btn-secondary">+</button>
                <button type="button" id="zoomOut" class="btn btn-secondary">-</button>
            </div>

            <button type="submit" name="change_profile" id="updatePhotoBtn" class="btn btn-success" disabled>Update Photo</button>
        </form>
    </div>
</div> -->


<!-- Modal -->
<div id="changePhotoModal" class="modal fade" tabindex="-1" aria-labelledby="changePhotoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="changePhotoModalLabel"><?= __("Change Profile Photo") ?></h5>
                <button type="button" class="btn-close btn-sm close" style="font-size: medium;"></button>
            </div>
            <div class="modal-body">
                <!-- Telegram-style Drag & Drop Area -->
                <div id="dropArea" class="drag-drop-area" style="border: 2px dashed #ced4da; border-radius: 10px; padding: 40px 20px; text-align: center; margin-bottom: 20px; cursor: pointer; background: #f8f9fa; transition: all 0.3s;">
                    <div style="font-size: 48px; margin-bottom: 10px;">📷</div>
                    <h4 style="margin: 0 0 10px; color: #495057;"><?= __("Drag & Drop your photo here") ?></h4>
                    <p style="color: #6c757d; margin: 0 0 20px;"><?= __("or click to browse files") ?></p>
                    <div style="display: flex; justify-content: center; gap: 10px;">
                        <button type="button" id="browseBtn" class="btn btn-outline-success">
                            📁 <?= __("Browse Files") ?>
                        </button>
                    </div>
                    <input type="file" name="profile_upload" class="form-control d-none" id="profilePhotoInput" accept="image/*">
                </div>

                <!-- Selected File Info -->
                <div id="fileInfo" class="alert alert-info d-none" style="display: flex; align-items: center; justify-content: space-between;">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        <span id="fileIcon" style="font-size: 20px;">📷</span>
                        <div>
                            <div id="fileName" style="font-weight: bold;"></div>
                            <div id="fileSize" style="font-size: 12px;"></div>
                        </div>
                    </div>
                    <button type="button" id="changeFileBtn" class="btn btn-sm btn-outline-secondary"><?= __("Change") ?></button>
                </div>

                <form id="changePhotoForm" method="POST">
                    <input type="hidden" name="cropped_image_data" id="croppedImageData">

                    <!-- Image Editor Section -->
                    <div id="editorSection" class="d-none">
                        <div class="row">
                            <!-- Left: Image Editor -->
                            <div class="col-md-8">
                                <div class="image-editor-container" style="background: #f8f9fa; border-radius: 8px; padding: 15px; margin-bottom: 15px;">
                                    <div id="imageToCropContainer" style="width: 100%; height: 300px; overflow: hidden; position: relative; background: #e9ecef; border-radius: 6px;">
                                        <img id="imageToCrop" style="max-width: 100%; max-height: 100%; display: block; margin: 0 auto;">
                                    </div>

                                    <!-- Zoom Controls -->
                                    <div class="zoom-controls mt-3" style="text-align: center;">
                                        <div class="d-flex align-items-center justify-content-center gap-2">
                                            <button type="button" id="zoomOut" class="btn btn-sm btn-outline-secondary">-</button>
                                            <input type="range" id="zoomSlider" min="0.1" max="3" step="0.1" value="1" style="width: 60%;">
                                            <button type="button" id="zoomIn" class="btn btn-sm btn-outline-secondary">+</button>
                                            <span id="zoomValue" class="badge bg-secondary ms-2">100%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Right: Adjustments & Preview -->
                            <div class="col-md-4">
                                <!-- Adjustment Controls -->
                                <div class="adjustment-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                    <h6 class="mb-3">🛠️ Adjustments</h6>
                                    <div class="mb-3">
                                        <label class="form-label small d-flex justify-content-between">
                                            <span>🔄 <?= __("Rotation") ?></span>
                                            <span id="rotationValue">0°</span>
                                        </label>
                                        <div class="d-flex gap-2">
                                            <button type="button" id="rotateLeft" class="btn btn-sm btn-outline-secondary flex-fill">↺</button>
                                            <input type="range" id="rotationSlider" min="-180" max="180" value="0" class="form-range flex-fill">
                                            <button type="button" id="rotateRight" class="btn btn-sm btn-outline-secondary flex-fill">↻</button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Compression Settings -->
                                <div class="compression-panel" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 15px;">
                                    <h6 class="mb-3">📦 <?= __("Compression") ?></h6>
                                    <div class="mb-3">
                                        <label class="form-label small d-flex justify-content-between">
                                            <span><?= __("Quality") ?></span>
                                            <span id="qualityValue">85%</span>
                                        </label>
                                        <input type="range" id="qualitySlider" min="10" max="100" value="85" class="form-range">
                                    </div>
                                    <div class="small text-muted">
                                        <i class="fas fa-weight-hanging"></i> <?= __("Estimated") ?>: <span id="estimatedSize">-</span>
                                    </div>
                                </div>

                                <!-- Preview -->
                                <div class="preview-panel text-center" style="background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                                    <div style="width: 100px; height: 100px; border-radius: 50%; overflow: hidden; border: 3px solid #007bff; margin: 0 auto 10px; background: #f8f9fa;">
                                        <img id="cropPreview" style="width: 100%; height: 100%; object-fit: cover;">
                                    </div>
                                    <p class="small text-muted mb-0"><?= __("Preview") ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between mt-3 pt-3 border-top">
                            <button type="button" id="resetBtn" class="btn btn-outline-secondary">
                                <i class="fas fa-redo"></i> <?= __("Reset All") ?>
                            </button>
                            <div class="d-flex gap-2">
                                <button type="button" id="cancelCropBtn" class="btn btn-secondary" data-bs-dismiss="modal">
                                    <?= __("Cancel") ?>
                                </button>
                                <button type="button" id="applyCropBtn" class="btn btn-primary">
                                    <i class="fas fa-check"></i> <?= __("Apply Crop") ?>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Final Submit Section -->
                    <div id="finalSection" class="d-none text-center">
                        <div class="final-preview mb-4">
                            <div style="width: 150px; height: 150px; border-radius: 50%; overflow: hidden; border: 4px solid #28a745; margin: 0 auto 20px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                                <img id="finalPreview" style="width: 100%; height: 100%; object-fit: cover;">
                            </div>
                            <h5><?= __("Your new profile picture") ?></h5>
                            <p class="text-muted"><?= __("Ready to update your profile") ?></p>
                        </div>

                        <div class="d-flex justify-content-center gap-3">
                            <button type="button" id="editAgainBtn" class="btn btn-outline-primary">
                                <i class="fas fa-edit"></i> <?= __("Edit Again") ?>
                            </button>
                            <button type="submit" id="updatePhotoBtn" class="btn btn-success" disabled>
                                <i class="fas fa-save"></i> <?= __("Update Photo") ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" class="d-none" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9999; display: flex; justify-content: center; align-items: center;">
    <div class="text-center text-white">
        <div class="spinner-border mb-3" role="status"></div>
        <p><?= __("Processing your image") ?>...</p>
    </div>
</div>




<script>
    function changeProfile() {
        // ការតភ្ជាប់ event listener ទៅ input file
        document.getElementById('profilePhoto').addEventListener('change', function(event) {
            const file = event.target.files[0];
            const preview = document.getElementById('photoPreview');

            if (file) {
                // ពិនិត្យប្រភេទឯកសារ
                if (!file.type.startsWith('image/')) {
                    alert('សូមជ្រើសរើសឯកសាររូបភាព');
                    this.value = ''; // សម្អាត input
                    return;
                }
                // បង្ហាញរូបភាពជាមុន
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                };
                reader.readAsDataURL(file);
            } else {
                // ប្រសិនបើគ្មានឯកសារ ត្រឡប់ទៅរូបភាពលំនាំដើម
                preview.src = 'assets/images/default_profile.png';
            }
        });
    }
</script>