<?php
$customers_stmt = $pdo->prepare("
    SELECT c.*, u.full_name AS created_by_name
    FROM customers AS c 
    JOIN users AS u ON c.created_by = u.id
    WHERE c.active = 1
    ORDER BY c.created_at DESC
");
$customers_stmt->execute();
$customers = $customers_stmt->fetchAll();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_customer'])) {
     $fullname = trim($_POST['fullname']);
     $phone = trim($_POST['phone']);
     $address = trim($_POST['address']);

     // Insert new customer
     $stmt = $pdo->prepare("INSERT INTO customers (fullname, phone, address, created_by) VALUES (?, ?, ?, ?)");
     $stmt->execute([$fullname, $phone, $address, $_SESSION['user_id']]);

     // Redirect to prevent form resubmission
     // header("Location: " . $_SERVER['PHP_SELF']);
     echo "<script>
          alert('Customer added successfully.');
          window.history.back();
     </script>";
     exit();
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_customer'])) {
     $customer_id = $_POST['customer_id'];
     $fullname = trim($_POST['fullname']);
     $phone = trim($_POST['phone']);
     $address = trim($_POST['address']);
     // Update customer
     $stmt = $pdo->prepare("UPDATE customers SET fullname = ?, phone = ?, address = ? WHERE id = ?");
     $stmt->execute([$fullname, $phone, $address, $customer_id]);
     echo "<script>
          alert('Customer updated successfully.');
          window.history.back();
     </script>";
     exit();
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_customer_id'])) {
     $customer_id = $_POST['delete_customer_id'];
     // Delete customer
     $stmt = $pdo->prepare("UPDATE customers SET active = 0 WHERE id = ?");
     $stmt->execute([$customer_id]);
     echo "<script>
          alert('Customer deleted successfully.');
          window.history.back();
     </script>";
     exit();
}
?>
<div id="customerManagement" class="tab-content <?php echo $current_tab === 'customerManagement' ? 'active' : ''; ?>">
     <h3><?= __("Customer") ?></h3>
     <div class="row my-3">
          <div class="col-md-6">
               <div class="btn-group" role="group" aria-label="Basic example">
                    <button type="button" onclick="printTable('customerTable', 'Customer')" class="btn btn-warning"><i class="fa fa-print" aria-hidden="true"></i> <?= __("Print") ?></button>
                    <button type="button" onclick="exportTableToCSV('customerTable', 'Customer')" class="btn btn-success"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?= __("Export as CSV") ?></button>
               </div>
          </div>
          <div class="col-md-6">
               <div class="ms-auto w-fit" style="width: fit-content;">
                    <button class="btn btn-primary" onclick="showAddCustomerModal()">
                         <i class="fas fa-user-plus"></i> <?= __("Add Customer") ?>
                    </button>
               </div>
          </div>
     </div>



     <div class="user-management">

          <div class="respone-table">
               <div class="bg-table p-3">
                    <table class="table table-striped table-hover" id="customerTable">
                         <thead>
                              <tr>
                                   <th>#</th>
                                   <th><?= __("Name") ?></th>
                                   <th><?= __("Phone") ?></th>
                                   <th><?= __("Address") ?></th>
                                   <th><?= __("Created by") ?></th>
                                   <th><?= __("Created at") ?></th>
                                   <th><?= __("Actions") ?></th>
                              </tr>
                         </thead>
                         <tbody>
                              <?php foreach ($customers as $key => $c): ?>
                                   <tr>
                                        <td><?= $key + 1 ?></td>
                                        <td><?php echo htmlspecialchars($c['fullname']); ?></td>
                                        <td><?php echo htmlspecialchars($c['phone']); ?></td>
                                        <td><?php echo htmlspecialchars($c['address']); ?></td>
                                        <td><?php echo htmlspecialchars($c['created_by_name']); ?></td>
                                        <td><?= date("d M Y h:i:s A", strtotime($c['created_at'])) ?></td>
                                        <td>
                                             <a type="button" class="me-1 btn btn-sm btn-success" title="Edit" onclick="editCustomerButton(<?php echo $c['id'];
                                                                                                                                            ?>)">
                                                  <i class="fa fa-edit" aria-hidden="true"></i>
                                             </a>
                                             <a type="button" class="btn btn-sm btn-danger" title="Delete" onclick="deleteCustomer(<?php echo $c['id']; ?>)">
                                                  <i class="fa fa-trash" aria-hidden="true"></i>
                                             </a>
                                        </td>
                                   </tr>
                              <?php endforeach; ?>
                         </tbody>
                    </table>
               </div>
          </div>
     </div>
</div>

<!-- Add Customer Modal -->
<div id="addCustomerModal" class="modal">
     <div class="modal-content">
          <span class="close">&times;</span>
          <h2><?= __("Add Customer") ?></h2>
          <form method="POST">
               <div class="form-group">
                    <label><?= __("Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" placeholder="<?= __("Name") ?>" name="fullname" required>
               </div>
               <div class="form-group">
                    <label><?= __("Phone") ?> <span class="text-danger">*</span></label>
                    <input type="tel" class="form-control" placeholder="<?= __("Phone") ?>" name="phone" required>
               </div>
               <div class="form-group">
                    <label><?= __("Address") ?></label>
                    <textarea type="tel" class="form-control" placeholder="<?= __("Address") ?>" name="address"></textarea>
               </div>


               <button type="submit" class="btn btn-primary" name="add_customer"><?= __("Save") ?></button>
          </form>
     </div>
</div>

<!-- Edit Customer Modal -->
<div id="updateCustomerModal" class="modal">
     <div class="modal-content">
          <span class="close" onclick="closeUpdateModal()">&times;</span>
          <h2><?= __("Edit Customer") ?></h2>
          <form id="updateCustomerForm" method="POST">
               <input type="hidden" id="edit_customer_id" name="customer_id" required>

               <div class="form-group">
                    <label><?= __("Name") ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="edit_fullname"
                         placeholder="<?= __("Name") ?>" name="fullname" required>
               </div>

               <div class="form-group">
                    <label><?= __("Phone") ?> <span class="text-danger">*</span></label>
                    <input type="tel" class="form-control" id="edit_phone"
                         placeholder="<?= __("Phone") ?>" name="phone" required>
               </div>
               <div class="form-group">
                    <label><?= __("Address") ?></label>
                    <textarea type="tel" class="form-control" id="edit_address" placeholder="<?= __("Address") ?>" name="address"></textarea>
               </div>
               <button type="submit" class="btn btn-success" name="edit_customer"><?= __("Update Customer") ?></button>
          </form>
     </div>
</div>

<script>
     // Get the modal
     const modal = document.getElementById('addCustomerModal');

     // Show modal function
     function showAddCustomerModal() {
          modal.style.display = 'block';
     }

     // Close modal function
     function closeModal() {
          modal.style.display = 'none';
     }

     // Close modal when clicking outside
     window.onclick = function(event) {
          if (event.target == modal) {
               modal.style.display = 'none';
          }
     }

     // Close modal with Escape key
     document.addEventListener('keydown', function(event) {
          if (event.key === 'Escape') {
               closeModal();
          }
     });

     // Clear form on page load (for demo purposes)
     window.onload = function() {
          document.querySelector('form').reset();
     };


     // Edit Customer
     function editCustomerButton(customerId) {
          const modal = document.getElementById('updateCustomerModal');
          modal.style.display = 'block';

          // Fetch customer data using fetch API
          fetch('ajax.php', {
                    method: 'POST',
                    headers: {
                         // Note: 'application/x-www-form-urlencoded' is correct for URLSearchParams body
                         'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                         // Pass a specific action/request type to ajax.php for clarity (optional but recommended)
                         action: 'fetch_customer',
                         customer_id: customerId
                    })
               })
               .then(response => {
                    // 1. Check if the response is OK (HTTP 200-299 status)
                    if (!response.ok) {
                         throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    // 2. Parse the JSON body
                    return response.json();
               })
               .then(result => {
                    // The PHP script returns an object like { success: true, data: { id: 1, fullname: '...' } }
                    // 3. Check the 'success' property in the JSON result
                    if (result && result.success && result.data) {
                         const customer = result.data; // Extract the actual customer object

                         // 4. Populate the form fields
                         document.getElementById('edit_customer_id').value = customer.id;
                         document.getElementById('edit_fullname').value = customer.fullname;
                         document.getElementById('edit_phone').value = customer.phone;
                         document.getElementById('edit_address').value = customer.address;
                    } else {
                         // Handle case where PHP query failed (e.g., customer not found)
                         const errorMessage = result.message || 'Customer data could not be retrieved.';
                         alert('Error: ' + errorMessage);
                         closeUpdateModal();
                    }
               })
               .catch(error => {
                    // Handle network errors or errors thrown in .then() blocks
                    console.error('Fetch Error:', error);
                    alert('An error occurred while fetching customer data. Check console for details.');
                    // closeUpdateModal() is good to close the modal on error
                    // Make sure closeUpdateModal is defined in your script!
                    if (typeof closeUpdateModal === 'function') {
                         closeUpdateModal();
                    }
               });
     }

     // Helper function to close the modal (make sure this exists)
     function closeUpdateModal() {
          const modal = document.getElementById('updateCustomerModal');
          modal.style.display = 'none';
     }

     // Delete Customer
     function deleteCustomer(customerId) {
          if (confirm('Are you sure you want to delete this customer?')) {
               // Create a form to submit the deletion
               const form = document.createElement('form');
               form.method = 'POST';
               form.style.display = 'none';

               const input = document.createElement('input');
               input.type = 'hidden';
               input.name = 'delete_customer_id';
               input.value = customerId;
               form.appendChild(input);

               document.body.appendChild(form);
               form.submit();
          }
     }
</script>