<?php
// fetch_products.php
session_start();
require_once 'config/database.php'; // Your database configuration

$itemsPerPage = 8;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $itemsPerPage;

// Query to get total count for pagination
$count_stmt = $pdo->prepare("SELECT COUNT(*) as total FROM products WHERE is_active = 1");
$count_stmt->execute();
$totalResult = $count_stmt->fetch();
$totalItems = $totalResult['total'];
$totalPages = ceil($totalItems / $itemsPerPage);

// Query to get paginated products
$products_stmt = $pdo->prepare("SELECT * FROM products WHERE is_active = 1 ORDER BY name LIMIT :limit OFFSET :offset");
$products_stmt->bindValue(':limit', $itemsPerPage, PDO::PARAM_INT);
$products_stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$products_stmt->execute();
$products = $products_stmt->fetchAll();

// Generate HTML for products
$productsHtml = '';
foreach ($products as $product) {
    $p_code = $product['p_code'] ?? 'N/A';
    $productsHtml .= '
    <div class="product-card ' . ($product['stock'] <= 0 ? 'disabled' : '') . '"
        onclick="' . ($product['stock'] > 0 ? 'addToCart(' . $product['id'] . ')' : '') . '">
        <img src="assets/images/' . ($product['image'] ?: 'default-product.jpg') . '"
            alt="' . htmlspecialchars($product['name']) . '">
        <p class="m-0 p-0 text-muted">' . $p_code . '</p>
        <h4>' . htmlspecialchars($product['name']) . '</h4>
        <div class="price">$' . number_format($product['price'], 2) . '</div>
        <div class="stock ' . ($product['stock'] <= 0 ? 'out-of-stock' : ($product['stock'] <= 10 ? 'low-stock' : '')) . '">
            Stock: ' . $product['stock'] . '
        </div>
    </div>';
}

// Generate HTML for pagination
$paginationHtml = '';
if ($totalPages > 1) {
    $paginationHtml .= '
    <nav aria-label="Page navigation example" class="mt-3">
        <ul class="pagination">';
    
    if ($page > 1) {
        $paginationHtml .= '
            <li class="page-item">
                <a class="page-link" onclick="pagination(' . ($page - 1) . ')">
                    <i class="fa fa-angle-double-left" aria-hidden="true"></i> Previous
                </a>
            </li>';
    }
    
    if ($page < $totalPages) {
        $paginationHtml .= '
            <li class="page-item">
                <a class="page-link" onclick="pagination(' . ($page + 1) . ')">
                    Next <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                </a>
            </li>';
    }
    
    $paginationHtml .= '
        </ul>
    </nav>';
}

// Prepare response
$response = [
    'success' => true,
    'products' => $productsHtml,
    'pagination' => $paginationHtml,
    'pagination_data' => [
        'current_page' => $page,
        'total_pages' => $totalPages,
        'total_items' => $totalItems
    ]
];

header('Content-Type: application/json');
echo json_encode($response);
?>