<?php
// Start session only if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check user role
function checkRole($allowedRoles) {
    if (!isLoggedIn() || !in_array($_SESSION['user_role'], $allowedRoles)) {
        header('Location: ../index.php');
        exit();
    }
}

// Redirect based on role
function redirectByRole() {
    if (isLoggedIn()) {
        switch ($_SESSION['user_role']) {
            case 'cashier':
                header('Location: pos.php');
                break;
            case 'stock':
                header('Location: stock.php');
                break;
            case 'owner':
                header('Location: owner.php');
                break;
            case 'admin':
                header('Location: admin.php');
                break;
            default:
                header('Location: dashboard.php');
        }
        exit();
    }
}
// Remove the closing tag to prevent whitespace issues