<?php
// session_start();
// require_once 'config/database.php';
require_once 'log_functions.php';

// Function to auto-close shift at midnight and logout
function autoCloseShiftAtMidnight($pdo, $cashier_id)
{
     // Get current open shift for the cashier
     $stmt = $pdo->prepare("SELECT * FROM shifts WHERE cashier_id = ? AND end_time IS NULL ORDER BY start_time DESC LIMIT 1");
     $stmt->execute([$cashier_id]);
     $current_shift = $stmt->fetch();

     if (!$current_shift) {
          return false; // No open shift
     }

     $now = new DateTime();
     $shift_start = new DateTime($current_shift['start_time']);

     // Check if shift started on a different day (yesterday or earlier)
     if ($shift_start->format('Y-m-d') < $now->format('Y-m-d')) {
          // Close the shift at 23:59:59 of the shift start day
          $close_time = $shift_start->format('Y-m-d') . ' 23:59:59';

          $pdo->beginTransaction();
          try {
               // Close the old shift
               $close_stmt = $pdo->prepare("UPDATE shifts SET end_time = ?, status = 'auto-closed' WHERE id = ?");
               $close_stmt->execute([$close_time, $current_shift['id']]);

               //                    $stmt = $pdo->prepare("UPDATE shifts SET end_time = NOW(), status = 'closed' WHERE id = ?");
               //     $stmt->execute([$current_shift['id']]);

               // Create new shift
               $stmt = $pdo->prepare("INSERT INTO shifts (cashier_id) VALUES (?)");
               $stmt->execute([$_SESSION['user_id']]);
               // DO NOT create new shift for auto-closes
               // User must login again for new shift
               $pdo->commit();

               // Log the auto-close
               // error_log("Auto-closed shift ID: {$current_shift['id']} for cashier ID: $cashier_id at $close_time");

               // Auto-close detected - destroy session and redirect
               // autoLogoutAndRedirect();
          } catch (Exception $e) {
               $pdo->rollBack();
               // error_log("Error auto-closing shift: " . $e->getMessage());
               return false;
          }
     }

     return false; // Shift is from today, no need to close
}

// Function for manual close (keeps existing behavior)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['close_shift'])) {
     $stmt = $pdo->prepare("UPDATE shifts SET end_time = NOW(), status = 'closed' WHERE id = ?");
     $stmt->execute([$current_shift['id']]);

     // Create new shift for manual close (existing behavior)
     $stmt = $pdo->prepare("INSERT INTO shifts (cashier_id) VALUES (?)");
     $stmt->execute([$_SESSION['user_id']]);

     echo "<script>
               alert('Shift closed successfully! New shift started.');
               window.location.reload();
          </script>";
     exit;
}

// Function to auto-logout and redirect
function autoLogoutAndRedirect()
{
     // session_start();
     session_destroy();
     // Redirect to login page
     // header('Location: index.php');
     // exit();
}

// Use this function at the beginning of your page
autoCloseShiftAtMidnight($pdo, $_SESSION['user_id']);

// Get current shift after auto-close check
$stmt = $pdo->prepare("SELECT * FROM shifts WHERE cashier_id = ? AND end_time IS NULL ORDER BY start_time DESC LIMIT 1");
$stmt->execute([$_SESSION['user_id']]);
$current_shift = $stmt->fetch();

// If no open shift after auto-close, user should be redirected already
// This is just a safety check
/*
if (!$current_shift && !isset($_SESSION['auto_redirecting'])) {
     $_SESSION['auto_redirecting'] = true;
     autoLogoutAndRedirect();
}
     */

$logger->logShift('closed', $current_shift['id'], $_SESSION['user_id'], [
     'end_time' => date('Y-m-d H:i:s'),
     'total_sales' => $current_shift['total_sales'],
     'total_items' => $current_shift['total_items']
]);
