function getBaseUrl() {
  // Get the current script path
  var scripts = document.getElementsByTagName("script");
  var currentScript = scripts[scripts.length - 1];
  var scriptPath = currentScript.src;

  // Extract directory path
  var basePath = scriptPath.substring(0, scriptPath.lastIndexOf("/"));

  // Go up to root from assets/js
  return basePath.substring(0, basePath.lastIndexOf("/assets")) + "/";
}

// Profile dropdown functionality
function toggleDropdown() {
  const dropdown = document.getElementById("profileDropdown");
  dropdown.classList.toggle("active");
}

// Close dropdown when clicking elsewhere
document.addEventListener("click", function (event) {
  const dropdown = document.getElementById("profileDropdown");
  if (dropdown && !dropdown.contains(event.target)) {
    dropdown.classList.remove("active");
  }
});

// Modal functionality
function showModal(modalId) {
  document.getElementById(modalId).style.display = "block";
}

function hideModal(modalId) {
  document.getElementById(modalId).style.display = "none";
}

// Close modals when clicking X
document.querySelectorAll(".close").forEach((closeBtn) => {
  closeBtn.addEventListener("click", function () {
    this.closest(".modal").style.display = "none";
  });
});

// Close modals when clicking outside
window.addEventListener("click", function (event) {
  document.querySelectorAll(".modal").forEach((modal) => {
    if (event.target === modal) {
      modal.style.display = "none";
    }
  });
});

// Change password modal
function showChangePassword() {
  showModal("changePasswordModal");
  document.getElementById("profileDropdown").classList.remove("active");
}

// Change photo modal
function showChangePhoto() {
  showModal("changePhotoModal");
  document.getElementById("profileDropdown").classList.remove("active");
}

// Image preview for profile photo
function previewImage(input) {
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = function (e) {
      document.getElementById("photoPreview").src = e.target.result;
    };
    reader.readAsDataURL(input.files[0]);
  }
}

// Change password function
function changePassword() {
  const currentPassword = document.getElementById("currentPassword").value;
  const newPassword = document.getElementById("newPassword").value;
  const confirmPassword = document.getElementById("confirmPassword").value;

  if (newPassword !== confirmPassword) {
    alert("New passwords do not match!");
    return false;
  }

  // Here you would typically make an AJAX call to update the password
  alert(
    "Password change functionality would be implemented here with backend API"
  );
  hideModal("changePasswordModal");
  return false;
}

// Change profile photo function
function changeProfilePhoto() {
  const fileInput = document.getElementById("profilePhoto");
  if (!fileInput.files[0]) {
    alert("Please select a photo");
    return false;
  }

  // Here you would typically make an AJAX call to upload the photo
  alert(
    "Profile photo change functionality would be implemented here with backend API"
  );
  hideModal("changePhotoModal");
  return false;
}

// Tab functionality
function openTab(evt, tabName) {
  const tabcontent = document.getElementsByClassName("tab-content");
  for (let i = 0; i < tabcontent.length; i++) {
    tabcontent[i].classList.remove("active");
  }

  const tablinks = document.getElementsByClassName("tab");
  for (let i = 0; i < tablinks.length; i++) {
    tablinks[i].classList.remove("active");
  }

  document.getElementById(tabName).classList.add("active");
  if (evt && evt.currentTarget) {
    evt.currentTarget.classList.add("active");
  } else {
    // If no event (programmatic call), find and activate the corresponding tab
    const tabs = document.querySelectorAll(".tab");
    tabs.forEach((tab) => {
      if (
        tab.textContent.includes(
          tabName
            .replace(/([A-Z])/g, " $1")
            .replace("POS", "POS")
            .trim()
        )
      ) {
        tab.classList.add("active");
      }
    });
  }

  // Update URL without reloading page
  const url = new URL(window.location);
  url.searchParams.set("tab", tabName);

  // Remove generate_report parameter when switching tabs manually
  if (url.searchParams.has("generate_report") && tabName !== "reports") {
    url.searchParams.delete("generate_report");
    url.searchParams.delete("from_date");
    url.searchParams.delete("to_date");
    url.searchParams.delete("report_type");
  }

  window.history.replaceState({}, "", url);
}

function openReportTab(evt, tabName) {
  const tabcontent = document.querySelectorAll("#reports .tab-content");
  for (let i = 0; i < tabcontent.length; i++) {
    tabcontent[i].classList.remove("active");
  }

  const tablinks = document.querySelectorAll("#reports .tab");
  for (let i = 0; i < tablinks.length; i++) {
    tablinks[i].classList.remove("active");
  }

  document.getElementById(tabName).classList.add("active");
  evt.currentTarget.classList.add("active");
}

// Initialize tabs based on current URL or default to POS Monitoring
function initializeTabs() {
  const urlParams = new URLSearchParams(window.location.search);
  let currentTab = urlParams.get("tab");

  // If generating report, force reports tab
  if (urlParams.get("generate_report")) {
    currentTab = "reports";
  }

  // Default to POS Monitoring if no tab specified
  if (!currentTab) {
    currentTab = "posMonitoring";
  }

  // Open the correct tab
  openTab(null, currentTab);
}

// Initialize on DOM content loaded
document.addEventListener("DOMContentLoaded", function () {
  // Initialize tabs
  initializeTabs();

  // Add touch support for mobile
  if ("ontouchstart" in window) {
    document.querySelectorAll(".profile-pic").forEach((pic) => {
      pic.style.cursor = "pointer";
    });
  }
});

// Refresh POS Data function
function refreshPOSData() {
  // alert("Refreshing POS data...");
  // Show loading state
  const refreshBtn = document.querySelector(".refresh");
  const originalHtml = refreshBtn.innerHTML;
  refreshBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Refreshing...';
  refreshBtn.disabled = true;

  // Reload the page with refresh parameter
  const url = new URL(window.location);
  url.searchParams.set("refresh_pos", "1");
  url.searchParams.set("tab", "posMonitoring");
  window.location.href = url.toString();
}

// Report form handling
function setReportTab() {
  // Add the tab parameter to the form before submission
  const form = document.getElementById("reportForm");
  const tabInput = document.createElement("input");
  tabInput.type = "hidden";
  tabInput.name = "tab";
  tabInput.value = "reports";
  form.appendChild(tabInput);
  return true; // Allow form submission
}

// Other admin functions
function editBill(saleId) {
  alert("Edit Bill functionality would open bill editor for ID: " + saleId);
}

function viewBill(saleId) {
  alert("View Bill functionality would show bill details for ID: " + saleId);
}

function editProduct(productId) {
  window.location.href = "stock.php?edit=" + productId;
}

function deleteProduct(productId) {
  if (confirm("Are you sure you want to delete this product?")) {
    window.location.href = "stock.php?delete=" + productId;
  }
}

function showAddProductModal() {
  document.getElementById("addProductModal").style.display = "block";
  document.getElementById("addProductForm").reset();
}

function editUser(userId) {
  fetch("get_user.php?id=" + userId)
    .then((response) => response.json())
    .then((user) => {
      document.getElementById("edit_user_id").value = user.id;
      document.getElementById("edit_full_name").value = user.full_name || "";
      document.getElementById("edit_username").value = user.username;
      document.getElementById("edit_role").value = user.role;
      document.getElementById("editUserModal").style.display = "block";
    })
    .catch((error) => {
      alert("Error loading user data");
    });
}

function deleteUser(userId) {
  if (confirm("Are you sure you want to delete this user?")) {
    const form = document.createElement("form");
    form.method = "POST";
    form.action = "admin.php";

    const input = document.createElement("input");
    input.type = "hidden";
    input.name = "delete_user";
    input.value = "1";
    form.appendChild(input);

    const userInput = document.createElement("input");
    userInput.type = "hidden";
    userInput.name = "user_id";
    userInput.value = userId;
    form.appendChild(userInput);

    document.body.appendChild(form);
    form.submit();
  }
}

function showAddUserModal() {
  document.getElementById("addUserModal").style.display = "block";
}

function filterStock(type) {
  const rows = document.querySelectorAll("#productsTable tbody tr");
  rows.forEach((row) => {
    const stock = parseInt(row.getAttribute("data-stock"));
    const minStock = parseInt(row.getAttribute("data-min-stock"));

    let show = false;
    if (type === "all") show = true;
    else if (type === "low") show = stock > 0 && stock <= minStock;
    else if (type === "out") show = stock <= 0;

    row.style.display = show ? "" : "none";
  });
}

// function shortByStock(type) {
//   const rows = document.querySelectorAll("#productsTable tbody tr");
//   rows.forEach((row) => {
//     const stock = parseInt(row.querySelector("td:nth-child(4)").textContent);
//     const minStock = parseInt(row.querySelector("td:nth-child(5)").textContent);
//     let show = false;
//     if (type === "all") show = true;
//     else if (type === "low") show = stock > 0 && stock <= minStock;
//     else if (type === "out") show = stock <= 0;
//     row.style.display = show ? "" : "none";
//   });
// }

function searchProducts() {
  const searchTerm = document
    .getElementById("productSearch")
    .value.toLowerCase();
  const rows = document.querySelectorAll("#productsTable tbody tr");

  rows.forEach((row) => {
    const productName = row.cells[1].textContent.toLowerCase();
    if (productName.includes(searchTerm)) {
      row.style.display = "";
    } else {
      row.style.display = "none";
    }
  });
}
// Auto-activate first report tab when report is generated
function initializeReportTabs() {
  const urlParams = new URLSearchParams(window.location.search);
  if (urlParams.get("generate_report")) {
    // Auto-activate the first report tab (Views by Bill)
    setTimeout(() => {
      const firstReportTab = document.querySelector("#reports .tab");
      if (firstReportTab) {
        firstReportTab.click();
      }
    }, 100);
  }
}

// Update your DOMContentLoaded event listener in script.js:
document.addEventListener("DOMContentLoaded", function () {
  // Initialize tabs
  initializeTabs();

  // Initialize report tabs if needed
  initializeReportTabs();

  // Add touch support for mobile
  if ("ontouchstart" in window) {
    document.querySelectorAll(".profile-pic").forEach((pic) => {
      pic.style.cursor = "pointer";
    });
  }
});

// Auto-activate first report tab when report is generated
function initializeReportTabs() {
  const urlParams = new URLSearchParams(window.location.search);
  if (urlParams.get("generate_report")) {
    // Auto-activate the first report tab (Views by Bill)
    setTimeout(() => {
      const firstReportTab = document.querySelector("#reports .tab");
      if (firstReportTab) {
        openReportTab({ currentTarget: firstReportTab }, "salesByBill");
      }
    }, 100);
  }
}

// Update your DOMContentLoaded event listener:
document.addEventListener("DOMContentLoaded", function () {
  // Initialize tabs
  initializeTabs();

  // Initialize report tabs if needed
  initializeReportTabs();

  // Add touch support for mobile
  if ("ontouchstart" in window) {
    document.querySelectorAll(".profile-pic").forEach((pic) => {
      pic.style.cursor = "pointer";
    });
  }
});

// Print Report Function with centralized font size control
function printReport(username = "Unknown User", userRole = "Unknown Role") {
  const activeReportTab = document.querySelector(
    "#reports .tab-content.active"
  );
  if (!activeReportTab) {
    alert("No active report tab found.");
    return;
  }

  // ===========================================
  // CENTRALIZED FONT SIZE CONTROL - CHANGE HERE
  // ===========================================
  const fontSizeSettings = {
    body: "14px", // Main body text
    header1: "24px", // Shop name
    header2: "18px", // Report title
    info: "13px", // Generated by, date range info
    table: "13px", // Table text
    tableHeader: "13px", // Table header text
    printBody: "13px", // Body text when printing
    printTable: "12px", // Table text when printing
  };
  // ===========================================

  // Get report title and remove dates from it
  const reportTitleWithDate = activeReportTab.querySelector("h4").innerText;

  // Remove date ranges from report titles (anything in parentheses)
  let reportTitle = reportTitleWithDate.replace(/\s*\(.*\)$/, "");

  // If it's "Sale Compare Stock", keep it as is, otherwise clean up
  if (reportTitleWithDate.includes("Sale Compare Stock")) {
    reportTitle = "Sale Compare Stock";
  }

  const shopName =
    "<?php echo addslashes($shop_info['shop_name'] ?? 'Souvenir Shop'); ?>";
  const currentDate = new Date().toLocaleString();

  // Get date range in dd/mmm/yyyy format
  const fromDate = formatDateForPrint(
    document.querySelector('input[name="from_date"]').value
  );
  const toDate = formatDateForPrint(
    document.querySelector('input[name="to_date"]').value
  );

  // Clone the table to avoid modifying the original
  const table = activeReportTab.querySelector("table");
  // const calendar = activeReportTab.querySelector("#totalSales");
  // const calendarClone = calendar.cloneNode(true);

  // print calendar
  if (!table) {
    printElementById("totalSales");
  }

  function printElementById(elementId) {
    // Store original HTML
    const originalContent = document.body.innerHTML;

    // Get the element to print
    const printContent = document.getElementById(elementId).innerHTML;

    // Replace entire body with just the element content
    document.body.innerHTML = printContent;

    // Add print-specific styling
    const style = document.createElement("style");
    style.innerHTML = `
        @media print {
            body { margin: 0; padding: 20px; }
            .calendar-view { 
                display: grid; 
                grid-template-columns: repeat(7, 1fr);
                gap: 10px;
                margin-top: 20px;
            }
            .calendar-day { 
                border: 1px solid #ddd; 
                padding: 10px; 
                text-align: center;
                min-height: 60px;
                position: relative;
            }
            .calendar-day.has-sales { 
                background-color: #e8f5e9; 
                border-color: #4caf50;
            }
            .sales-amount { 
                font-size: 12px; 
                color: #2e7d32; 
                margin-top: 5px; 
                font-weight: bold;
            }
        }
    `;
    document.head.appendChild(style);

    // Trigger print
    window.print();

    // Restore original content
    document.body.innerHTML = originalContent;

    // Re-attach event listeners if needed
    window.location.reload(); // Or use more specific restoration
  }

  const tableClone = table.cloneNode(true);
  // Create print window
  const printWindow = window.open("", "_blank", "width=1200,height=700");
  printWindow.document.write(`
        <html>
            <head>
                <title>${reportTitle} - ${shopName}</title>
                <style>
                    body { 
                        font-family: Arial, sans-serif; 
                        margin: 15px; 
                        color: #333;
                        font-size: ${fontSizeSettings.body};
                    }
                    .print-header {
                        text-align: center;
                        margin-bottom: 20px;
                        border-bottom: 2px solid #333;
                        padding-bottom: 15px;
                    }
                    .print-header h1 {
                        color: #2c3e50;
                        margin: 0 0 8px 0;
                        font-size: ${fontSizeSettings.header1};
                    }
                    .print-header h2 {
                        margin: 5px 0;
                        font-size: ${fontSizeSettings.header2};
                        color: #34495e;
                    }
                    .print-info {
                        display: flex;
                        justify-content: space-between;
                        margin-bottom: 15px;
                        font-size: ${fontSizeSettings.info};
                        line-height: 1.3;
                    }
                    .print-info div {
                        margin-bottom: 3px;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                        margin-top: 15px;
                        font-size: ${fontSizeSettings.table};
                    }
                    th {
                        background-color: #34495e !important;
                        background-image: none !important;
                        color: white !important;
                        padding: 12px 8px;
                        text-align: center;
                        border: 1px solid #2c3e50;
                        font-weight: bold;
                        font-size: ${fontSizeSettings.tableHeader};
                        -webkit-print-color-adjust: exact;
                        print-color-adjust: exact;
                    }
                    td {
                        padding: 8px 7px;
                        border: 1px solid #ddd;
                        font-size: ${fontSizeSettings.table};
                        line-height: 1.2;
                        text-align: center;
                    }
                    tr:nth-child(even) {
                        background-color: #f8f9fa;
                    }
                    .no-print {
                        display: none;
                    }
                    /* Prevent text wrapping in table cells */
                    td, th {
                        white-space: nowrap;
                        overflow: hidden;
                        text-overflow: ellipsis;
                        max-width: 200px;
                    }
                    /* Allow wrapping only for Item column */
                    td:nth-child(3) {
                        white-space: normal;
                        max-width: 250px;
                        text-align: left;
                    }
                    /* Ensure Item header is centered like others */
                    th:nth-child(3) {
                        text-align: center;
                        white-space: normal;
                    }
                    @media print {
                        body { 
                            margin: 10px; 
                            font-size: ${fontSizeSettings.printBody};
                        }
                        .print-header { 
                            margin-bottom: 10px; 
                            padding-bottom: 10px;
                        }
                        .print-header h1 { font-size: ${
                          parseInt(fontSizeSettings.header1) - 2
                        }px; }
                        .print-header h2 { font-size: ${
                          parseInt(fontSizeSettings.header2) - 2
                        }px; }
                        th { 
                            background-color: #34495e !important; 
                            background-image: none !important;
                            color: white !important; 
                            padding: 10px 6px;
                            font-size: ${fontSizeSettings.printTable};
                            -webkit-print-color-adjust: exact;
                            print-color-adjust: exact;
                        }
                        td { 
                            padding: 6px 5px;
                            font-size: ${fontSizeSettings.printTable};
                            text-align: center;
                        }
                        td:nth-child(3) { /* Item name column */
                            text-align: left;
                        }
                        th:nth-child(3) { /* Item header */
                            text-align: center;
                        }
                        table { font-size: ${fontSizeSettings.printTable}; }
                    }
                </style>
            </head>
            <body>
                <div class="print-header">
                    <h1>${shopName}</h1>
                    <h2>${reportTitle}</h2>
                </div>
                
                <div class="print-info">
                    <div>
                        <strong>Generated By:</strong> ${username}<br>
                        <strong>Report Type:</strong> ${reportTitle}<br>
                        <strong>Date Range:</strong> ${fromDate} to ${toDate}
                    </div>
                    <div>
                        <strong>Print Date:</strong> ${currentDate}<br>
                        <strong>Page:</strong> 1
                    </div>
                </div>
                
                ${tableClone.outerHTML}
                
                <script>
                    window.onload = function() {
                        // Force background colors in print
                        const style = document.createElement('style');
                        style.innerHTML = '@media print { th { background-color: #34495e !important; color: white !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; } }';
                        document.head.appendChild(style);
                        
                        window.print();
                        setTimeout(function() {
                            window.close();
                        }, 500);
                    };
                </script>
            </body>
        </html>
    `);
  printWindow.document.close();
}

// Helper function to format date as dd/mmm/yyyy
function formatDateForPrint(dateString) {
  const date = new Date(dateString);
  const day = date.getDate().toString().padStart(2, "0");
  const month = date.toLocaleString("en", { month: "short" });
  const year = date.getFullYear();
  return `${day}/${month}/${year}`;
}

// Helper function to format date as dd/mmm/yyyy
function formatDateForPrint(dateString) {
  const date = new Date(dateString);
  const day = date.getDate().toString().padStart(2, "0");
  const month = date.toLocaleString("en", { month: "short" });
  const year = date.getFullYear();
  return `${day}/${month}/${year}`;
}

// Helper function to format date as dd/mmm/yyyy
function formatDateForPrint(dateString) {
  const date = new Date(dateString);
  const day = date.getDate().toString().padStart(2, "0");
  const month = date.toLocaleString("en", { month: "short" });
  const year = date.getFullYear();
  return `${day}/${month}/${year}`;
}

// Export CSV Function
function exportReport() {
  const activeReportTab = document.querySelector(
    "#reports .tab-content.active"
  );
  if (!activeReportTab) {
    alert("No active report tab found.");
    return;
  }
  // export totalsale calendar start

  const table = activeReportTab.querySelector("table");
  if (!table) {
    exportToCSV();
  }

  function exportToCSV() {
    // Get data from the calendar
    const calendarData = extractCalendarData();

    // Convert to CSV
    const csvContent = convertToCSV(calendarData);

    // Download the file
    // downloadCSV(csvContent, "sales_calendar.csv");
    const dateTime = formatDateForFilename();
    downloadCSV(csvContent, "toalsales_calendar_" + dateTime + ".csv");
  }

  function extractCalendarData() {
    const data = [];
    const days = document.querySelectorAll("#calendarView .calendar-day");

    // Get the month/year from the heading
    const heading = document.querySelector("#totalSales h4").textContent;
    const monthYearMatch = heading.match(/\(([^)]+)\)/);
    const monthYear = monthYearMatch ? monthYearMatch[1] : "";

    // Extract data for each day
    days.forEach((day) => {
      const dayNumber = parseInt(day.textContent.match(/\d+/)[0]);
      const hasSales = day.classList.contains("has-sales");
      const salesAmount = hasSales
        ? parseFloat(
            day.querySelector(".sales-amount").textContent.replace(/[$,]/g, "")
          )
        : 0;

      // Assuming we know the month/year, we can create a date
      // You might need to adjust this based on your actual date structure
      const currentDate = new Date();
      const exportDate = new Date(
        currentDate.getFullYear(),
        currentDate.getMonth(),
        dayNumber
      );

      data.push({
        date: exportDate.toISOString().split("T")[0], // YYYY-MM-DD
        day: dayNumber,
        has_sales: hasSales ? "Yes" : "No",
        sales_amount: salesAmount,
        formatted_date: exportDate.toLocaleDateString("en-US", {
          weekday: "short",
          day: "numeric",
          month: "short",
          year: "numeric",
        }),
      });
    });

    return data;
  }

  function convertToCSV(data) {
    // CSV headers
    const headers = [
      "Date",
      "Day",
      "Has Sales",
      "Sales Amount ($)",
      "Formatted Date",
    ];

    // Create CSV content
    let csvContent = headers.join(",") + "\n";

    // Add data rows
    data.forEach((item) => {
      const row = [
        `"${item.date}"`,
        item.day,
        `"${item.has_sales}"`,
        item.sales_amount,
        `"${item.formatted_date}"`,
      ];
      csvContent += row.join(",") + "\n";
    });

    return csvContent;
  }

  function downloadCSV(csvContent, filename) {
    // Create a blob and download link
    const blob = new Blob([csvContent], { type: "text/csv;charset=utf-8;" });
    const url = URL.createObjectURL(blob);
    const link = document.createElement("a");

    // Set download attributes
    link.setAttribute("href", url);
    link.setAttribute("download", filename);
    link.style.visibility = "hidden";

    // Append to body and trigger download
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);

    // Clean up
    URL.revokeObjectURL(url);
  }
  // export totalsale calendar end
  // Get the report title exactly as shown in the tab
  const reportTitle = activeReportTab
    .querySelector("h4")
    .textContent.replace(/<i[^>]*>.*?<\/i>/g, "") // Remove icons
    .replace(/[^\w\s()-]/g, "") // Remove special characters except parentheses and hyphens
    .trim();

  const shopName =
    "<?php echo addslashes($shop_info['shop_name'] ?? 'Souvenir_Shop'); ?>";
  const username = "<?php echo addslashes($_SESSION['username']); ?>";
  const currentDate = new Date().toISOString().split("T")[0];

  let csvContent = "";

  // Add headers
  const headers = [];
  table.querySelectorAll("thead th").forEach((th) => {
    headers.push(`"${th.textContent.trim()}"`);
  });
  csvContent += headers.join(",") + "\n";

  // Add data rows
  table.querySelectorAll("tbody tr").forEach((tr) => {
    const row = [];
    tr.querySelectorAll("td").forEach((td) => {
      // Remove any HTML and clean the text
      let text = td.textContent.trim();
      // Remove currency symbols and commas for numbers (but keep for item names)
      if (td.cellIndex !== 2) {
        // Don't remove from item name column (adjust index as needed)
        text = text.replace(/[$,]/g, "");
      }
      // Handle quotes in text
      text = text.replace(/"/g, '""');
      row.push(`"${text}"`);
    });
    csvContent += row.join(",") + "\n";
  });

  // Create and download file
  const blob = new Blob([csvContent], { type: "text/csv;charset=utf-8;" });
  const link = document.createElement("a");
  const url = URL.createObjectURL(blob);

  // Use the exact report title for filename
  const fileName = `${reportTitle.replace(/\s+/g, "_")}.csv`;

  link.setAttribute("href", url);
  link.setAttribute("download", fileName);
  link.style.visibility = "hidden";

  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);

  // Show success message
  showExportSuccess();
}

// Show export success message
function showExportSuccess() {
  const successMsg = document.createElement("div");
  successMsg.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: #27ae60;
        color: white;
        padding: 15px 20px;
        border-radius: 8px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        z-index: 10000;
        font-weight: 600;
        animation: slideInRight 0.3s ease;
    `;
  successMsg.innerHTML =
    '<i class="fas fa-check-circle"></i> CSV exported successfully!';
  document.body.appendChild(successMsg);

  setTimeout(() => {
    successMsg.style.animation = "slideOutRight 0.3s ease";
    setTimeout(() => {
      document.body.removeChild(successMsg);
    }, 300);
  }, 3000);
}

// Add CSS animations for export success message
const style = document.createElement("style");
style.textContent = `
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOutRight {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
`;
document.head.appendChild(style);

// Show report help
function showReportHelp() {
  const helpContent = `
        <div style="padding: 20px;">
            <h3><i class="fas fa-question-circle"></i> Report Help</h3>
            <div style="margin-top: 15px;">
                <p><strong>Generate Report:</strong> Creates a new report based on your selected date range and report type.</p>
                <p><strong>Print Report:</strong> Prints the currently visible report tab with professional formatting.</p>
                <p><strong>Export CSV:</strong> Downloads the current report as a CSV file for Excel analysis.</p>
                <p><strong>Report Types:</strong></p>
                <ul>
                    <li><strong>Sales Report:</strong> View sales data by bill, product, or calendar view</li>
                    <li><strong>Stock Report:</strong> Compare stock levels and sales</li>
                </ul>
            </div>
        </div>
    `;

  // You can use a modal or alert - here's a simple alert version
  alert(helpContent.replace(/<[^>]*>/g, "")); // Strip HTML for alert
}

// For calendar view, use the hidden table
if (activeTabId === "totalSales") {
  const calendarTable = document.getElementById("calendarTable");
  if (calendarTable) {
    tableClone = calendarTable.querySelector("table").cloneNode(true);
  } else {
    // Fallback: create a simple table from calendar data
    tableClone = document.createElement("table");
    // ... create table structure for calendar data
  }
} else {
  tableClone = table.cloneNode(true);
}

$(document).ready(function () {
  $(document).on("click", "#edit_product_button", function () {
    // var id = $(this).data('id');
    alert(id);
  });
});

// $(document).ready(function () {
//   $(document).on("click", "#bill_number_code", function () {
//     $("#modalDetailBill").style.display = "block";
//   });
// });

function formatDateDisplay() {
  const dateInput = document.getElementById("dateInput");
  const dateDisplay = document.getElementById("dateDisplay");

  if (dateInput.value) {
    const date = new Date(dateInput.value);
    // Format as dd/mm/yyyy
    const formatted = `${String(date.getDate()).padStart(2, "0")}/${String(
      date.getMonth() + 1
    ).padStart(2, "0")}/${date.getFullYear()}`;
    dateDisplay.textContent = formatted;
  } else {
    dateDisplay.textContent = "";
  }
}

$("#report_start_date").datepicker({
  format: "dd M yyyy",
  autoclose: true,
  todayHighlight: true,
  orientation: "bottom auto",
});

// $(function () {
//   $("#myDate").datepicker({
//     dateFormat: "dd/mm/yy", // Your custom format, e.g., 12/12/2025
//     changeMonth: true, // Optional: dropdown for month
//     changeYear: true, // Optional: dropdown for year
//     yearRange: "1900:2100", // Optional: limit years
//   });
// });

$(".datepicker").datepicker({});

$(document).ready(function () {
  $("#customerTable").dataTable({ order: [] });
});

$(document).ready(function () {
  // Select 2
  $("#customerSelect").select2();
  $(".select2_demo_2").select2({
    placeholder: "Select a state",
    allowClear: true,
  });
});
$("#customerSelect").select2();

///////// validate submit with required field ////////////

// apply for all forms with required fields
document.querySelectorAll("form").forEach((form) => {
  form.addEventListener("submit", function (event) {
    const requiredFields = form.querySelectorAll("[required]");
    let allValid = true;
    requiredFields.forEach((field) => {
      if (!field.value.trim()) {
        allValid = false;
        field.classList.add("input-error");
      } else {
        field.classList.remove("input-error");
      }
    });
    if (!allValid) {
      event.preventDefault();
      alert("Please fill in all required fields.");
    }
  });
});

// export and print function for all table
function exportTableToCSV(tableId, exportTitle) {
  const table = $(`#${tableId}`).DataTable();

  // Save current state
  const originalSearch = table.search();
  const originalPageLen = table.page.len();
  const originalPage = table.page();

  // Show all rows
  table.search("").page.len(-1).draw();

  setTimeout(function () {
    const tableElement = document.getElementById(tableId);
    const rows = tableElement.querySelectorAll("tr");
    let csvContent = "data:text/csv;charset=utf-8,\ufeff";

    for (let i = 0; i < rows.length; i++) {
      const row = rows[i];
      const cols = row.querySelectorAll("td, th");
      const rowData = [];

      for (let j = 0; j < cols.length; j++) {
        // Clone the cell to avoid modifying the original DOM
        const cell = cols[j].cloneNode(true);

        // Process links: keep the inner text
        const links = cell.querySelectorAll("a");
        links.forEach((link) => {
          // Keep the text content of the link
          const text = link.textContent || link.innerText;
          link.replaceWith(document.createTextNode(text));
        });

        // Remove buttons completely (or keep text if you prefer)
        const buttons = cell.querySelectorAll("button, .btn");
        buttons.forEach((button) => {
          // Option 1: Remove button completely
          button.remove();

          // Option 2: Keep button text (uncomment below)
          // const text = button.textContent || button.innerText;
          // button.replaceWith(document.createTextNode(text));
        });

        // Get the cleaned text content
        let cellContent = cell.textContent || cell.innerText;
        cellContent = cellContent.trim();

        // CSV escaping
        cellContent = cellContent.replace(/"/g, '""');
        if (
          cellContent.includes(",") ||
          cellContent.includes('"') ||
          cellContent.includes("\n")
        ) {
          cellContent = '"' + cellContent + '"';
        }

        rowData.push(cellContent);
      }

      csvContent += rowData.join(",") + "\n";
    }

    // Reset to original state
    table.search(originalSearch);
    table.page.len(originalPageLen);
    table.page(originalPage).draw(false);

    // Create download link
    const encodedUri = encodeURI(csvContent);
    const link = document.createElement("a");
    link.setAttribute("href", encodedUri);
    link.setAttribute(
      "download",
      `${exportTitle}_${new Date().toISOString().slice(0, 10)}.csv`
    );
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
  }, 500);
}

function printTable(tableId, exportTitle) {
  const table = $(`#${tableId}`).DataTable();

  // Save current state
  const originalSearch = table.search();
  const originalPageLen = table.page.len();
  const originalPage = table.page();
  const originalInfo = table.page.info();

  // Show all rows
  table.search("").page.len(-1).draw();

  // Wait for DataTable to redraw
  setTimeout(function () {
    // Clone the table element
    const tableElement = document.getElementById(tableId);
    const printWindow = window.open("", "_blank", "width=900,height=650");

    // Clean the table for printing
    const tableClone = tableElement.cloneNode(true);

    // Remove DataTables controls (search, pagination, etc.)
    const dataTablesElements = tableClone.querySelectorAll(
      ".dataTables_length, .dataTables_filter, .dataTables_info, .dataTables_paginate, .dt-buttons"
    );
    dataTablesElements.forEach((el) => el.remove());

    // Remove action buttons but keep link text
    tableClone.querySelectorAll("a").forEach((link) => {
      const text = link.textContent || link.innerText;
      link.replaceWith(document.createTextNode(text));
    });

    // Remove buttons and other interactive elements
    tableClone
      .querySelectorAll("button, .btn, .dt-button, [onclick], input")
      .forEach((el) => {
        el.remove();
      });

    // Remove hidden columns (optional)
    tableClone.querySelectorAll("td.dt-hidden, th.dt-hidden").forEach((el) => {
      el.remove();
    });

    // Create print HTML
    const printContent = `
      <!DOCTYPE html>
      <html>
        <head>
          <title>${exportTitle}</title>
          <style>
            @media print {
              @page {
                size: landscape;
                margin: 0.5cm;
              }
              body {
                font-family: Arial, sans-serif;
                margin: 20px;
              }
              table {
                width: 100%;
                border-collapse: collapse;
                font-size: 12px;
              }
              th {
                background-color: #f2f2f2;
                font-weight: bold;
                text-align: left;
                padding: 8px;
                border: 1px solid #ddd;
              }
              td {
                padding: 6px;
                border: 1px solid #ddd;
                vertical-align: top;
              }
              tr:nth-child(even) {
                background-color: #f9f9f9;
              }
              .no-print {
                display: none !important;
              }
              .print-header {
                text-align: center;
                margin-bottom: 20px;
                border-bottom: 2px solid #000;
                padding-bottom: 10px;
              }
              .print-title {
                font-size: 18px;
                font-weight: bold;
                margin-bottom: 5px;
              }
              .print-date {
                font-size: 12px;
                color: #666;
              }
              .print-footer {
                margin-top: 20px;
                font-size: 10px;
                text-align: center;
                color: #666;
              }
            }
            @media screen {
              body {
                font-family: Arial, sans-serif;
                margin: 20px;
              }
              table {
                width: 100%;
                border-collapse: collapse;
                font-size: 12px;
              }
              th {
                background-color: #f2f2f2;
                font-weight: bold;
                text-align: left;
                padding: 8px;
                border: 1px solid #ddd;
              }
              td {
                padding: 6px;
                border: 1px solid #ddd;
                vertical-align: top;
              }
              tr:nth-child(even) {
                background-color: #f9f9f9;
              }
              .print-header {
                text-align: center;
                margin-bottom: 20px;
                border-bottom: 2px solid #000;
                padding-bottom: 10px;
              }
              .print-title {
                font-size: 18px;
                font-weight: bold;
                margin-bottom: 5px;
              }
              .print-date {
                font-size: 12px;
                color: #666;
              }
              .print-footer {
                margin-top: 20px;
                font-size: 10px;
                text-align: center;
                color: #666;
              }
            }
          </style>
        </head>
        <body>
          <div class="print-header">
            <div class="print-title">${exportTitle}</div>
            <div class="print-date">Printed on: ${new Date().toLocaleDateString()} ${new Date().toLocaleTimeString()}</div>
            <div class="print-date">Total Records: ${table
              .rows({ search: "applied" })
              .count()}</div>
          </div>
          ${tableClone.outerHTML}
          <div class="print-footer">
            Page 1 of 1 | Generated from ${window.location.hostname}
          </div>
          <script>
            // Auto-print when window loads
            window.onload = function() {
              setTimeout(function() {
                window.print();
                // Close window after printing (optional)
                // setTimeout(function() { window.close(); }, 500);
              }, 500);
            };
            
            // Handle after print event
            window.onafterprint = function(event) {
              // Optionally close the window after printing
              // window.close();
            };
          </script>
        </body>
      </html>
    `;

    // Write content to print window
    printWindow.document.open();
    printWindow.document.write(printContent);
    printWindow.document.close();

    // Reset table to original state
    table.search(originalSearch);
    table.page.len(originalPageLen);
    table.page(originalPage).draw(false);
  }, 500);
}
