<?php
// ajax/get_last_bill.php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

try {

     // Get the last sale (max ID) for the current cashier
     $sale_stmt = $pdo->prepare("
        SELECT s.*,
               u.username as cashier_name,
               c.name as customer_name
               FROM sales s
               LEFT JOIN users u ON s.cashier_id = u.id
               LEFT JOIN customers c ON s.customer_id = c.id
               WHERE s.cashier_id = :cashier_id
               ORDER BY s.id DESC
               LIMIT 1
    ");
     $sale_stmt->execute([':cashier_id' => $_SESSION['user_id']]);
     $bill = $sale_stmt->fetch(PDO::FETCH_ASSOC);

     if (!$bill) {
          // If no sale for current cashier, get any last sale
          $sale_stmt = $pdo->prepare("
            SELECT 
                s.*,
                u.username as cashier_name,
                c.name as customer_name
            FROM sales s
            LEFT JOIN users u ON s.cashier_id = u.id
            LEFT JOIN customers c ON s.customer_id = c.id
            ORDER BY s.id DESC
            LIMIT 1
        ");
          $sale_stmt->execute();
          $bill = $sale_stmt->fetch(PDO::FETCH_ASSOC);
     }

     if (!$bill) {
          echo json_encode([
               'success' => false,
               'message' => 'No sales found'
          ]);
          exit;
     }

     // Get sale items for this sale
     $items_stmt = $pdo->prepare("
        SELECT 
            si.*,
            p.name as product_name,
            p.p_code as product_code
        FROM sale_items si
        LEFT JOIN products p ON si.product_id = p.id
        WHERE si.sale_id = ?
        ORDER BY si.id
    ");
     $items_stmt->execute([$bill['id']]);
     $items = $items_stmt->fetchAll(PDO::FETCH_ASSOC);

     // Get system settings
     $system_stmt = $pdo->prepare("SELECT * FROM system_settings LIMIT 1");
     $system_stmt->execute();
     $system = $system_stmt->fetch(PDO::FETCH_ASSOC);

     echo json_encode([
          'success' => true,
          'bill' => $bill,
          'items' => $items,
          'system' => $system
     ]);
} catch (Exception $e) {
     echo json_encode([
          'success' => false,
          'error' => $e->getMessage()
     ]);
}
