<?php

// Start session if needed
session_start();
// ajax.php
error_reporting(0);
// make is suitable for SSE
header("Cache-Control: no-store");
header("Content-Type: text/event-stream");
header('Content-Type: application/json');

// Include database connection
require_once 'config/database.php'; // Adjust path as needed

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'get_product' && isset($_POST['product_id'])) {
        $product_id = intval($_POST['product_id']);

        try {
            // Prepare and execute query
            $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
            $stmt->execute([$product_id]);
            $product = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($product) {
                // Return product data as JSON
                echo json_encode([
                    'success' => true,
                    'data' => $product
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Product not found'
                ]);
            }
        } catch (PDOException $e) {
            echo json_encode([
                'success' => false,
                'message' => 'Database error: ' . $e->getMessage()
            ]);
        }
    }
}



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['is_updating'])) {
    $stmt = $pdo->prepare("UPDATE products SET is_update = 0");
    $stmt->execute();
    exit;
}

/// bill detail 
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bill_number'])) {
    $bill_number = $_POST['bill_number'];

    // Debug: Log the request
    error_log("Fetching bill details for: " . $bill_number);

    try {
        // 1. Get bill details from sales table
        $stmt = $pdo->prepare("
            SELECT 
                s.*,
                u.full_name as cashier_name,
                u.username as cashier_username,
                customers.fullname as customer_name,
                customers.phone as customer_phone,
                customers.address as customer_address
            FROM sales s
            LEFT JOIN users u ON s.cashier_id = u.id
            LEFT JOIN customers ON s.customer_id = customers.id
            WHERE s.bill_number = ?
        ");

        $stmt->execute([$bill_number]);
        $bill = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($bill) {
            // 2. Get all items for this sale from sale_items table
            $items_stmt = $pdo->prepare("
                SELECT 
                    si.id,
                    si.product_id,
                    si.quantity,
                    si.unit_price,
                    si.total_price,
                    si.date as item_date,
                    p.name as product_name,
                    p.p_code,
                    p.description

                    

                FROM sale_items si
                LEFT JOIN products p ON si.product_id = p.id
                JOIN sales s ON si.sale_id = s.id
                WHERE si.sale_id = ?
                ORDER BY si.id ASC
            ");

            $items_stmt->execute([$bill['id']]);
            $items = $items_stmt->fetchAll(PDO::FETCH_ASSOC);

            // Format the response
            $response = [
                'id' => $bill['id'],
                'bill_number' => $bill['bill_number'],
                'cashier_id' => $bill['cashier_id'],
                'cashier_name' => $bill['cashier_name'] . " (" . $bill['cashier_username'] . ")",
                'cashier_username' => $bill['cashier_username'],
                'shift_id' => $bill['shift_id'],
                'total_amount' => $bill['total_amount'],
                'discount' => $bill['discount'],
                'final_amount' => $bill['final_amount'],
                'payment_method' => $bill['payment_method'],
                'created_at' => date("d M Y h:i:s A", strtotime($bill['created_at'])),
                'customer_name' => $bill['customer_name'],
                'customer_phone' => $bill['customer_phone'],
                'customer_address' => $bill['customer_address'],
                'items' => $items
            ];

            echo json_encode([
                'success' => true,
                'data' => $response
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Bill not found: ' . $bill_number
            ]);
        }
    } catch (PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage()
        ]);
    }
    exit;
}

// In ajax.php - Refined version
// Ensure you have $pdo defined for your database connection
// Example: $pdo = new PDO('mysql:host=localhost;dbname=testdb', 'user', 'pass');

// Check for action and customer_id

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_id']) && isset($_POST['action'])) {

    // Add logic to handle different actions if ajax.php is used for multiple purposes
    if ($_POST['action'] === 'fetch_customer') {

        $customer_id = $_POST['customer_id'];

        // Ensure customer_id is an integer (good practice for IDs)
        if (!filter_var($customer_id, FILTER_VALIDATE_INT)) {
            http_response_code(400); // Bad Request
            echo json_encode(['success' => false, 'message' => 'Invalid customer ID format.']);
            exit();
        }

        try {
            // Use PDO connection $pdo
            $stmt = $pdo->prepare("
                SELECT id, fullname, phone, address
                FROM customers 
                WHERE id = ?
            ");
            $stmt->execute([$customer_id]);
            $customer = $stmt->fetch(PDO::FETCH_ASSOC);

            // Set content type header before outputting JSON
            header('Content-Type: application/json');

            if ($customer) {
                echo json_encode([
                    'success' => true,
                    'data' => $customer
                ]);
            } else {
                // Return 404 if the customer ID is valid but not found
                http_response_code(404);
                echo json_encode([
                    'success' => false,
                    'message' => 'Customer not found',
                    'customer_id' => $customer_id
                ]);
            }
        } catch (Exception $e) {
            http_response_code(500); // Internal Server Error
            error_log("Database error: " . $e->getMessage());
            echo json_encode([
                'success' => false,
                'message' => 'Database error occurred. Please try again.'
                // Don't expose full error message in production
            ]);
        }
        exit();
    }
    // Add other actions here (e.g., 'update_customer')
}

// Fallback for requests that don't match expected POST data
// http_response_code(400); 
// header('Content-Type: application/json');
// echo json_encode(['success' => false, 'message' => 'Invalid request.']);
// exit();

// stock by product type 


?>