<?php
date_default_timezone_set('Asia/Phnom_Penh');
// Start session at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include authentication functions and database
require_once 'includes/auth.php';
require_once 'config/database.php';
require_once 'log_functions.php';

// Check if user is logged in and has appropriate role
if (!isLoggedIn()) {
    header('Location: index.php');
    exit();
}

checkRole(['admin', 'owner']);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_user'])) {
        $username = $_POST['username'];
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $full_name = $_POST['full_name'];
        $role = $_POST['role'];

        $stmt = $pdo->prepare("INSERT INTO users (username, password, full_name, role) VALUES (?, ?, ?, ?)");
        $stmt->execute([$username, $password, $full_name, $role]);

        header('Location: admin.php');
        exit;
    } elseif (isset($_POST['update_user'])) {
        $user_id = $_POST['user_id'];
        $username = $_POST['username'];
        $full_name = $_POST['full_name'];
        $role = $_POST['role'];

        $stmt = $pdo->prepare("UPDATE users SET username = ?, full_name = ?, role = ? WHERE id = ?");
        $stmt->execute([$username, $full_name, $role, $user_id]);

        header('Location: admin.php');
        exit;
    } elseif (isset($_POST['delete_user'])) {
        $user_id = $_POST['user_id'];

        $stmt = $pdo->prepare("UPDATE users SET status = 'inactive' WHERE id = ?");
        $stmt->execute([$user_id]);

        header('Location: admin.php');
        exit;
    }
    /*
    elseif (isset($_POST['update_shop_info'])) {
        $shop_name = $_POST['shop_name'];
        $address = $_POST['address'];
        $phone = $_POST['phone'];

        $stmt = $pdo->prepare("UPDATE shop_info SET shop_name = ?, address = ?, phone = ? WHERE id = 1");
        $stmt->execute([$shop_name, $address, $phone]);

        header('Location: admin.php');
        exit;
    } elseif (isset($_POST['update_system_preferences'])) {
        $receipt_header = $_POST['receipt_header'];
        $receipt_footer = $_POST['receipt_footer'];

        $stmt = $pdo->prepare("UPDATE shop_info SET receipt_header = ?, receipt_footer = ? WHERE id = 1");
        $stmt->execute([$receipt_header, $receipt_footer]);

        header('Location: admin.php');
        exit;
    }
    */
}


// Handle report generation
require_once("includes/script-php/generate-report.php");


// Fetch data for different sections



// Recent sales script
require_once("includes/script-php/recent-sale.php");


// Products with stock info and // Stock alerts
require_once("includes/script-php/product-with-stock.php");


// outstock script 
require_once("includes/script-php/outstock-script.php");



// Users for management
require_once("includes/script-php/user-script.php");


// Shop info
require_once("includes/script-php/shop-info-script.php");



// Sales reports data
require_once("includes/script-php/sale-report-script.php");

// Get current tab - force reports tab if generating report
if (isset($_GET['generate_report'])) {
    $current_tab = 'reports';
} else {
    $current_tab = $_GET['tab'] ?? 'posMonitoring';
}
?>
<!DOCTYPE html>
<html lang="<?= $default_language == 'en' ? 'en' : 'km' ?>">

<head>
    <?php include_once('includes/meta.php') ?>

    <style>
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .dashboard-card {
            background: white;
            padding: 1.5rem;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            /* border-left: 4px solid #3498db; */
        }

        .active-cashiers {
            display: grid;
            gap: 1rem;
        }

        .cashier-card {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 8px;
            border-left: 4px solid #27ae60;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .cashier-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .cashier-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cashier-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 0.5rem;
            margin-top: 0.5rem;
            font-size: 0.9rem;
        }

        .stat-item {
            text-align: center;
            padding: 0.5rem;
            background: white;
            border-radius: 5px;
        }



        .filter-section {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .calendar-view {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 0.5rem;
            margin-top: 1rem;
        }

        .calendar-day {
            padding: 1rem;
            text-align: center;
            border-radius: 5px;
            background: #ecf0f1;
            position: relative;
        }

        .calendar-day.has-sales {
            background: #27ae60;
            color: white;
        }

        .calendar-day .sales-amount {
            font-size: 0.8rem;
            margin-top: 0.25rem;
        }

        .user-management {
            display: grid;
            gap: 1rem;
        }

        .user-card {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.32);
        }

        .user-actions {
            display: flex;
            gap: 0.5rem;
        }

        .status.active {
            color: #27ae60;
            font-weight: bold;
        }

        .top-items {
            margin-top: 0.5rem;
            font-size: 0.9rem;
        }

        .top-items span {
            background: #3498db;
            color: white;
            padding: 0.2rem 0.5rem;
            border-radius: 3px;
            margin-right: 0.5rem;
            margin-bottom: 0.2rem;
            display: inline-block;
        }

        .bill-items-list {
            max-height: 300px;
            overflow-y: auto;
            margin: 1rem 0;
        }

        .bill-item-row {
            display: flex;
            justify-content: space-between;
            padding: 0.5rem;
            border-bottom: 1px solid #ecf0f1;
        }

        .bill-item-actions {
            display: flex;
            gap: 0.5rem;
        }

        .report-actions {
            margin-top: 1rem;
            display: flex;
            gap: 1rem;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .refresh-btn {
            background: #3498db;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .refresh-btn:hover {
            background: #2980b9;
        }

        /* Enhanced Tab Styling */
        .tabs {
            background: #f8f9fa;
            border-radius: 10px;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .tab {
            /* flex: 1; */
            text-align: center;
            /* padding: 15px 20px; */
            cursor: pointer;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 600;
            color: #6c757d;
            border: 2px solid transparent;
            background-color: #f8f9fa;
        }

        .tab:hover {
            background: #e9ecef;
            color: #495057;
        }

        .tab.active {
            background: #3498db;
            color: white;
            box-shadow: 0 4px 15px rgba(52, 152, 219, 0.3);
            border-color: #2980b9;
            transform: translateY(-2px);
        }

        /* Report Tabs Styling */
        #reports .tabs {
            background: #e9ecef;
            margin-bottom: 1rem;
        }

        #reports .tab {
            padding: 12px 15px;
            font-size: 0.9rem;
        }

        #reports .tab.active {
            background: #27ae60;
            border-color: #219a52;
        }

        /* Button Group Styling */
        /* .button-group {
            display: flex;
            gap: 1rem;
            align-items: center;
            flex-wrap: wrap;
            margin-top: 1rem;
        }

        .button-group .btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: #3498db;
            color: white;
        }

        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(52, 152, 219, 0.3);
        }

        .btn-print {
            background: #95a5a6;
            color: white;
        }

        .btn-print:hover {
            background: #7f8c8d;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(149, 165, 166, 0.3);
        }

        .btn-success {
            background: #27ae60;
            color: white;
        }

        .btn-success:hover {
            background: #219a52;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
        } */

        /* Filter Section Improvements */
        .filter-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 1.5rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .filter-section h4 {
            color: white;
            margin-bottom: 1rem;
            font-size: 1.2rem;
        }

        .filter-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 1rem;
        }

        .filter-section .form-group label {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
            display: block;
        }

        .filter-section .form-group input,
        .filter-section .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: none;
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.9);
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .filter-section .form-group input:focus,
        .filter-section .form-group select:focus {
            background: white;
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.5);
            outline: none;
        }

        /* Enhanced Button Styles */
        /* .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.95rem;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2980b9);
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #2980b9, #2573a7);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
        }

        .btn-print {
            background: linear-gradient(135deg, #95a5a6, #7f8c8d);
            color: white;
        }

        .btn-print:hover {
            background: linear-gradient(135deg, #7f8c8d, #6c7b7d);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(149, 165, 166, 0.4);
        }

        .btn-success {
            background: linear-gradient(135deg, #27ae60, #219a52);
            color: white;
        }

        .btn-success:hover {
            background: linear-gradient(135deg, #219a52, #1e8849);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(39, 174, 96, 0.4);
        }

        .btn-info {
            background: linear-gradient(135deg, #17a2b8, #138496);
            color: white;
        }

        .btn-info:hover {
            background: linear-gradient(135deg, #138496, #117a8b);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(23, 162, 184, 0.4);
        }

        .button-group {
            display: flex;
            gap: 1rem;
            align-items: center;
            flex-wrap: wrap;
            margin-top: 1.5rem;
            padding-top: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        } */

        /* Improved table styling with centered headers and background */
        .data-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            font-size: 13px;
        }

        .data-table th {
            background: #3498db;
            color: white;
            padding: 12px 8px;
            text-align: center;
            font-weight: 600;
            font-size: 12px;
            white-space: nowrap;
            border: 1px solid #2980b9;
        }

        .data-table td {
            padding: 8px 7px;
            border-bottom: 1px solid #ecf0f1;
            font-size: 12px;
            line-height: 1.2;
            vertical-align: top;
            text-align: center;
        }

        /* Item name column left-aligned */
        .data-table td:nth-child(3) {
            text-align: center;
        }

        /* Prevent text wrapping in most columns */
        .data-table td:not(:nth-child(3)) {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 150px;
        }

        /* Allow wrapping only for item/product name column (3rd column) */
        .data-table td:nth-child(3) {
            white-space: normal;
            word-wrap: break-word;
            max-width: 200px;
            min-width: 150px;
        }

        .data-table tr:hover {
            background: #f8f9fa;
        }

        /* Ensure table headers don't wrap and have consistent background */
        .data-table th {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            background: #3498db !important;
        }

        /* Increase font size for report tables on screen */
        #reports .data-table {
            font-size: 16px;
            /* Increased from 13px */
        }

        #reports .data-table th {
            font-size: 16px;
            /* Increased from 12px */
            padding: 14px 10px;
            /* Increased padding */
        }

        #reports .data-table td {
            font-size: 16px;
            /* Increased from 12px */
            padding: 10px 8px;
            /* Increased padding */
        }

        /* Make sure the table container can handle the larger text */
        #reports .table-container {
            font-size: 14px;
        }
    </style>
</head>

<body>
    <?php include_once('includes/header.php') ?>
    <div class="container">
        <div class="dashboard">
            <div class="dashboard-header">
                <h2 class="mb-4"><?= __("Admin Dashboard") ?></h2>
                <!-- <p>Welcome, <?php echo $_SESSION['username']; ?>! | Role: <?php echo ucfirst($_SESSION['user_role']); ?></p> -->
            </div>

            <!-- Quick Stats -->
            <div class="stats-grid">
                <div class="stat-card">
                    <h3><?= __("Total Sales Today") ?></h3>
                    <div class="number">$<?php echo number_format($today_sales ?: 0, 2); ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Total Items Sales Today") ?></h3>
                    <div class="number"><?php echo $item_today_sales ?: 0; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Active Cashiers") ?></h3>
                    <div class="number"><?php echo count($active_shifts); ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Low Stock Items") ?></h3>
                    <div class="number"><?php echo $low_stock_count; ?></div>
                </div>
                <div class="stat-card">
                    <h3><?= __("Total Products") ?>(<?= __("Qty") ?>)</h3>
                    <!-- <div class="number"><?#php echo count($products); ?></div> -->
                    <div class="number"><?php echo $product_counts['total_stock'] ?? 0; ?></div>

                </div>
            </div>

            <!-- Tabs Navigation -->
            <!-- <div class="tabs"> -->
                <div class="row bg-light p-1 rounded-3 mb-4 tabs">
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'posMonitoring' ? 'active' : ''; ?>" onclick="openTab(event, 'posMonitoring')"><?= __("POS Monitoring") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'stockManagement' ? 'active' : ''; ?>" onclick="openTab(event, 'stockManagement')"><?= __("Stock Management") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'reports' ? 'active' : ''; ?>" onclick="openTab(event, 'reports')"><?= __("Reports") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'customerManagement' ? 'active' : ''; ?>" onclick="openTab(event, 'customerManagement')"><?= __("Customer") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'userManagement' ? 'active' : ''; ?>" onclick="openTab(event, 'userManagement')"><?= __("User Management") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab <?php echo $current_tab === 'systemSettings' ? 'active' : ''; ?>" onclick="openTab(event, 'systemSettings')"><?= __("System Setting") ?></div>
                    </div>
                    <div class="col-6 col-md-4 col-lg-2">
                        <div class="tab" onclick="window.location.href='logs.php'"><?= __("System Logs") ?></div>
                    </div>
                </div>
            <!-- </div> -->


            <?php
            // <!-- POS Monitoring Tab -->
            include_once("includes/post-monitor.php");

            // <!-- Stock Management Tab -->
            include_once("includes/stock-management.php");

            // <!-- Reports Tab -->
            include_once("includes/report-tab.php");

            // <!-- Users Tab -->
            include_once("includes/user-list.php");

            // <!-- customer Management Tab -->

            include_once("includes/customer-list.php");
            ?>



            <!-- System Settings Tab -->
            <div id="systemSettings" class="tab-content <?php echo $current_tab === 'systemSettings' ? 'active' : ''; ?>">
                <h3><?= __("System Setting") ?></h3>
                <?php include_once('includes/shop-setting.php') ?>
            </div>
        </div>
        <!-- modal change password and profile  -->




    </div>
    <!-- <script src="assets/js/script.js"></script> -->
    <?php include_once('includes/script.php'); ?>
    <script>
        $(document).ready(function() {
            $("#recent_sale_table").dataTable({
                "order": [],
            });
            $("#productsTable").dataTable({
                "order": [],
            });
            $("#salebybill_table").dataTable({
                "order": [],
            });
            $("#salebyproduct").dataTable({
                "order": [],
            });
            $("#salecomparestock_table").dataTable({
                "order": [],
            });
            $("#customerTable").dataTable({
                order: []
            });
            $("#enddaystock_table").dataTable({
                "order": [],
            });

            
            
        });

        $(".datepicker").datepicker({
            format: 'dd M yyyy',
        });
    </script>
</body>

</html>